/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.axinodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.axinodes.AxiomNode;
import org.netbeans.modules.soa.ui.axinodes.NodeType;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIContainer;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomUtils {
    private static final String XPATH_ATTR_INDICATOR = "@";
    private static final String XPATH_SEPARATOR = "/";
    private static final String NAMESPACE_SEPARATOR = ":";
    private static final String DEFAULT_PREFIX = "ns";

    public static AXIComponent findGlobalComponent(AXIDocument aXIDocument, Class<? extends AXIComponent> clazz, SchemaComponent schemaComponent) {
        List list = clazz == null ? aXIDocument.getChildren() : aXIDocument.getChildren(clazz);
        for (AXIComponent aXIComponent : list) {
            if (aXIComponent.getPeer() != schemaComponent) continue;
            return aXIComponent;
        }
        return null;
    }

    public static Node[] processAxiComponent(AXIComponent aXIComponent, Lookup lookup) {
        Node[] nodeArray;
        if (aXIComponent == null) {
            return new Node[0];
        }
        NodeFactory nodeFactory = (NodeFactory)lookup.lookup(NodeFactory.class);
        assert (nodeFactory != null) : "Node factory has to be specified";
        ArrayList<Node> arrayList = new ArrayList<Node>();
        List list = aXIComponent.getChildElements();
        for (Object object : list) {
            Node node;
            if (!(object instanceof Element) || (node = nodeFactory.createNode(NodeType.ELEMENT, object, lookup)) == null) continue;
            arrayList.add(node);
        }
        if (aXIComponent instanceof AXIContainer) {
            nodeArray = ((AXIContainer)aXIComponent).getAttributes();
            for (Node node : nodeArray) {
                Node node2;
                if (!(node instanceof Attribute) || (node2 = nodeFactory.createNode(NodeType.ATTRIBUTE, node, lookup)) == null) continue;
                arrayList.add(node2);
            }
        }
        nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        return nodeArray;
    }

    public static String calculateSimpleXPath(AXIComponent aXIComponent) {
        PathItem pathItem;
        Object object;
        CharSequence charSequence;
        ArrayList<PathItem> arrayList = new ArrayList<PathItem>();
        while (aXIComponent != null) {
            charSequence = null;
            if (aXIComponent instanceof Element) {
                charSequence = ((Element)aXIComponent).getName();
            } else if (aXIComponent instanceof Attribute) {
                charSequence = ((Attribute)aXIComponent).getName();
            } else if (aXIComponent instanceof AXIType) {
                charSequence = ((AXIType)aXIComponent).getName();
            }
            Object object2 = object = AxiomUtils.isUnqualified(aXIComponent) ? "" : aXIComponent.getTargetNamespace();
            if (charSequence != null && ((String)charSequence).length() != 0) {
                pathItem = new PathItem(aXIComponent, (String)object, (String)charSequence, null);
                arrayList.add(pathItem);
            } else {
                arrayList.clear();
            }
            aXIComponent = aXIComponent.getParentElement();
        }
        charSequence = new StringBuffer();
        object = arrayList.listIterator(arrayList.size());
        while (object.hasPrevious()) {
            pathItem = (PathItem)object.previous();
            ((StringBuffer)charSequence).append(XPATH_SEPARATOR).append(pathItem.myLocalName);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static List<PathItem> prepareSimpleXPath(AxiomNode axiomNode) {
        Object t;
        ArrayList<PathItem> arrayList = new ArrayList<PathItem>();
        AxiomNode axiomNode2 = null;
        for (AxiomNode axiomNode3 = axiomNode; axiomNode3 != null && axiomNode3 instanceof AxiomNode; axiomNode3 = axiomNode3.getParentNode()) {
            axiomNode2 = axiomNode3;
            AxiomUtils.processNode(axiomNode2.getReference(), null, arrayList);
        }
        if (axiomNode2 != null && (t = axiomNode2.getReference()) != null) {
            for (AXIComponent aXIComponent = (AXIComponent)t.getParent(); aXIComponent != null; aXIComponent = (AXIComponent)aXIComponent.getParent()) {
                AxiomUtils.processNode(aXIComponent, null, arrayList);
            }
        }
        return arrayList;
    }

    public static void processNode(AXIComponent aXIComponent, String string, ArrayList<PathItem> arrayList) {
        String string2 = null;
        if (aXIComponent instanceof Element) {
            string2 = ((Element)aXIComponent).getName();
        } else if (aXIComponent instanceof Attribute) {
            string2 = ((Attribute)aXIComponent).getName();
        } else if (aXIComponent instanceof AXIType) {
            string2 = ((AXIType)aXIComponent).getName();
        }
        if (string2 != null && string2.length() != 0) {
            String string3 = AxiomUtils.isUnqualified(aXIComponent) ? null : aXIComponent.getTargetNamespace();
            PathItem pathItem = new PathItem(aXIComponent, string3, string2, string);
            arrayList.add(pathItem);
        }
    }

    public static String calculateSimpleXPath(AxiomNode axiomNode, AbstractDocumentComponent abstractDocumentComponent) {
        return AxiomUtils.calculateSimpleXPath(AxiomUtils.prepareSimpleXPath(axiomNode), abstractDocumentComponent);
    }

    public static String calculateSimpleXPath(List<PathItem> list, AbstractDocumentComponent abstractDocumentComponent) {
        Object object;
        Object object2;
        Map map = abstractDocumentComponent.getPrefixes();
        Map<String, String> map2 = AxiomUtils.getInverseMap(map);
        ListIterator<PathItem> listIterator = list.listIterator();
        Object var5_5 = null;
        while (listIterator.hasNext()) {
            object2 = listIterator.next();
            if (((PathItem)object2).myNamespace != null && ((PathItem)object2).myNamespace.length() > 0) {
                ((PathItem)object2).myNamespacePrefix = object = AxiomUtils.getUniquePrefix(abstractDocumentComponent, map, map2, ((PathItem)object2).myNamespace, DEFAULT_PREFIX);
                continue;
            }
            ((PathItem)object2).myNamespacePrefix = "";
        }
        object2 = new StringBuffer();
        listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            object = listIterator.previous();
            ((StringBuffer)object2).append(XPATH_SEPARATOR);
            if (((PathItem)object).myAxiComp instanceof Attribute) {
                ((StringBuffer)object2).append(XPATH_ATTR_INDICATOR);
            }
            if (((PathItem)object).myNamespacePrefix != null && ((PathItem)object).myNamespacePrefix.length() > 0) {
                ((StringBuffer)object2).append(((PathItem)object).myNamespacePrefix);
                ((StringBuffer)object2).append(NAMESPACE_SEPARATOR);
            }
            ((StringBuffer)object2).append(((PathItem)object).myLocalName);
            if (((PathItem)object).myPredicate == null) continue;
            ((StringBuffer)object2).append(((PathItem)object).myPredicate);
        }
        return ((StringBuffer)object2).toString();
    }

    public static String getUniquePrefix(AbstractDocumentComponent abstractDocumentComponent, String string, String string2) {
        Map map = abstractDocumentComponent.getPrefixes();
        Map<String, String> map2 = AxiomUtils.getInverseMap(map);
        return AxiomUtils.getUniquePrefix(abstractDocumentComponent, map, map2, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniquePrefix(AbstractDocumentComponent abstractDocumentComponent, Map<String, String> map, Map<String, String> map2, String string, String string2) {
        String string3;
        String string4 = map2.get(string);
        if (string4 != null && string4.length() > 0) {
            return string4;
        }
        int n = 1;
        while (map.containsKey(string3 = string2 + n)) {
            ++n;
        }
        AbstractDocumentModel abstractDocumentModel = abstractDocumentComponent.getModel();
        if (!abstractDocumentModel.isIntransaction()) {
            abstractDocumentModel.startTransaction();
        }
        try {
            abstractDocumentComponent.addPrefix(string3, string);
        }
        finally {
            if (abstractDocumentModel.isIntransaction()) {
                abstractDocumentModel.endTransaction();
            }
        }
        map.put(string3, string);
        map2.put(string, string3);
        return string3;
    }

    public static <A, B> Map<B, A> getInverseMap(Map<A, B> map) {
        if (map == null) {
            return null;
        }
        HashMap<B, A> hashMap = new HashMap<B, A>(map.size());
        for (Map.Entry<A, B> entry : map.entrySet()) {
            A a = entry.getKey();
            B b = entry.getValue();
            if (b == null || a == null) continue;
            hashMap.put(b, a);
        }
        return hashMap;
    }

    public static SchemaComponent getPartType(Part part) {
        NamedComponentReference namedComponentReference;
        SchemaComponent schemaComponent = null;
        NamedComponentReference namedComponentReference2 = part.getElement();
        if (namedComponentReference2 != null) {
            schemaComponent = (SchemaComponent)namedComponentReference2.get();
        }
        if (schemaComponent == null && (namedComponentReference = part.getType()) != null) {
            schemaComponent = (SchemaComponent)namedComponentReference.get();
        }
        return schemaComponent;
    }

    public static String getElementMultiplicityStr(Element element) {
        if (element != null) {
            String string = element.getMinOccurs();
            String string2 = element.getMaxOccurs();
            if (string.equals("1") && string2.equals("1")) {
                return null;
            }
            if ("unbounded".equals(string2)) {
                string2 = "*";
            }
            return "[" + string + ".." + string2 + "]";
        }
        return null;
    }

    public static NodeType.BadgeModificator getElementBadge(Element element) {
        if (element != null) {
            String string = element.getMinOccurs();
            String string2 = element.getMaxOccurs();
            if (string.equals("1") && string2.equals("1")) {
                return NodeType.BadgeModificator.SINGLE;
            }
            boolean bl = string.equals("0");
            boolean bl2 = false;
            if ("unbounded".equals(string2)) {
                bl2 = true;
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 1) {
                        bl2 = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bl && bl2) {
                return NodeType.BadgeModificator.OPTIONAL_REPEATING;
            }
            if (bl) {
                return NodeType.BadgeModificator.OPTIONAL;
            }
            if (bl2) {
                return NodeType.BadgeModificator.REPEATING;
            }
        }
        return NodeType.BadgeModificator.SINGLE;
    }

    public static String getAttributeTooltip(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        AXIType aXIType = attribute.getType();
        String string = aXIType != null ? aXIType.getName() : null;
        String string2 = attribute.getUse() == Attribute.Use.OPTIONAL ? "OPTIONAL" : null;
        String string3 = string == null ? attribute.getName() : SoaUtil.getFormattedHtmlString(true, new SoaUtil.TextChunk(attribute.getName()), new SoaUtil.TextChunk(string2, SoaUtil.HTML_GRAY), new SoaUtil.TextChunk(string, SoaUtil.HTML_GRAY));
        return string3;
    }

    public static String getElementTooltip(Element element) {
        if (element == null) {
            return null;
        }
        AXIType aXIType = element.getType();
        String string = aXIType != null ? aXIType.getName() : null;
        String string2 = AxiomUtils.getElementMultiplicityStr(element);
        String string3 = SoaUtil.getFormattedHtmlString(true, new SoaUtil.TextChunk(element.getName()), new SoaUtil.TextChunk(string2, SoaUtil.HTML_GRAY), new SoaUtil.TextChunk(string, SoaUtil.HTML_GRAY));
        return string3;
    }

    public static boolean isUnqualified(AXIComponent aXIComponent) {
        if (aXIComponent == null) {
            return false;
        }
        if (aXIComponent.isGlobal()) {
            return false;
        }
        SchemaComponent schemaComponent = aXIComponent.getPeer();
        if (schemaComponent == null) {
            return false;
        }
        Form form = null;
        if (schemaComponent instanceof LocalElement) {
            form = ((LocalElement)schemaComponent).getFormEffective();
        } else if (schemaComponent instanceof LocalAttribute) {
            form = ((LocalAttribute)schemaComponent).getFormEffective();
        }
        return Form.UNQUALIFIED.equals((Object)form);
    }

    public static class PathItem {
        public AXIComponent myAxiComp;
        public String myNamespacePrefix;
        public String myNamespace;
        public String myLocalName;
        public String myPredicate;

        public PathItem(AXIComponent aXIComponent, String string, String string2, String string3) {
            this.myAxiComp = aXIComponent;
            this.myNamespace = string;
            this.myLocalName = string2;
            this.myPredicate = string3;
        }

        public QName constructQName() {
            return new QName(this.myNamespace, this.myLocalName, this.myNamespacePrefix);
        }
    }
}

