/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.designer.jsf.DomProviderImpl;
import org.netbeans.modules.visualweb.designer.jsf.DomProviderServiceImpl;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.insync.Util;
import org.netbeans.modules.visualweb.insync.faces.Entities;
import org.netbeans.modules.visualweb.insync.markup.MarkupUnit;
import org.openide.ErrorManager;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

class InlineEditorSupportImpl
implements DomProvider.InlineEditorSupport,
EventListener {
    private final JsfForm jsfForm;
    private final DomProviderImpl domProviderImpl;
    private final MarkupDesignBean markupDesignBean;
    private final DesignProperty designProperty;
    private DomProvider.DomPosition begin;
    private DomProvider.DomPosition end;
    private DocumentFragment fragment;
    private String xpath;
    private Node text;
    private boolean hasBeenEdited = false;

    public InlineEditorSupportImpl(JsfForm jsfForm, DomProviderImpl domProviderImpl, MarkupDesignBean markupDesignBean, DesignProperty designProperty, String string) {
        this.jsfForm = jsfForm;
        this.domProviderImpl = domProviderImpl;
        this.markupDesignBean = markupDesignBean;
        this.designProperty = designProperty;
        this.xpath = string;
    }

    public boolean isEditingAllowed() {
        return DomProviderServiceImpl.isEditingAllowed(this.designProperty);
    }

    public String getValueSource() {
        return this.designProperty.getValueSource();
    }

    public void unset() {
        this.designProperty.unset();
    }

    public void setValue(String string) {
        this.designProperty.setValue((Object)string);
    }

    public String getName() {
        return this.designProperty.getPropertyDescriptor().getName();
    }

    public String getSpecialInitValue() {
        return DomProviderServiceImpl.getSpecialInitValue(this.designProperty);
    }

    private String getValue() {
        return (String)this.designProperty.getValue();
    }

    private String getDisplayName() {
        return this.designProperty.getPropertyDescriptor().getDisplayName();
    }

    private void setViaWriteMethod(String string) {
        Method method = this.designProperty.getPropertyDescriptor().getWriteMethod();
        try {
            method.invoke(this.markupDesignBean.getInstance(), string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
        }
    }

    public Element getRenderedElement() {
        Element element = this.markupDesignBean.getElement();
        return MarkupService.getRenderedElementForElement((Element)element);
    }

    public DocumentFragment createSourceFragment() {
        return this.domProviderImpl.createSourceFragment(this.markupDesignBean);
    }

    public String expandHtmlEntities(String string, boolean bl) {
        return Entities.expandHtmlEntities((String)string, (boolean)bl, (Node)this.markupDesignBean.getElement());
    }

    public boolean isEscaped() {
        return DomProviderServiceImpl.isEscapedDesignBean((DesignBean)this.markupDesignBean);
    }

    public void handleEvent(Event event) {
        Object object;
        Object object2;
        Object object3;
        this.hasBeenEdited = true;
        if (event instanceof MutationEvent) {
            object3 = (MutationEvent)event;
            object2 = object3.getPrevValue();
            object = object3.getNewValue();
            if (object2 != null && object != null && ((String)object2).equals(object)) {
                return;
            }
        }
        if ((object3 = (Node)((Object)event.getTarget())) == this.end.getNode()) {
            this.end = this.jsfForm.getDomDocumentImpl().createDomPosition(this.end.getNode(), object3.getNodeValue().length(), this.end.getBias());
        }
        object2 = (Node)((Object)event.getTarget());
        object = object2.getParentNode();
        if (!(object2 instanceof Element) || ((Element)object2).getTagName().equals(HtmlTag.BR.name)) {
            object2 = object;
            object = object.getParentNode();
            if (object2 instanceof Element) {
                MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)((Element)object2));
                if (markupDesignBean == null) {
                    markupDesignBean = this.markupDesignBean;
                }
                this.domProviderImpl.requestTextUpdate(markupDesignBean);
            }
        } else {
            this.domProviderImpl.requestChange(this.markupDesignBean);
        }
    }

    private void beanChanged() {
        this.domProviderImpl.beanChanged(this.markupDesignBean);
    }

    private void requestChange() {
        this.domProviderImpl.requestChange(this.markupDesignBean);
    }

    public void clearPrerendered() {
        this.domProviderImpl.setPrerenderedBean(null, null);
    }

    private boolean setPrerendered(DocumentFragment documentFragment) {
        return this.domProviderImpl.setPrerenderedBean(this.markupDesignBean, documentFragment);
    }

    private void setStyleParent(DocumentFragment documentFragment) {
        NodeList nodeList = documentFragment.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            Element element2 = this.markupDesignBean.getElement();
            CssProvider.getEngineService().setStyleParentForElement(element, element2);
            element = MarkupService.getRenderedElementForElement((Element)element);
            Element element3 = MarkupService.getRenderedElementForElement((Element)element2);
            if (element == null || element3 == null) continue;
            CssProvider.getEngineService().setStyleParentForElement(element, element3);
        }
    }

    private DocumentFragment renderDomFragment() {
        DocumentFragment documentFragment = this.domProviderImpl.renderHtmlForMarkupDesignBean(this.markupDesignBean);
        documentFragment = (DocumentFragment)this.domProviderImpl.getJsfForm().getJspDom().importNode(documentFragment, true);
        this.jsfForm.updateErrorsInComponent();
        return documentFragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareAttributeInlineEditor(boolean bl) {
        Object object;
        Object object2;
        this.fragment = this.createSourceFragment();
        if (this.fragment == null) {
            return bl;
        }
        if (!this.setPrerendered(this.fragment)) {
            return bl;
        }
        Node node = null;
        if (this.xpath != null && (node = JsfSupportUtilities.findPropertyNode(this.fragment, this.xpath)) == null && this.getValueSource() == null) {
            object2 = this.getValue();
            object = this.getDisplayName();
            this.setViaWriteMethod((String)object);
            try {
                this.clearPrerendered();
                this.fragment = this.renderDomFragment();
                this.setPrerendered(this.fragment);
                node = JsfSupportUtilities.findPropertyNode(this.fragment, this.xpath);
                bl = true;
                this.requestChange();
                Object var6_5 = null;
                this.setViaWriteMethod((String)object2);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setViaWriteMethod((String)object2);
                throw throwable;
            }
        }
        if (node != null) {
            this.text = this.findTextNode(node);
            if (this.text == null) {
                this.text = node;
            }
        } else {
            this.text = this.findTextNode(this.fragment);
        }
        if (this.text != null) {
            if (this.text.getNodeType() == 3) {
                this.begin = this.jsfForm.getDomDocumentImpl().createDomPosition(this.text, 0, DomProvider.DomPosition.Bias.FORWARD);
                this.end = this.jsfForm.getDomDocumentImpl().createDomPosition(this.text, this.text.getNodeValue().length(), DomProvider.DomPosition.Bias.BACKWARD);
            } else {
                object2 = this.text.getChildNodes();
                if (object2.getLength() > 0) {
                    this.begin = this.jsfForm.getDomDocumentImpl().createDomPosition(object2.item(0), 0, DomProvider.DomPosition.Bias.FORWARD);
                    object = object2.item(object2.getLength() - 1);
                    this.end = object.getNodeType() == 3 ? this.jsfForm.getDomDocumentImpl().createDomPosition((Node)object, object.getNodeValue().length(), DomProvider.DomPosition.Bias.BACKWARD) : this.jsfForm.getDomDocumentImpl().createDomPosition((Node)object, object.getChildNodes().getLength(), DomProvider.DomPosition.Bias.BACKWARD);
                } else {
                    this.begin = this.jsfForm.getDomDocumentImpl().createDomPosition(this.text, 0, DomProvider.DomPosition.Bias.FORWARD);
                    this.end = this.jsfForm.getDomDocumentImpl().createDomPosition(this.text, this.text.getChildNodes().getLength(), DomProvider.DomPosition.Bias.BACKWARD);
                }
            }
        } else {
            this.begin = this.jsfForm.getDomDocumentImpl().createDomPosition(this.fragment, 0, DomProvider.DomPosition.Bias.FORWARD);
            this.end = this.jsfForm.getDomDocumentImpl().createDomPosition(this.fragment, this.fragment.getChildNodes().getLength(), DomProvider.DomPosition.Bias.FORWARD);
        }
        this.registerDomListeners();
        return bl;
    }

    private Node findTextNode(Node node) {
        assert (node != null);
        String string = this.getValue();
        if (string == null || string.length() == 0) {
            Node node2 = this.findFirstTextNode(node);
            if (node2 == null) {
                node2 = this.findDesignStyleClass(node);
            }
            return node2;
        }
        return this.findText(node, string);
    }

    private Node findFirstTextNode(Node node) {
        Object object;
        if (node.getNodeType() == 3 && !JsfSupportUtilities.onlyWhitespace((String)(object = node.getNodeValue()))) {
            return node;
        }
        object = node.getChildNodes();
        int n = object.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2;
            Node node3 = object.item(i);
            if (node3.getNodeType() == 1 && (node.getNodeName().equals(HtmlTag.SCRIPT.name) || node.getNodeName().equals(HtmlTag.STYLE.name)) || (node2 = this.findFirstTextNode(node3)) == null) continue;
            return node2;
        }
        return null;
    }

    private Node findDesignStyleClass(Node node) {
        Object object;
        if (node.getNodeType() == 1 && (object = (Element)node).getAttribute("class").indexOf("rave-uninitialized-text") != -1) {
            return node;
        }
        object = node.getChildNodes();
        int n = object.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = this.findDesignStyleClass(object.item(i));
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    private Node findText(Node node, String string) {
        Object object;
        int n;
        if (node.getNodeType() == 3 && (n = ((String)(object = node.getNodeValue())).indexOf(string)) != -1 && string.length() > 0) {
            Text text = (Text)node;
            if (text.getLength() != string.length()) {
                if (n != 0) {
                    node = text.splitText(n);
                    text = (Text)node;
                }
                if (text.getLength() > string.length()) {
                    text.splitText(string.length());
                }
            }
            return node;
        }
        object = node.getChildNodes();
        int n2 = object.getLength();
        for (n = 0; n < n2; ++n) {
            Node node2 = this.findText(object.item(n), string);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public DomProvider.DomPosition getBeginPosition() {
        return this.begin;
    }

    public DomProvider.DomPosition getEndPosition() {
        return this.end;
    }

    public Node findXPathNodeForComponentRootElement(Element element) {
        Element element2;
        if (this.xpath != null && (element2 = element) != null) {
            return JsfSupportUtilities.findPropertyNode(element2, this.xpath);
        }
        return null;
    }

    public DocumentFragment getFragment() {
        return this.fragment;
    }

    public Node getText() {
        return this.text;
    }

    private void registerDomListeners() {
        if (this.fragment == null) {
            return;
        }
        EventTarget eventTarget = (EventTarget)((Object)this.fragment);
        InlineEditorSupportImpl inlineEditorSupportImpl = this;
        eventTarget.addEventListener("DOMAttrModified", inlineEditorSupportImpl, false);
        eventTarget.addEventListener("DOMNodeInserted", inlineEditorSupportImpl, false);
        eventTarget.addEventListener("DOMNodeInsertedIntoDocument", inlineEditorSupportImpl, false);
        eventTarget.addEventListener("DOMNodeRemoved", inlineEditorSupportImpl, false);
        eventTarget.addEventListener("DOMNodeRemovedFromDocument", inlineEditorSupportImpl, false);
        eventTarget.addEventListener("DOMCharacterDataModified", inlineEditorSupportImpl, false);
        eventTarget.addEventListener("DOMDocumentReplaced", inlineEditorSupportImpl, false);
    }

    private void unregisterDomListeners() {
        if (this.fragment == null) {
            return;
        }
        EventTarget eventTarget = (EventTarget)((Object)this.fragment);
        InlineEditorSupportImpl inlineEditorSupportImpl = this;
        eventTarget.removeEventListener("DOMAttrModified", inlineEditorSupportImpl, false);
        eventTarget.removeEventListener("DOMNodeInserted", inlineEditorSupportImpl, false);
        eventTarget.removeEventListener("DOMNodeInsertedIntoDocument", inlineEditorSupportImpl, false);
        eventTarget.removeEventListener("DOMNodeRemoved", inlineEditorSupportImpl, false);
        eventTarget.removeEventListener("DOMNodeRemovedFromDocument", inlineEditorSupportImpl, false);
        eventTarget.removeEventListener("DOMCharacterDataModified", inlineEditorSupportImpl, false);
        eventTarget.removeEventListener("DOMDocumentReplaced", inlineEditorSupportImpl, false);
    }

    public void cleanAttributeInlineEditor(boolean bl) {
        this.clearPrerendered();
        if (this.fragment != null) {
            this.unregisterDomListeners();
        }
        if (bl) {
            this.beanChanged();
            return;
        }
        if (!this.hasBeenEdited) {
            this.requestChange();
            return;
        }
        String string = null;
        Node node = this.getText();
        Node node2 = node;
        if (node2 == null) {
            node2 = this.fragment;
            if (node2 == null) {
                return;
            }
        } else if (node2.getNodeType() == 3) {
            string = node.getNodeValue();
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer(300);
            NodeList nodeList = node2.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                stringBuffer.append(Util.getHtmlStream((Node)node3));
            }
            string = stringBuffer.toString();
        }
        if (this.isEscaped()) {
            string = this.expandHtmlEntities(string, false);
        }
        if (string != null && string.length() == 0) {
            this.unset();
        } else {
            this.setValue(string);
        }
    }
}

