/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.projects.WebProjectRestSupport;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStubsGenerator
extends AbstractGenerator {
    public static final String RESOURCES = "resources";
    public static final String TEMPLATES = "templates";
    public static final String DOJO = "dojo";
    public static final String REST = "rest";
    public static final String RDJ = "rdj";
    public static final String DATA = "data";
    public static final String WIDGET = "widget";
    public static final String RJS = "rjs";
    public static final String TABLE = "table";
    public static final String STORE = "Store";
    public static final String CSS = "css";
    public static final String JS = "js";
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String TXT = "txt";
    public static final String JSON = "json";
    public static final String GIF = "gif";
    public static final String JSP = "jsp";
    public static final String PHP = "php";
    public static final String RHTML = "rhtml";
    public static final String EJS = "ejs";
    public static final String IMAGES = "images";
    public static final String BUNDLE = "Bundle";
    public static final String PROPERTIES = "properties";
    public static final String LIBS = "libs";
    public static final String DJD43 = "djd43";
    public static final String JMAKI_DOJO = "jmaki-dojo";
    public static final String JMAKI_COMP_LIB = "jmakicomplib";
    public static final String JS_SUPPORT = "Support";
    public static final String JS_TESTSTUBS = "TestStubs";
    public static final String JS_README = "Readme";
    public static final String JS_TESTSTUBS_TEMPLATE = "Templates/WebServices/JsTestStubs.html";
    public static final String JS_STUBSUPPORT_TEMPLATE = "Templates/WebServices/JsStubSupport.js";
    public static final String JS_PROJECTSTUB_TEMPLATE = "Templates/WebServices/JsProjectStub.js";
    public static final String JS_CONTAINERSTUB_TEMPLATE = "Templates/WebServices/JsContainerStub.js";
    public static final String JS_CONTAINERITEMSTUB_TEMPLATE = "Templates/WebServices/JsContainerItemStub.js";
    public static final String JS_GENERICSTUB_TEMPLATE = "Templates/WebServices/JsGenericStub.js";
    public static final String JS_README_TEMPLATE = "Templates/WebServices/JsReadme.html";
    public static final String PROXY = "RestProxyServlet";
    public static final String PROXY_URL = "/restproxy";
    public static final String PROXY_TEMPLATE = "Templates/WebServices/RestProxyServlet.txt";
    public static final String TTL_DojoResources_Stubs = "TTL_DojoResources_Stubs";
    public static final String MSG_Readme = "MSG_Readme";
    public static final String MSG_TestPage = "MSG_TestPage";
    public static final String TTL_RestClient_Stubs = "TTL_RestClient_Stubs";
    public static final String TTL_JMakiWidget_Stubs = "TTL_JMakiWidget_Stubs";
    public static final String MSG_SelectResource = "MSG_SelectResource";
    public static final String MSG_JS_Readme_Content = "MSG_JS_Readme_Content";
    public static final String MSG_JMaki_Readme_Content = "MSG_JMaki_Readme_Content";
    public static final String DOJO_RESTSTORE = "RestStore";
    public static final String DOJO_COLLECTIONSTORE = "CollectionStore";
    public static final String DOJO_RESOURCESTABLE = "ResourcesTable";
    public static final String DOJO_TESTRESOURCESTABLE = "TestResourcesTable";
    public static final String DOJO_SUPPORT = "Support";
    public static final String DOJO_RESTSTORE_TEMPLATE = "Templates/WebServices/DojoRestStore.js";
    public static final String DOJO_COLLECTIONSTORE_TEMPLATE = "Templates/WebServices/DojoCollectionStore.js";
    public static final String DOJO_RESOURCESTABLE_TEMPLATE = "Templates/WebServices/DojoResourcesTable.js";
    public static final String DOJO_SUPPORT_TEMPLATE = "Templates/WebServices/DojoSupport.js";
    public static final String DOJO_TESTRESOURCESTABLE_TEMPLATE = "Templates/WebServices/DojoTestResourcesTable.html";
    public static final String JMAKI_README = "Readme";
    public static final String JMAKI_COMPONENT = "component";
    public static final String JMAKI_TESTRESOURCESTABLE = "TestResourcesTable";
    public static final String JMAKI_RESOURCESTABLE_SRC = "JmakiResourcesTable";
    public static final String JMAKI_RESOURCESTABLEUP_SRC = "JmakiResourcesTableUp";
    public static final String JMAKI_RESOURCESTABLEDOWN_SRC = "JmakiResourcesTableDown";
    public static final String JMAKI_RESOURCESTABLE_DEST = "rtable";
    public static final String JMAKI_RESOURCESTABLEUP_DEST = "rtableUp";
    public static final String JMAKI_RESOURCESTABLEDOWN_DEST = "rtableDown";
    public static final String JMAKI_README_TEMPLATE = "Templates/WebServices/JmakiReadme.html";
    public static final String JMAKI_COMPONENTCSS_TEMPLATE = "Templates/WebServices/JmakiComponent.css";
    public static final String JMAKI_COMPONENTHTM_TEMPLATE = "Templates/WebServices/JmakiComponent.htm";
    public static final String JMAKI_COMPONENTJS_TEMPLATE = "Templates/WebServices/JmakiComponent.js";
    public static final String JMAKI_RESTBUNDLE_TEMPLATE = "Templates/WebServices/JmakiRestBundle.properties";
    public static final String JMAKI_TEMPLATESBUNDLE_TEMPLATE = "Templates/WebServices/JmakiTemplatesBundle.properties";
    public static final String JMAKI_TEMPLATESEJS_TEMPLATE = "Templates/WebServices/JmakiTemplates.ejs";
    public static final String JMAKI_TEMPLATESJSP_TEMPLATE = "Templates/WebServices/JmakiTemplates.jsp";
    public static final String JMAKI_TEMPLATESPHP_TEMPLATE = "Templates/WebServices/JmakiTemplates.php";
    public static final String JMAKI_TEMPLATESRHTML_TEMPLATE = "Templates/WebServices/JmakiTemplates.rhtml";
    public static final String JMAKI_TESTRESOURCESTABLE_TEMPLATE = "Templates/WebServices/JmakiTestResourcesTable.jsp";
    public static final String JMAKI_WIDGETJSON_TEMPLATE = "Templates/WebServices/JmakiWidget.json";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "8080";
    public static final String DEFAULT_BASE_URL = "http://localhost:8080";
    public static final String BASE_URL_TOKEN = "___BASE_URL___";
    public static final String FILE_ENCODING_TOKEN = "__FILE_ENCODING__";
    private FileObject rootFolder;
    private Project p;
    private boolean createJmaki;
    private boolean overwrite;
    private String projectName;
    private ClientStubModel model;
    private FileObject resourcesDir;
    private FileObject dojoDir;
    private FileObject restDir;
    private FileObject rdjDir;
    private FileObject rjsDir;
    private FileObject templatesDir;
    private String includeJs = "";
    private String libsJs = "";
    private String resourcesDojo = "";
    private String requireDojo = "";
    protected String dojoResSelList = "";
    protected String jmakiResSelList = "";
    protected String jmakiResTagList = "";
    private static final int READ_BUF_SIZE = 65536;
    private static final int WRITE_BUF_SIZE = 65536;
    private FileObject wadlFile;
    private String folderName;
    private String baseUrl;
    private String proxyUrl;
    private String baseEncoding = "UTF-8";

    public ClientStubsGenerator(FileObject fileObject, String string, Project project, boolean bl, boolean bl2) throws IOException {
        assert (fileObject != null);
        assert (project != null);
        this.rootFolder = fileObject;
        this.folderName = string;
        this.p = project;
        this.createJmaki = bl;
        this.overwrite = bl2;
        this.projectName = ProjectUtils.getInformation((Project)this.getProject()).getName();
    }

    public ClientStubsGenerator(FileObject fileObject, String string, FileObject fileObject2, boolean bl, boolean bl2) throws IOException {
        assert (fileObject != null);
        assert (fileObject2 != null);
        this.rootFolder = fileObject;
        this.folderName = string;
        this.wadlFile = fileObject2;
        this.createJmaki = bl;
        this.overwrite = bl2;
        this.projectName = "NewProject";
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public Project getProject() {
        return this.p;
    }

    public boolean canOverwrite() {
        return this.overwrite;
    }

    public boolean createJmaki() {
        return this.createJmaki;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ClientStubModel getModel() {
        return this.model;
    }

    public String getDefaultBaseUrl() {
        return "http://localhost:8080/";
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String string) {
        this.proxyUrl = string;
    }

    public String getBaseEncoding() {
        return this.baseEncoding;
    }

    public void setBaseEncoding(String string) {
        this.baseEncoding = string;
    }

    private String getApplicationNameFromUrl(String string) {
        String[] stringArray;
        String string2 = string.replaceAll("http://", "");
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((stringArray = string2.split("/")) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3 == null || !string3.startsWith(DEFAULT_HOST) || i + 1 >= stringArray.length || stringArray[i + 1] == null || stringArray[i + 1].trim().length() <= 0) continue;
                return stringArray[i + 1];
            }
        }
        return ClientStubModel.normailizeName(string2);
    }

    private String findBaseUrl(Project project) {
        String string = null;
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        if (fileObject != null) {
            String string2 = this.getProperty(fileObject, "deploy.ant.properties.file");
            FileObject fileObject2 = FileUtil.toFileObject((File)new File(string2));
            string = this.getProperty(fileObject2, "sjsas.url");
            if (string == null) {
                string = this.getProperty(fileObject2, "tomcat.url");
            }
            if (string != null) {
                string = string.replace("\\", "");
            }
        }
        return string;
    }

    private String findBaseEncoding(Project project) {
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        return this.getProperty(fileObject, "source.encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(FileObject fileObject, String string) {
        if (fileObject == null) {
            return null;
        }
        FileLock fileLock = null;
        try {
            String string2;
            fileLock = fileObject.lock();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.trim().startsWith(string + "=")) continue;
                String string3 = string2.trim().split("=")[1];
                return string3;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return null;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (progressHandle != null) {
            this.initProgressReporting(progressHandle, false);
        }
        this.model = new ClientStubModel();
        if (this.p != null) {
            this.model.buildModel(this.p);
            object6 = this.findBaseUrl(this.p);
            if (object6 == null) {
                object6 = this.getDefaultBaseUrl();
            }
            if ((object5 = this.findBaseUrl((Project)(object4 = FileOwnerQuery.getOwner((FileObject)this.getRootFolder())))) == null) {
                object5 = object6;
            }
            object3 = WebProjectRestSupport.getRestServletMapping(this.p);
            object2 = "/resources";
            if (object3 != null) {
                object2 = object3.getUrlPattern();
            }
            if (((String)object2).endsWith("/*")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
            }
            this.setBaseUrl((String)(((String)object6).endsWith("/") ? object6 : (String)object6 + "/") + this.getProjectName() + (String)(((String)object2).startsWith("/") ? object2 : "/" + (String)object2));
            this.setProxyUrl((String)(((String)object5).endsWith("/") ? object5 : (String)object5 + "/") + ProjectUtils.getInformation((Project)object4).getName() + PROXY_URL);
            this.setBaseEncoding(this.findBaseEncoding(this.p));
        } else if (this.wadlFile != null) {
            object6 = this.model.buildModel(this.wadlFile);
            if (object6 == null) {
                object6 = this.getDefaultBaseUrl();
            }
            this.setBaseUrl((String)object6);
            this.setProxyUrl((String)object6 + ".." + PROXY_URL);
            this.projectName = this.getApplicationNameFromUrl((String)object6);
        }
        object6 = this.model.getResources();
        this.includeJs = "    rdj.includeJS('../rjs/" + this.getProjectName().toLowerCase() + "/" + this.getProjectName() + "." + JS + "');\n";
        this.libsJs = "                   '../rjs/" + this.getProjectName().toLowerCase() + "/" + this.getProjectName() + "." + JS + "',\n";
        this.resourcesDojo = "";
        this.requireDojo = "";
        object4 = object6.iterator();
        while (object4.hasNext()) {
            object5 = (ClientStubModel.Resource)object4.next();
            this.includeJs = this.includeJs + "    rdj.includeJS('../rjs/" + this.getProjectName().toLowerCase() + "/" + ((ClientStubModel.Resource)object5).getName() + "." + JS + "');\n";
            this.libsJs = this.libsJs + "                   '../rjs/" + this.getProjectName().toLowerCase() + "/" + ((ClientStubModel.Resource)object5).getName() + "." + JS + "',\n";
            if (!((ClientStubModel.Resource)object5).isContainer()) continue;
            this.resourcesDojo = this.resourcesDojo + "                   '../rdj/data/" + ((ClientStubModel.Resource)object5).getName() + STORE + "." + JS + "',\n";
            this.requireDojo = this.requireDojo + "djd43.require(\"rdj.data." + ((ClientStubModel.Resource)object5).getName() + STORE + "\");\n";
        }
        if (this.createJmaki()) {
            this.resourcesDir = this.createFolder(this.getRootFolder(), RESOURCES);
            this.dojoDir = this.createFolder(this.resourcesDir, DOJO);
            this.restDir = this.createFolder(this.dojoDir, REST);
            this.rjsDir = this.createFolder(this.restDir, RJS);
            this.rdjDir = this.createFolder(this.restDir, RDJ);
            this.templatesDir = this.createFolder(this.getRootFolder(), TEMPLATES);
            this.initJs(this.p);
            this.initDojo(this.p, (List<ClientStubModel.Resource>)object6);
            this.initJmaki(this.p, (List<ClientStubModel.Resource>)object6);
        } else {
            this.rjsDir = this.createFolder(this.getRootFolder(), this.getFolderName());
            this.initJs(this.p);
        }
        object4 = this.createFolder(this.rjsDir, this.getProjectName().toLowerCase());
        this.createDataObjectFromTemplate(JS_PROJECTSTUB_TEMPLATE, (FileObject)object4, this.getProjectName(), JS, this.canOverwrite());
        this.updateProjectStub(object4.getFileObject(this.getProjectName(), JS), this.getProjectName(), "");
        object5 = object6.iterator();
        while (object5.hasNext()) {
            object3 = (ClientStubModel.Resource)object5.next();
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_GeneratingClass", (Object)((ClientStubModel.Resource)object3).getName(), (Object)JS));
            }
            object2 = null;
            object = ((ClientStubModel.Resource)object3).getRepresentation().getRoot();
            object2 = ((ClientStubModel.Resource)object3).isContainer() && object != null && ((ClientStubModel.RepresentationNode)object).getChildren().size() > 0 ? new ContainerJavaScript((ClientStubModel.Resource)object3, (FileObject)object4) : (object != null ? new ContainerItemJavaScript((ClientStubModel.Resource)object3, (FileObject)object4) : new GenericResourceJavaScript((ClientStubModel.Resource)object3, (FileObject)object4));
            ((ResourceJavaScript)object2).generate();
            if (!this.createJmaki()) continue;
            new ResourceDojoComponents((ClientStubModel.Resource)object3, this.rdjDir).generate();
            new ResourceJmakiComponent((ClientStubModel.Resource)object3, this.restDir).generate();
            stringArray = new File(FileUtil.toFile((FileObject)this.templatesDir), DOJO + File.separator + REST);
            FileUtil.createFolder((File)stringArray);
            new ResourceJmakiTemplate((ClientStubModel.Resource)object3, FileUtil.toFileObject((File)stringArray)).generate();
        }
        this.updateRestStub(this.rjsDir.getFileObject(JS_TESTSTUBS, HTML), (List<ClientStubModel.Resource>)object6, "");
        object5 = new HashSet();
        if (this.createJmaki()) {
            FileObject fileObject;
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_CopyLibs", (Object)DJD43, (Object)JS));
            }
            this.copyDojoLibs();
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_GeneratingZip", (Object)this.getProjectName(), (Object)"zip"));
            }
            object3 = FileUtil.toFile((FileObject)this.resourcesDir.getParent().getParent());
            object2 = FileUtil.toFile((FileObject)this.dojoDir.getFileObject(RESOURCES));
            object = new File((File)object3, this.getProjectName() + ".zip");
            stringArray = new String[]{FileUtil.toFile((FileObject)this.restDir).getAbsolutePath(), FileUtil.toFile((FileObject)this.templatesDir).getAbsolutePath(), FileUtil.toFile((FileObject)this.resourcesDir.getParent()).getAbsolutePath() + File.separator + BUNDLE + "." + PROPERTIES, ((File)object2).getAbsolutePath()};
            String[] stringArray2 = new String[]{File.separator + RESOURCES + File.separator + DOJO, "", "", File.separator + RESOURCES + File.separator + DOJO};
            ClientStubsGenerator.zip((File)object, stringArray, stringArray2);
            FileObject fileObject2 = this.restDir.getFileObject("TestResourcesTable", JSP);
            if (fileObject2 != null) {
                object5.add(fileObject2);
            }
            if ((fileObject = this.restDir.getFileObject("Readme", TXT)) != null) {
                object5.add(fileObject);
            }
        } else {
            object3 = this.rjsDir.getFileObject(JS_TESTSTUBS, HTML);
            if (object3 != null) {
                object5.add(object3);
            }
            if ((object2 = this.rjsDir.getFileObject("Readme", TXT)) != null) {
                object5.add(object2);
            }
        }
        return object5;
    }

    private FileObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2, String string3, boolean bl) throws IOException {
        DataObject dataObject;
        FileObject fileObject2 = fileObject.getFileObject(string2, string3);
        if (fileObject2 != null) {
            if (bl) {
                dataObject = DataObject.find((FileObject)fileObject2);
                if (dataObject != null) {
                    dataObject.delete();
                }
            } else {
                return fileObject2;
            }
        }
        dataObject = RestUtils.createDataObjectFromTemplate(string, fileObject, string2);
        return dataObject.getPrimaryFile();
    }

    private void copyDojoLibs() throws FileNotFoundException, IOException {
        String string = System.getProperty("netbeans.user");
        if (string == null || string.length() == 0) {
            throw new RuntimeException("Cannot locate netbeans user folder.");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("NetBeans user folder (" + file.getPath() + ") does not exist.");
        }
        File file2 = new File(file, JMAKI_COMP_LIB);
        if (!file2.exists()) {
            throw new RuntimeException("Cannot find jMaki component folder (" + file2 + ").");
        }
        File file3 = this.findDojoLibrary(file2);
        if (file3 != null) {
            ClientStubsGenerator.unzip(new FileInputStream(file3), this.resourcesDir.getParent(), this.canOverwrite());
        } else {
            File file4 = new File(file2, RESOURCES + File.separator + DOJO + File.separator + RESOURCES);
            File file5 = FileUtil.toFile((FileObject)this.dojoDir);
            FileSystem fileSystem = FileUtil.toFileObject((File)file5).getFileSystem();
            this.copyDirectory(fileSystem, file4, file5);
        }
        if (this.dojoDir.getFileObject(RESOURCES) == null) {
            throw new IOException("Copying dojo libs from :" + file2.getAbsolutePath() + " to " + this.resourcesDir.getParent() + " failed.");
        }
    }

    private File findDojoLibrary(File file) {
        File file2 = null;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string != null && string.startsWith(ClientStubsGenerator.JMAKI_DOJO) && string.endsWith(".zip");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray != null && fileArray.length > 0) {
            file2 = fileArray[0];
        }
        return file2;
    }

    public void copyDirectory(FileSystem fileSystem, final File file, final File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.copyDirectory(fileSystem, new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            if (!file.exists()) {
                throw new IOException("File or directory does not exist.");
            }
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                        ((OutputStream)fileOutputStream).close();
                    }
                }
            });
        }
    }

    private void initJs(Project project) throws IOException {
        TokenReplacer tokenReplacer = new TokenReplacer();
        tokenReplacer.addToken(TTL_RestClient_Stubs, NbBundle.getMessage(ClientStubsGenerator.class, (String)TTL_RestClient_Stubs));
        tokenReplacer.addToken(MSG_Readme, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_Readme));
        tokenReplacer.addToken(MSG_TestPage, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_TestPage));
        tokenReplacer.addToken(MSG_JS_Readme_Content, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_JS_Readme_Content));
        tokenReplacer.addToken(FILE_ENCODING_TOKEN, this.getBaseEncoding());
        FileObject fileObject = this.createDataObjectFromTemplate(JS_TESTSTUBS_TEMPLATE, this.rjsDir, JS_TESTSTUBS, HTML, false);
        tokenReplacer.replaceTokens(fileObject);
        this.createDataObjectFromTemplate(JS_STUBSUPPORT_TEMPLATE, this.rjsDir, "Support", JS, false);
        fileObject = this.createDataObjectFromTemplate(JS_README_TEMPLATE, this.rjsDir, "Readme", HTML, false);
        tokenReplacer.replaceTokens(fileObject);
        fileObject = this.createDataObjectFromTemplate(PROXY_TEMPLATE, this.rjsDir, PROXY, TXT, false);
        File file = new File(FileUtil.toFile((FileObject)this.rjsDir), CSS);
        file.mkdirs();
        this.copySupportFiles(file);
    }

    private void initDojo(Project project, List<ClientStubModel.Resource> list) throws IOException {
        TokenReplacer tokenReplacer = new TokenReplacer();
        tokenReplacer.addToken(TTL_DojoResources_Stubs, NbBundle.getMessage(ClientStubsGenerator.class, (String)TTL_DojoResources_Stubs));
        tokenReplacer.addToken(MSG_Readme, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_Readme));
        tokenReplacer.addToken(MSG_TestPage, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_TestPage));
        tokenReplacer.addToken(MSG_SelectResource, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_SelectResource));
        tokenReplacer.addToken(BASE_URL_TOKEN, this.getBaseUrl());
        tokenReplacer.addToken(FILE_ENCODING_TOKEN, this.getBaseEncoding());
        this.createFolder(this.rdjDir, DATA);
        FileObject fileObject = this.createFolder(this.rdjDir, WIDGET);
        ClientStubModel.Resource resource = null;
        for (ClientStubModel.Resource resource2 : list) {
            if (!resource2.isContainer()) continue;
            resource = resource2;
            break;
        }
        this.dojoResSelList = this.createDojoResourceSelectList(list);
        this.jmakiResSelList = this.createJmakiResourceSelectList(list);
        this.jmakiResTagList = this.createJmakiResourceTagList(list);
        this.createDataObjectFromTemplate(DOJO_RESOURCESTABLE_TEMPLATE, fileObject, DOJO_RESOURCESTABLE, JS, this.canOverwrite());
        FileObject fileObject2 = this.createDataObjectFromTemplate(DOJO_SUPPORT_TEMPLATE, this.rdjDir, "Support", JS, false);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.rdjDir).replaceTokens(fileObject2);
        }
        fileObject2 = this.createDataObjectFromTemplate(DOJO_TESTRESOURCESTABLE_TEMPLATE, this.rdjDir, "TestResourcesTable", HTML, false);
        tokenReplacer.replaceTokens(fileObject2);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.rdjDir).replaceTokens(fileObject2);
        }
    }

    private void initJmaki(Project project, List<ClientStubModel.Resource> list) throws IOException {
        TokenReplacer tokenReplacer = new TokenReplacer();
        tokenReplacer.addToken(TTL_JMakiWidget_Stubs, NbBundle.getMessage(ClientStubsGenerator.class, (String)TTL_JMakiWidget_Stubs));
        tokenReplacer.addToken(MSG_Readme, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_Readme));
        tokenReplacer.addToken(MSG_TestPage, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_TestPage));
        tokenReplacer.addToken(MSG_JMaki_Readme_Content, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_JMaki_Readme_Content));
        tokenReplacer.addToken(FILE_ENCODING_TOKEN, this.getBaseEncoding());
        FileObject fileObject = this.createDataObjectFromTemplate(JMAKI_README_TEMPLATE, this.restDir, "Readme", HTML, this.canOverwrite());
        tokenReplacer.replaceTokens(fileObject);
        this.createDataObjectFromTemplate(JMAKI_RESTBUNDLE_TEMPLATE, this.getRootFolder(), BUNDLE, PROPERTIES, this.canOverwrite());
        ClientStubModel.Resource resource = null;
        for (ClientStubModel.Resource resource2 : list) {
            if (!resource2.isContainer()) continue;
            resource = resource2;
            break;
        }
        fileObject = this.createDataObjectFromTemplate(JMAKI_TESTRESOURCESTABLE_TEMPLATE, this.restDir, "TestResourcesTable", JSP, false);
        tokenReplacer.replaceTokens(fileObject);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.restDir).replaceTokens(fileObject);
        }
    }

    private void copySupportFiles(File file) throws IOException {
        String[] stringArray = new String[]{"clientstubs.css", "css_master-all.css", "images/background_border_bottom.gif", "images/pbsel.png", "images/bg_gradient.gif", "images/pname-clientstubs.png", "images/level1_selected-1lvl.jpg", "images/primary-enabled.gif", "images/masthead.png", "images/primary-roll.gif", "images/pbdis.png", "images/secondary-enabled.gif", "images/pbena.png", "images/tbsel.png", "images/pbmou.png", "images/tbuns.png"};
        File file2 = new File(file, IMAGES);
        file2.mkdirs();
        for (String string : stringArray) {
            RestSupport.copyFile((File)file, (String)string);
        }
    }

    protected String createDojoResourceSelectList(List<ClientStubModel.Resource> list) {
        String string = "";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            string = string + "            <option value='" + this.getBaseUrl() + "/" + resource.getRepresentation().getRoot().getName() + "/;" + resource.getName() + "'>" + resource.getName() + "</option>\n";
        }
        return string;
    }

    protected String createJmakiResourceSelectList(List<ClientStubModel.Resource> list) {
        String string = "";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            string = string + "                <option value='" + resource.getName() + "' <%=p.equals(\"" + resource.getName() + "\")?\"selected\":\"\"%>>" + resource.getName() + "</option>\n";
        }
        return string;
    }

    protected String createJmakiResourceTagList(List<ClientStubModel.Resource> list) {
        String string = "";
        int n = 0;
        String string2 = "<!-- If using cross-domain proxy uncomment tag below and comment above line -->\n";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            String string3 = resource.getName();
            String string4 = resource.getRepresentation().getRoot().getName();
            if (n++ == 0) {
                string = string + "         <% if(p.equals(\"" + string3 + "\")) {%>\n" + "            <a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" />\n" + "            " + string2 + "<!-- &lt;a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" args=\"proxy=" + this.getProxyUrl() + "\"/>-->\n";
                continue;
            }
            string = string + "         <% } else if(p.equals(\"" + string3 + "\")) {%>\n" + "            <a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" />\n" + "            " + string2 + "<!-- &lt;a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" args=\"proxy=" + this.getProxyUrl() + "\"/>-->\n";
        }
        string = string + "<% }%>";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string, File file) throws IOException {
        String string2 = "resources/" + string;
        if (!file.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = ClientStubsGenerator.class.getResourceAsStream(string2);
                outputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private FileObject createFolder(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject2;
    }

    private static void zip(File file, String[] stringArray, String[] stringArray2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(stringArray[i]);
                ClientStubsGenerator.addEntry(file2, stringArray2[i], zipOutputStream);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private static void addEntry(File file, String string, ZipOutputStream zipOutputStream) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file + File.separator + stringArray[i]);
                ClientStubsGenerator.addEntry(file2, string + File.separator + file.getName(), zipOutputStream);
            }
        } else {
            int n;
            byte[] byArray = new byte[65536];
            BufferedInputStream bufferedInputStream = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
            ZipEntry zipEntry = new ZipEntry(string + File.separator + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray, 0, 65536)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unzip(InputStream inputStream, FileObject fileObject, boolean bl) throws IOException {
        boolean bl2 = true;
        FileSystem fileSystem = fileObject.getFileSystem();
        File file = FileUtil.toFile((FileObject)fileObject);
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            final byte[] byArray = new byte[65536];
            final ZipInputStream zipInputStream2 = zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream, 65536));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file2;
                if (!zipEntry.getName().startsWith("resources/dojo/resources/libs") && !zipEntry.getName().startsWith(RESOURCES + File.separator + DOJO + File.separator + RESOURCES + File.separator + LIBS)) continue;
                final File file3 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (file3.exists()) continue;
                    try {
                        file2 = FileUtil.createFolder((File)file3);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Failed to create folder: " + file3.getName() + ".  Terminating archive installation.");
                    }
                }
                if (file3.exists() && bl && !file3.delete()) {
                    throw new RuntimeException("Failed to delete file: " + file3.getName() + ".  Terminating archive installation.");
                }
                file2 = file3.getParentFile();
                if (!file2.exists()) {
                    try {
                        FileObject fileObject2 = FileUtil.createFolder((File)file2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Failed to create folder: " + file2.getName() + ".  Terminating archive installation.");
                    }
                }
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        FileOutputStream fileOutputStream = null;
                        try {
                            int n;
                            fileOutputStream = new FileOutputStream(file3);
                            while ((n = zipInputStream2.read(byArray)) >= 0) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                        }
                        finally {
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                        }
                    }
                });
            }
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProjectStub(FileObject fileObject, String string, String string2) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            Object object;
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contains(BASE_URL_TOKEN)) {
                    stringBuffer.append(string3.replaceAll(BASE_URL_TOKEN, this.getBaseUrl()));
                } else if (string3.contains("__PROJECT_NAME__")) {
                    stringBuffer.append(string3.replaceAll("__PROJECT_NAME__", string));
                } else if (string3.contains("__PROJECT_INIT_BODY__")) {
                    object = "";
                    int n = 0;
                    List<ClientStubModel.Resource> list = this.model.getResources();
                    for (ClientStubModel.Resource resource : list) {
                        if (!resource.isContainer()) continue;
                        object = (String)object + "      this.resources[" + n++ + "] = new " + string2 + resource.getName() + "(this.uri+'" + resource.getPath() + "');\n";
                    }
                    stringBuffer.append((String)object);
                } else {
                    stringBuffer.append(string3);
                }
                stringBuffer.append("\n");
            }
            object = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
            try {
                ((Writer)object).write(stringBuffer.toString());
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRestStub(FileObject fileObject, List<ClientStubModel.Resource> list, String string) throws IOException {
        ClientStubModel.Resource resource2;
        String string2 = this.getProjectName();
        String string3 = string2.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t<script type='text/javascript' src='./" + string3 + "/" + string2 + "." + JS + "'></script>\n");
        for (ClientStubModel.Resource resource2 : list) {
            stringBuffer.append("\t<script type='text/javascript' src='./" + string3 + "/" + resource2.getName() + "." + JS + "'></script>\n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("\n\t<!-- Using JavaScript files for project " + string2 + "-->\n");
        stringBuffer2.append("\t<script language='Javascript'>\n");
        stringBuffer2.append("\t\tvar str = '';\n");
        stringBuffer2.append("\t\t//Example test code for " + string2 + "\n");
        stringBuffer2.append("\t\tstr = '<h2>Resources for " + string2 + ":</h2><br><table border=\"1\">';\n");
        stringBuffer2.append("\t\tvar app = new " + string + string2 + "('" + this.getBaseUrl() + "');\n");
        stringBuffer2.append("\t\t//Uncomment below if using proxy for javascript cross-domain.\n");
        stringBuffer2.append("\t\t//app.setProxy(\"" + this.getProxyUrl() + "\");\n");
        stringBuffer2.append("\t\tvar resources = app.getResources();\n");
        stringBuffer2.append("\t\tfor(i=0;i<resources.length;i++) {\n");
        stringBuffer2.append("\t\t  var resource = resources[i];\n");
        stringBuffer2.append("\t\t  var uri = resource.getUri();\n");
        stringBuffer2.append("\t\t  str += '<tr><td valign=\"top\"><a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a></td><td>';\n");
        stringBuffer2.append("\t\t  var items  = resource.getItems();\n");
        stringBuffer2.append("\t\t  if(items != undefined && items.length > 0) {\n");
        stringBuffer2.append("\t\t    for(j=0;j<items.length;j++) {\n");
        stringBuffer2.append("\t\t        var item = items[j];\n");
        stringBuffer2.append("\t\t        var uri2 = item.getUri();\n");
        stringBuffer2.append("\t\t        str += '<a href=\"'+uri2+'\" target=\"_blank\">'+uri2+'</a><br/>';\n");
        stringBuffer2.append("\t\t        str += '&nbsp;&nbsp;<font size=\"-3\">'+item.toString()+'</font><br/>';\n");
        stringBuffer2.append("\t\t    }\n");
        stringBuffer2.append("\t\t  } else {\n");
        stringBuffer2.append("\t\t    str += 'No items, please check the url: <a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a>.<br/>Set proxy if RESTful web service is not running on the same domain as this application.';\n");
        stringBuffer2.append("\t\t  }\n");
        stringBuffer2.append("\t\t  str += '</td></tr>';\n");
        stringBuffer2.append("\t\t}\n");
        stringBuffer2.append("\t\tstr += '</table><br>';\n");
        stringBuffer2.append("\t\tvar n = document.getElementById('containerContent');\n");
        stringBuffer2.append("\t\tn.innerHTML = n.innerHTML + str;\n\n");
        stringBuffer2.append("\t</script>\n");
        resource2 = fileObject.lock();
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer3 = new StringBuffer();
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.contains("JS_DECLARE_END")) {
                    stringBuffer3.append(stringBuffer.toString());
                } else if (string4.contains("JS_USAGE_END")) {
                    stringBuffer3.append(stringBuffer2.toString());
                }
                stringBuffer3.append(string4);
                stringBuffer3.append("\n");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream((FileLock)resource2), "UTF-8");
            try {
                outputStreamWriter.write(stringBuffer3.toString());
            }
            finally {
                outputStreamWriter.close();
            }
        }
        finally {
            resource2.releaseLock();
        }
    }

    public class ResourceJmakiTemplate
    extends ResourceDojoComponents {
        public ResourceJmakiTemplate(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
        }

        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getRepresentation().getRoot().getName() + ClientStubsGenerator.TABLE;
            FileObject fileObject = ClientStubsGenerator.this.createFolder(this.getFolder(), string);
            FileObject fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESBUNDLE_TEMPLATE, fileObject, ClientStubsGenerator.BUNDLE, ClientStubsGenerator.PROPERTIES, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESJSP_TEMPLATE, fileObject, string, ClientStubsGenerator.JSP, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESPHP_TEMPLATE, fileObject, string, ClientStubsGenerator.PHP, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESEJS_TEMPLATE, fileObject, string, ClientStubsGenerator.EJS, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESRHTML_TEMPLATE, fileObject, string, ClientStubsGenerator.RHTML, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            return this.getFolder();
        }
    }

    public class ResourceJmakiComponent
    extends ResourceDojoComponents {
        public ResourceJmakiComponent(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
        }

        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getRepresentation().getRoot().getName();
            FileObject fileObject = ClientStubsGenerator.this.createFolder(this.getFolder(), string + ClientStubsGenerator.TABLE);
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_COMPONENTCSS_TEMPLATE, fileObject, ClientStubsGenerator.JMAKI_COMPONENT, ClientStubsGenerator.CSS, ClientStubsGenerator.this.canOverwrite());
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_COMPONENTHTM_TEMPLATE, fileObject, ClientStubsGenerator.JMAKI_COMPONENT, ClientStubsGenerator.HTM, ClientStubsGenerator.this.canOverwrite());
            FileObject fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_COMPONENTJS_TEMPLATE, fileObject, ClientStubsGenerator.JMAKI_COMPONENT, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_WIDGETJSON_TEMPLATE, fileObject, ClientStubsGenerator.WIDGET, ClientStubsGenerator.JSON, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            FileObject fileObject3 = ClientStubsGenerator.this.createFolder(fileObject, ClientStubsGenerator.IMAGES);
            File file = FileUtil.toFile((FileObject)fileObject3);
            ClientStubsGenerator.this.copyFile("JmakiResourcesTable.gif", new File(file, "rtable.gif"));
            ClientStubsGenerator.this.copyFile("JmakiResourcesTableUp.gif", new File(file, "rtableUp.gif"));
            ClientStubsGenerator.this.copyFile("JmakiResourcesTableDown.gif", new File(file, "rtableDown.gif"));
            return this.getFolder();
        }
    }

    public class ResourceDojoComponents
    extends ResourceJavaScript {
        public ResourceDojoComponents(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            if (resource.isContainer() && this.root != null && this.root.getChildren().size() > 0) {
                String string = resource.getName();
                String string2 = this.root.getName();
                String string3 = this.root.getChildren().get(0).getName();
                String string4 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("//__INCLUDE_JS_SCRIPTS__", ClientStubsGenerator.this.includeJs + "\n//__INCLUDE_JS_SCRIPTS__");
                hashMap.put("//__LIBS_JS_SCRIPTS__", ClientStubsGenerator.this.libsJs + "\n//__LIBS_JS_SCRIPTS__");
                hashMap.put("//__RESOURCES_DOJO_SCRIPTS__", ClientStubsGenerator.this.resourcesDojo + "\n//__RESOURCES_DOJO_SCRIPTS__");
                hashMap.put("//__REQUIRE_DOJO_SCRIPTS__", ClientStubsGenerator.this.requireDojo + "\n//__REQUIRE_DOJO_SCRIPTS__");
                hashMap.put("__CONTAINER_NAME__", string);
                hashMap.put("__CONTAINER_PATH_NAME__", string2);
                hashMap.put("__CONTAINER_ITEM_NAME__", string4);
                hashMap.put("__CONTAINER_ITEM_PATH_NAME__", string3);
                hashMap.put("__STUB_METHODS__", this.createStubJSMethods(resource, this.object, this.pkg));
                hashMap.put("__PROJECT_NAME__", ClientStubsGenerator.this.getProjectName());
                hashMap.put("<!-- __DOJO_RESOURCE_SELECT_LIST__ -->", ClientStubsGenerator.this.dojoResSelList + "\n<!-- __DOJO_RESOURCE_SELECT_LIST__ -->");
                hashMap.put("<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->", ClientStubsGenerator.this.jmakiResSelList + "\n<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->");
                hashMap.put("<!-- __JMAKI_RESOURCE_TAG_LIST__ -->", ClientStubsGenerator.this.jmakiResTagList + "\n<!-- __JMAKI_RESOURCE_TAG_LIST__ -->");
                hashMap.put(ClientStubsGenerator.TTL_JMakiWidget_Stubs, NbBundle.getMessage(ClientStubsGenerator.class, (String)ClientStubsGenerator.TTL_JMakiWidget_Stubs));
                hashMap.put(ClientStubsGenerator.BASE_URL_TOKEN, ClientStubsGenerator.this.getBaseUrl());
                this.setTokens(hashMap);
            }
        }

        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getName();
            FileObject fileObject = this.getFolder().getFileObject(ClientStubsGenerator.DATA);
            FileObject fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.DOJO_COLLECTIONSTORE_TEMPLATE, fileObject, string + ClientStubsGenerator.STORE, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            return ClientStubsGenerator.this.rdjDir;
        }
    }

    public class GenericResourceJavaScript
    extends ResourceJavaScript {
        public GenericResourceJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("__RESOURCE_NAME__", resource.getName());
            hashMap.put("__STUB_METHODS__", this.stubJSToken);
            this.setTokens(hashMap);
        }

        public FileObject generate() throws IOException {
            String string = this.r.getName();
            String string2 = this.r.getName() + "." + ClientStubsGenerator.JS;
            FileObject fileObject = this.jsFolder.getFileObject(string2);
            if (fileObject != null) {
                if (ClientStubsGenerator.this.canOverwrite()) {
                    fileObject.delete();
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string2)));
                }
            }
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_GENERICSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            fileObject = this.jsFolder.getFileObject(string2);
            this.replaceTokens(fileObject);
            return fileObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContainerItemJavaScript
    extends ResourceJavaScript {
        public ContainerItemJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            if (this.root != null) {
                String string = resource.getName();
                String string2 = this.root.getName();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("__GENERIC_NAME__", string);
                hashMap.put("__GENERIC_PATH_NAME__", string2);
                hashMap.put("__FIELDS_DEFINITION__", this.createFieldsDefinition(this.root, true));
                hashMap.put("__GETTER_SETTER_METHODS__", this.createGetterSetterMethods(this.root, true));
                hashMap.put("__FIELDS_INIT__", this.createFieldsInitBody(this.root, true, this.pkg));
                hashMap.put("__SUB_RESOURCE_NAME__", "");
                hashMap.put("__SUB_RESOURCE_PATH_NAME__", "");
                hashMap.put("__FIELDS_TOSTRING__", this.createFieldsToStringBody(this.root, true));
                hashMap.put("__FIELD_NAMES_TOSTRING__", this.createFieldNamesBody(this.root, true));
                hashMap.put("__STUB_METHODS__", this.stubJSToken);
                this.setTokens(hashMap);
            }
        }

        @Override
        public FileObject generate() throws IOException {
            String string = this.r.getName();
            String string2 = this.r.getName() + "." + ClientStubsGenerator.JS;
            FileObject fileObject = this.jsFolder.getFileObject(string2);
            if (fileObject != null) {
                if (ClientStubsGenerator.this.canOverwrite()) {
                    fileObject.delete();
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string2)));
                }
            }
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_CONTAINERITEMSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            fileObject = this.jsFolder.getFileObject(string2);
            this.replaceTokens(fileObject);
            return fileObject;
        }

        private String createGetterSetterMethods(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.createGetterSetterMethods(representationNode.getAttributes(), bl));
            stringBuffer.append(this.createGetterSetterMethods(representationNode.getChildren(), bl));
            return stringBuffer.toString();
        }

        private String createGetterSetterMethods(List<ClientStubModel.RepresentationNode> list, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode : list) {
                String string = representationNode.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append(this.createGetterMethod(representationNode) + ",\n\n");
                stringBuffer.append(this.createSetterMethod(representationNode) + ",\n\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldsDefinition(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("    this." + string + " = '';\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isContainer()) {
                    stringBuffer.append("    this." + string + " = new Array();\n");
                    continue;
                }
                stringBuffer.append("    this." + string + " = '';\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldsInitBody(ClientStubModel.RepresentationNode representationNode, boolean bl, String string) {
            String string2;
            String string3 = representationNode.getName();
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string2 = representationNode2.getName();
                if (bl && string2.equals("uri")) continue;
                stringBuffer.append("         this." + string2 + " = " + string3 + "['@" + string2 + "'];\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string2 = representationNode2.getName();
                if (representationNode2.isRoot() || representationNode2.isReference()) {
                    String string4 = representationNode2.getId();
                    stringBuffer.append("         this." + string2 + " = new " + string + this.findResourceName(string2) + "(" + string3 + "['" + string4 + "']['@uri']);\n");
                    continue;
                }
                stringBuffer.append("         this." + string2 + " = this.findValue(this." + string2 + ", " + string3 + "['" + string2 + "']);\n");
            }
            return stringBuffer.toString();
        }

        private String pluralize(String string) {
            String string2 = Util.pluralize(string);
            if (string2.endsWith("ss")) {
                string2 = string2.substring(0, string2.length() - 2) + "Collection";
            }
            return string2;
        }

        private String createFieldsToStringBody(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("         ', \"@" + string + "\":\"'+this." + string + "+'\"'+\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isRoot() || representationNode2.isReference()) {
                    stringBuffer.append("         ', \"" + string + "\":{\"@uri\":\"'+this." + string + ".getUri()+'\"}'+\n");
                    continue;
                }
                stringBuffer.append("         ', \"" + string + "\":\"'+this." + string + "+'\"'+\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldNamesBody(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("         fields.push('" + string + "');\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isReference() || representationNode2.isRoot()) continue;
                stringBuffer.append("         fields.push('" + string + "');\n");
            }
            return stringBuffer.toString();
        }

        private String findResourceName(String string) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }

        private String createGetterMethod(ClientStubModel.RepresentationNode representationNode) {
            String string = RestUtils.createGetterMethodName(representationNode);
            String string2 = representationNode.getName();
            return "   " + string + " : function() {\n" + "      if(!this.initialized)\n" + "         this.init();\n" + "      return this." + string2 + ";\n" + "   }";
        }

        private String createSetterMethod(ClientStubModel.RepresentationNode representationNode) {
            String string = this.createSetterMethodName(representationNode);
            String string2 = representationNode.getName();
            return "   " + string + " : function(" + string2 + "_) {\n" + "      this." + string2 + " = " + string2 + "_;\n" + "   }";
        }

        private String createSetterMethodName(ClientStubModel.RepresentationNode representationNode) {
            String string = "set";
            if (representationNode.getLink() != null) {
                string = RestUtils.escapeJSReserved(representationNode.getLink().getName().toString());
                string = "set" + string.substring(3);
            } else {
                string = representationNode.getName();
                string = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
            }
            return string;
        }
    }

    public class ContainerJavaScript
    extends ResourceJavaScript {
        public ContainerJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            if (this.root != null && this.root.getChildren().size() > 0) {
                String string = resource.getName();
                String string2 = this.root.getName();
                String string3 = this.root.getChildren().get(0).getName();
                String string4 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("__CONTAINER_NAME__", string);
                hashMap.put("__CONTAINER_PATH_NAME__", string2);
                hashMap.put("__CONTAINER_ITEM_NAME__", string4);
                hashMap.put("__CONTAINER_ITEM_PATH_NAME__", string3);
                hashMap.put("__STUB_METHODS__", this.createStubJSMethods(resource, this.object, this.pkg));
                hashMap.put("__PROJECT_NAME__", ClientStubsGenerator.this.getProjectName());
                hashMap.put("<!-- __DOJO_RESOURCE_SELECT_LIST__ -->", ClientStubsGenerator.this.dojoResSelList + "\n<!-- __DOJO_RESOURCE_SELECT_LIST__ -->");
                hashMap.put("<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->", ClientStubsGenerator.this.jmakiResSelList + "\n<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->");
                hashMap.put("<!-- __JMAKI_RESOURCE_TAG_LIST__ -->", ClientStubsGenerator.this.jmakiResTagList + "\n<!-- __JMAKI_RESOURCE_TAG_LIST__ -->");
                this.setTokens(hashMap);
            }
        }

        public FileObject generate() throws IOException {
            String string = this.r.getName();
            String string2 = this.r.getName() + "." + ClientStubsGenerator.JS;
            FileObject fileObject = this.jsFolder.getFileObject(string2);
            if (fileObject != null) {
                if (ClientStubsGenerator.this.canOverwrite()) {
                    fileObject.delete();
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string2)));
                }
            }
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_CONTAINERSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            fileObject = this.jsFolder.getFileObject(string2);
            this.replaceTokens(fileObject);
            return fileObject;
        }
    }

    public abstract class ResourceJavaScript
    extends TokenReplacer {
        final String RJSSUPPORT = "rjsSupport";
        protected ClientStubModel.Resource r;
        protected FileObject jsFolder;
        protected ClientStubModel.RepresentationNode root;
        protected String pkg;
        protected String object;
        protected String stubJSToken;
        private Map<String, String> tokens;

        public ResourceJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            this.RJSSUPPORT = "rjsSupport";
            this.r = resource;
            this.jsFolder = fileObject;
            this.pkg = "";
            this.object = "";
            this.root = resource.getRepresentation().getRoot();
            this.stubJSToken = this.createStubJSMethods(resource, this.object, this.pkg);
        }

        public FileObject getFolder() {
            return this.jsFolder;
        }

        public abstract FileObject generate() throws IOException;

        protected String createStubJSMethods(ClientStubModel.Resource resource, String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.Method method : resource.getMethods()) {
                stringBuffer.append("   ,\n" + this.createMethod(method, "rjsSupport.", string2) + "\n");
            }
            return stringBuffer.toString();
        }

        private String createMethod(ClientStubModel.Method method, String string, String string2) {
            if (method.getType() == ClientStubModel.MethodType.GET) {
                return this.createGetMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.POST) {
                return this.createPostMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.PUT) {
                return this.createPutMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.DELETE) {
                return this.createDeleteMethod(method, string);
            }
            if (method instanceof ClientStubModel.NavigationMethod) {
                return this.createNavigationMethod((ClientStubModel.NavigationMethod)method, string2);
            }
            return "";
        }

        private String createMethodName(ClientStubModel.Method method, String string, int n) {
            if (n > 1) {
                for (Constants.MimeType mimeType : Constants.MimeType.values()) {
                    if (!mimeType.value().equals(string)) continue;
                    return method.getName() + mimeType.suffix();
                }
            }
            return method.getName();
        }

        private String createGetMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getResponse().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getResponse().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function() {\n" + "      return " + string + "get(this.uri, '" + string2 + "');\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createPostMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getRequest().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getRequest().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function(content) {\n" + "      return " + string + "post(this.uri, '" + string2 + "', content);\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createPutMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getRequest().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getRequest().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function(content) {\n" + "      return " + string + "put(this.uri, '" + string2 + "', content);\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createDeleteMethod(ClientStubModel.Method method, String string) {
            return "   " + RestUtils.escapeJSReserved(method.getName()) + " : function() {\n" + "      return " + string + "delete_(this.uri);\n" + "   }";
        }

        private String createNavigationMethod(ClientStubModel.NavigationMethod navigationMethod, String string) {
            String string2 = "";
            String string3 = "";
            if (navigationMethod.getNavigationUri().contains(",")) {
                String[] stringArray;
                for (String string4 : stringArray = navigationMethod.getNavigationUri().split(",")) {
                    if (string4.startsWith("{")) {
                        string4 = string4.substring(1);
                    } else if (string4.endsWith("}")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    string2 = string2 + string4 + "+','+";
                    string3 = string3 + string4 + ",";
                }
                string2 = string2.substring(0, string2.length() - 5);
                string3 = string3.substring(0, string3.length() - 1);
            } else {
                string3 = string2 = navigationMethod.getNavigationUri();
            }
            return "   " + navigationMethod.getName() + " : function(" + string3 + ") {\n" + "      var link = new " + string + navigationMethod.getLinkName() + "(this.uri+'/'+" + string2 + ");\n" + "      return link;\n" + "   }";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TokenReplacer {
        private Map<String, String> tokens = new HashMap<String, String>();

        public Map<String, String> getTokens() {
            return Collections.unmodifiableMap(this.tokens);
        }

        public void addToken(String string, String string2) {
            this.tokens.put(string, string2);
        }

        public void setTokens(Map<String, String> map) {
            this.tokens = map;
        }

        public void replaceTokens(FileObject fileObject) throws IOException {
            this.replaceTokens(fileObject, this.getTokens());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceTokens(FileObject fileObject, Map<String, String> map) throws IOException {
            FileLock fileLock = fileObject.lock();
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    string = this.replaceTokens(string, "", "", map);
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
                try {
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    outputStreamWriter.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }

        private String replaceTokens(String string, String string2, String string3, Map<String, String> map) {
            String string4 = string;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string5 = entry.getKey();
                String string6 = entry.getValue();
                if (string5 == null || string6 == null) continue;
                string4 = string4.replaceAll(string5, string6);
            }
            return string4;
        }
    }
}

