/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.util;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.bpel.debugger.ui.util.Log;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class EditorUtil {
    private EditorUtil() {
    }

    public static Line getLine(DataObject dataObject, int n) {
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            Log.out("Line cookie is null: " + dataObject);
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            Log.out("Line set is null :" + lineCookie);
            return null;
        }
        try {
            return set.getCurrent(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Log.out("Out of bounds: " + n);
            return null;
        }
    }

    public static DataObject getDataObject(String string) {
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        if (fileObject == null) {
            Log.out("fileObject is null :" + string);
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Log.out("Can't find data object for " + fileObject);
            return null;
        }
    }

    public static BpelModel getBpelModel(DataObject dataObject) {
        if (dataObject instanceof Lookup.Provider) {
            DataObject dataObject2 = dataObject;
            return (BpelModel)dataObject2.getLookup().lookup(BpelModel.class);
        }
        Log.out("Can't lookup a BpelModel - not a Lookup.Provider :" + dataObject);
        return null;
    }

    public static BpelModel getBpelModel(String string) {
        DataObject dataObject = EditorUtil.getDataObject(string);
        if (dataObject == null) {
            Log.out("DataObject is null :" + string);
            return null;
        }
        return EditorUtil.getBpelModel(dataObject);
    }

    public static StyledDocument getDocument(DataObject dataObject) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            Log.out("Editor cookie is null");
            return null;
        }
        return editorCookie.getDocument();
    }

    public static String getFileName(String string) {
        return EditorUtil.getTail(EditorUtil.getTail(string, "/"), "\\");
    }

    public static int findOffset(Document document, int n) {
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n - 1);
        int n2 = element2.getStartOffset();
        String string = "";
        try {
            string = document.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset() + 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        int n3 = EditorUtil.findNotSpace(string);
        if (n3 < 0) {
            n3 = 0;
        }
        return n2 + n3;
    }

    public static int getLineNumber(Node node) {
        EditorCookie editorCookie = (EditorCookie)node.getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = EditorUtil.getEditorPane(editorCookie);
        if (jEditorPane == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = caret.getDot();
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n) + 1;
    }

    public static String getOpenedDocumentViewName() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return null;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        if (multiViewPerspective == null) {
            return null;
        }
        return multiViewPerspective.preferredID();
    }

    public static Line getCurrentLine() {
        DataObject dataObject;
        Node[] nodeArray = TopComponent.getRegistry().getCurrentNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null && (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        if (fileObject == null) {
            return null;
        }
        if (!"text/x-bpel+xml".equals(fileObject.getMIMEType())) {
            return null;
        }
        dataObject = (LineCookie)node.getCookie(LineCookie.class);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = EditorUtil.getEditorPane(editorCookie);
        if (jEditorPane == null) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return null;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        try {
            Line.Set set = dataObject.getLineSet();
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static String getText(String string) {
        DataObject dataObject = EditorUtil.getDataObject(string);
        if (dataObject == null) {
            return "";
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return "";
        }
        JEditorPane jEditorPane = EditorUtil.getEditorPane(editorCookie);
        if (jEditorPane == null) {
            return "";
        }
        return jEditorPane.getText();
    }

    private static JEditorPane getEditorPane(final EditorCookie editorCookie) {
        if (SwingUtilities.isEventDispatchThread()) {
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
                return null;
            }
            return jEditorPaneArray[0];
        }
        final JEditorPane[] jEditorPaneArray = new JEditorPane[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    jEditorPaneArray[0] = EditorUtil.getEditorPane(editorCookie);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return jEditorPaneArray[0];
    }

    private static int findNotSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= ' ') continue;
            return i;
        }
        return -1;
    }

    private static String getTail(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n != -1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }
}

