/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BPELNode;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BPELActivityFinderSaxHandler
extends DefaultHandler {
    private List mAllNodes = new ArrayList();
    private BPELNode mCurrentNode;
    private Locator mLocator;
    private String mTargetNS;
    private BPELNode mFirstAct;
    private BPELNode mLastAct;
    private int mBreakpointLine;
    private BPELNode mFindingNode;
    private boolean found;

    public BPELActivityFinderSaxHandler(int n) {
        this.mBreakpointLine = n;
    }

    public List getAllNodes() {
        return this.mAllNodes;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.mCurrentNode.setClosingNumber(this.mLocator.getLineNumber());
        if (!this.found && this.mFindingNode == this.mCurrentNode && this.mCurrentNode.getClosingNumber() >= this.mBreakpointLine) {
            this.found = true;
        }
        this.mCurrentNode = this.mCurrentNode.getParent();
        if (!this.found) {
            this.mFindingNode = this.mCurrentNode;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.mCurrentNode == null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getLocalName(i).equals("targetNamespace")) continue;
                this.mTargetNS = attributes.getValue(i);
            }
        }
        BPELNode.BPELNodeType bPELNodeType = BPELNode.getNodeType(string2);
        BPELNode bPELNode = new BPELNode(string2, this.mLocator.getLineNumber(), this.mTargetNS, bPELNodeType, this.mCurrentNode);
        if (this.mCurrentNode != null) {
            this.mCurrentNode.addChild(bPELNode);
        }
        this.mAllNodes.add(bPELNode);
        if (bPELNode.isActivity() && this.mFirstAct == null) {
            this.mFirstAct = bPELNode;
        } else if (bPELNode.isActivity()) {
            this.mLastAct = bPELNode;
        }
        this.mCurrentNode = bPELNode;
        if (!this.found && this.mCurrentNode.getLineNumber() < this.mBreakpointLine) {
            this.mFindingNode = this.mCurrentNode;
        } else if (!this.found && this.mCurrentNode.getLineNumber() >= this.mBreakpointLine) {
            if (this.mCurrentNode.getParent() == this.mFindingNode) {
                this.mFindingNode = this.mCurrentNode;
            }
            this.found = true;
        }
    }

    public BPELNode getFirstActivity() {
        return this.mFirstAct;
    }

    public BPELNode getLastActivity() {
        return this.mLastAct;
    }

    public HashMap getAllActMap() {
        LinkedHashMap<Integer, BPELNode> linkedHashMap = new LinkedHashMap<Integer, BPELNode>();
        for (BPELNode bPELNode : this.mAllNodes) {
            linkedHashMap.put(new Integer(bPELNode.getLineNumber()), bPELNode);
        }
        return linkedHashMap;
    }

    public BPELNode getFoundNode() {
        return this.mFindingNode;
    }
}

