/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassesListControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ViewTitle");
    private static final String NO_INSTANCES_MSG = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_NoInstancesMsg");
    private static final String FILTER_STARTS_WITH = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterStartsWith");
    private static final String FILTER_CONTAINS = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterContains");
    private static final String FILTER_ENDS_WITH = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterEndsWith");
    private static final String FILTER_REGEXP = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterRegexp");
    private static final String FILTER_IMPLEMENTATION = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterImplementation");
    private static final String FILTER_SUBCLASS = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterSubclass");
    private static final String DEFAULT_FILTER_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_DefaultFilterText");
    private static final String SHOW_IN_INSTANCES_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowInInstancesString");
    private static final String SHOW_IMPLEMENTATIONS_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowImplementationsString");
    private static final String SHOW_SUBCLASSES_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowSubclassesString");
    private static final String GO_TO_SOURCE_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_GoToSourceString");
    private static final String SHOW_HIDE_COLUMNS_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowHideColumnsString");
    private static final String FILTER_CHECKBOX_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterCheckboxText");
    private static final String CLASSNAME_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassNameColumnText");
    private static final String CLASSNAME_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassNameColumnDescr");
    private static final String INSTANCES_REL_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesRelColumnText");
    private static final String INSTANCES_REL_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesRelColumnDescr");
    private static final String INSTANCES_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesColumnText");
    private static final String INSTANCES_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesColumnDescr");
    private static final String SIZE_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_SizeColumnText");
    private static final String SIZE_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_SizeColumnDescr");
    private static final String FITERING_PROGRESS_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilteringProgressText");
    private static final String RESULT_NOT_AVAILABLE_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ResultNotAvailableString");
    private static final String CLASSES_TABLE_ACCESS_NAME = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassesTableAccessName");
    private static final String CLASSES_TABLE_ACCESS_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassesTableAccessDescr");
    private static ImageIcon ICON_CLASSES = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/classes.png"));
    private static String filterValue = "";
    private static int filterType = 20;
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private static final int columnCount = 4;
    private CardLayout contents;
    private ClassesListController classesListController;
    private final NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private ClassesListTableModel realClassesListTableModel = new ClassesListTableModel();
    private ExtendedTableModel classesListTableModel = new ExtendedTableModel((SortableTableModel)this.realClassesListTableModel);
    private FilterComponent filterComponent;
    private JExtendedTable classesListTable;
    private JPanel contentsPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private String selectedRowContents;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private Object[][] displayCache;
    private boolean hasProjectContext;
    private boolean internalCornerButtonClick = false;
    private boolean selectionSaved = false;
    private boolean showZeroInstances = true;
    private boolean showZeroSize = true;
    private boolean sortingOrder = false;
    private int classesCount = -1;
    private int selectedRow;
    private int sortingColumn = 1;

    public ClassesListControllerUI(ClassesListController classesListController) {
        super(VIEW_TITLE, (Icon)ICON_CLASSES, true);
        this.classesListController = classesListController;
        this.hasProjectContext = classesListController.getClassesController().getHeapFragmentWalker().getHeapDumpProject() != null;
        this.initColumnsData();
        this.initData();
        this.initComponents();
    }

    public void setColumnVisibility(int n, boolean bl) {
        boolean bl2 = this.classesListTableModel.isRealColumnVisible(n);
        if (bl2 == bl) {
            return;
        }
        this.saveSelection();
        boolean bl3 = false;
        int n2 = this.classesListTableModel.getSortingColumn();
        int n3 = this.classesListTableModel.getRealColumn(n2);
        if (bl2 && n == n3) {
            n2 = n2 + 1 == this.classesListTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
            n3 = this.classesListTableModel.getRealColumn(n2);
            bl3 = true;
        }
        this.classesListTableModel.setRealColumnVisibility(n, bl);
        this.classesListTable.createDefaultColumnsFromModel();
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        n2 = this.classesListTableModel.getVirtualColumn(n3);
        if (bl3) {
            this.sortingOrder = this.classesListTableModel.getInitialSorting(n2);
            this.sortingColumn = n3;
            this.initData();
        }
        this.sortingColumn = n3;
        this.classesListTableModel.setInitialSorting(n2, this.sortingOrder);
        this.classesListTable.getTableHeader().repaint();
        this.setColumnsData();
        this.restoreSelection();
    }

    public void ensureWillBeVisible(JavaClass javaClass) {
        if (ClassesListController.matchesFilter(javaClass, FilterComponent.getFilterStrings((String)filterValue), filterType, this.showZeroInstances, this.showZeroSize)) {
            return;
        }
        this.filterComponent.setFilterString("");
    }

    public void selectClass(JavaClass javaClass) {
        if (this.displayCache == null || this.displayCache.length == 0) {
            return;
        }
        for (int i = 0; i < this.displayCache.length; ++i) {
            if (!this.displayCache[i][4].equals(javaClass)) continue;
            this.classesListTable.setRowSelectionInterval(i, i);
            final int n = i;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassesListControllerUI.this.classesListTable.ensureRowVisible(n);
                }
            });
            break;
        }
    }

    public void updateData() {
        this.initData();
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realClassesListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realClassesListTableModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.classesListTable != null) {
                jCheckBoxMenuItem.setState(this.classesListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FILTER_CHECKBOX_TEXT);
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.isVisible());
        }
        this.cornerPopup.add(jCheckBoxMenuItem);
        this.cornerPopup.pack();
    }

    protected void saveColumnsData() {
        TableColumnModel tableColumnModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int n = this.classesListTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int n = this.classesListTableModel.getRealColumn(i);
            if (n != 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            }
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    ClassesListControllerUI.this.filterComponent.setVisible(!ClassesListControllerUI.this.filterComponent.isVisible());
                    return;
                }
                int n = Integer.parseInt(actionEvent.getActionCommand());
                ClassesListControllerUI.this.setColumnVisibility(n, !ClassesListControllerUI.this.classesListTableModel.isRealColumnVisible(n));
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu jPopupMenu) {
        final JButton jButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/hideColumn.png")));
        jButton.setToolTipText(SHOW_HIDE_COLUMNS_STRING);
        jButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 1));
        }
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isVisible()) {
                    ClassesListControllerUI.this.internalCornerButtonClick = true;
                    jButton.getModel().setArmed(false);
                } else {
                    ClassesListControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !ClassesListControllerUI.this.internalCornerButtonClick) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        return jButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(SHOW_IN_INSTANCES_STRING);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        jMenuItem.setFont(jPopupMenu.getFont().deriveFont(1));
        JMenuItem jMenuItem2 = new JMenuItem(this.hasProjectContext ? SHOW_IMPLEMENTATIONS_STRING : SHOW_SUBCLASSES_STRING);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                if (n != -1) {
                    ClassesListControllerUI.this.showSubclassesForClass((JavaClass)ClassesListControllerUI.this.displayCache[n][4]);
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(GO_TO_SOURCE_STRING);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                if (n != -1) {
                    String string = (String)ClassesListControllerUI.this.displayCache[n][0];
                    while (string.endsWith("[]")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    NetBeansProfiler.getDefaultNB().openJavaSource(null, string, null, null);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    private void initColumnsData() {
        this.columnWidths = new int[3];
        this.columnNames = new String[4];
        this.columnToolTips = new String[4];
        this.columnRenderers = new TableCellRenderer[4];
        this.columnNames[0] = CLASSNAME_COLUMN_TEXT;
        this.columnToolTips[0] = CLASSNAME_COLUMN_DESCR;
        this.columnNames[1] = INSTANCES_REL_COLUMN_TEXT;
        this.columnToolTips[1] = INSTANCES_REL_COLUMN_DESCR;
        this.columnNames[2] = INSTANCES_COLUMN_TEXT;
        this.columnToolTips[2] = INSTANCES_COLUMN_DESCR;
        this.columnNames[3] = SIZE_COLUMN_TEXT;
        this.columnToolTips[3] = SIZE_COLUMN_DESCR;
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = classNameTableCellRenderer;
        this.columnWidths[0] = n;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = n;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        this.columnWidths[2] = n;
        this.columnRenderers[3] = labelBracketTableCellRenderer;
    }

    private void initComponents() {
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
        this.classesListTable = new JExtendedTable((TableModel)this.classesListTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < ClassesListControllerUI.this.classesListTableModel.getColumnCount(); ++i) {
                    if (ClassesListControllerUI.this.classesListTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.classesListTable.setSelectionMode(0);
        this.classesListTable.addMouseListener((MouseListener)new ClassesListTableMouseListener());
        this.classesListTable.addKeyListener((KeyListener)new ClassesListTableKeyListener());
        this.classesListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.classesListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.classesListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.classesListTable.setShowHorizontalLines(false);
        this.classesListTable.setShowVerticalLines(true);
        this.classesListTable.setRowMargin(0);
        this.classesListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        this.classesListTableModel.setInitialSorting(this.sortingColumn, this.sortingOrder);
        this.classesListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.classesListTable.getAccessibleContext().setAccessibleName(CLASSES_TABLE_ACCESS_NAME);
        this.classesListTable.getAccessibleContext().setAccessibleDescription(CLASSES_TABLE_ACCESS_DESCR);
        this.classesListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.classesListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(this.classesListTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.classesListTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet(this.classesListTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.classesListTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        this.filterComponent = new FilterComponent();
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterStartsWith.png")), FILTER_STARTS_WITH, 10);
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterContains.png")), FILTER_CONTAINS, 20);
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterEndsWith.png")), FILTER_ENDS_WITH, 30);
        this.filterComponent.addFilterItem(new ImageIcon(this.filterComponent.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/filterRegExp.png")), FILTER_REGEXP, 50);
        this.filterComponent.addFilterItem(Utils.CLASS_ICON, this.hasProjectContext ? FILTER_IMPLEMENTATION : FILTER_SUBCLASS, 1001);
        this.filterComponent.setEmptyFilterText(DEFAULT_FILTER_TEXT);
        this.filterComponent.setFilterValues(filterValue, filterType);
        this.filterComponent.addFilterListener(new FilterComponent.FilterListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void filterChanged() {
                block3: {
                    block2: {
                        if (ClassesListControllerUI.this.classesCount > 10000) break block2;
                        if (!ClassesListControllerUI.this.hasProjectContext) break block3;
                        int n = ClassesListControllerUI.this.filterComponent.getFilterType();
                        ClassesListControllerUI.this.classesListController;
                        if (n != 1001) break block3;
                    }
                    new NBSwingWorker(){

                        protected void doInBackground() {
                            ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.NO_DATA);
                            filterValue = ClassesListControllerUI.this.filterComponent.getFilterString();
                            filterType = ClassesListControllerUI.this.filterComponent.getFilterType();
                            ClassesListControllerUI.this.initData();
                            ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.DATA);
                        }

                        protected void done() {
                            ClassesListControllerUI.this.repaint();
                        }
                    }.execute();
                    return;
                }
                filterValue = ClassesListControllerUI.this.filterComponent.getFilterString();
                filterType = ClassesListControllerUI.this.filterComponent.getFilterType();
                ClassesListControllerUI.this.initData();
                ClassesListControllerUI.this.repaint();
            }
        });
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JButton jButton = this.createHeaderPopupCornerButton(this.cornerPopup);
        JExtendedTablePanel jExtendedTablePanel = new JExtendedTablePanel(this.classesListTable);
        jExtendedTablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hTMLTextArea = new HTMLTextArea();
        hTMLTextArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String string = "<img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/progress.png'>&nbsp;&nbsp;" + FITERING_PROGRESS_TEXT;
        hTMLTextArea.setText(string);
        jPanel.add((Component)hTMLTextArea, "Center");
        this.contents = new CardLayout();
        this.contentsPanel = new JPanel(this.contents);
        this.contentsPanel.add((Component)jExtendedTablePanel, DATA);
        this.contentsPanel.add((Component)jPanel, NO_DATA);
        this.add(this.contentsPanel, "Center");
        this.add((Component)this.filterComponent, "South");
        this.classesListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClassesListControllerUI.this.classesListController.classSelected(ClassesListControllerUI.this.classesListTable.getSelectedRow() == -1 ? null : (JavaClass)ClassesListControllerUI.this.displayCache[ClassesListControllerUI.this.classesListTable.getSelectedRow()][4]);
            }
        });
    }

    private void initData() {
        this.saveSelection();
        int n = this.classesListController.getClassesController().getHeapFragmentWalker().getTotalLiveInstances();
        int n2 = this.classesListController.getClassesController().getHeapFragmentWalker().getTotalLiveBytes();
        if (this.classesCount == -1) {
            this.classesCount = this.classesListController.getClassesController().getHeapFragmentWalker().getHeapFragment().getAllClasses().size();
        }
        List list = this.classesListController.getFilteredSortedClasses(FilterComponent.getFilterStrings((String)filterValue), filterType, this.showZeroInstances, this.showZeroSize, this.sortingColumn, this.sortingOrder);
        this.displayCache = new Object[list.size()][5];
        for (int i = 0; i < list.size(); ++i) {
            JavaClass javaClass = (JavaClass)list.get(i);
            int n3 = javaClass.getInstancesCount();
            int n4 = javaClass.getInstanceSize();
            int n5 = javaClass.getAllInstancesSize();
            this.displayCache[i][0] = javaClass.getName();
            this.displayCache[i][1] = new Float((float)n3 / (float)n * 100.0f);
            this.displayCache[i][2] = Integer.toString(n3) + " (" + this.percentFormat.format((float)n3 / (float)n) + ")";
            this.displayCache[i][3] = n5 < 0 ? RESULT_NOT_AVAILABLE_STRING : Integer.toString(n5) + " (" + this.percentFormat.format((float)n5 / (float)n2) + ")";
            this.displayCache[i][4] = javaClass;
        }
        this.classesListTableModel.fireTableDataChanged();
        this.restoreSelection();
    }

    private void performDefaultAction() {
        int n = this.classesListTable.getSelectedRow();
        if (n != -1) {
            this.showInstancesForClass((JavaClass)this.displayCache[n][4]);
        }
    }

    private void restoreSelection() {
        if (this.selectedRowContents != null) {
            this.classesListTable.selectRowByContents(this.selectedRowContents, 0, true);
        }
        this.selectionSaved = false;
    }

    private void saveSelection() {
        if (this.selectionSaved) {
            return;
        }
        this.selectedRow = this.classesListTable == null ? -1 : this.classesListTable.getSelectedRow();
        this.selectedRowContents = null;
        if (this.selectedRow != -1) {
            this.selectedRowContents = (String)this.classesListTable.getValueAt(this.selectedRow, 0);
        }
        this.selectionSaved = true;
    }

    private void showColumnSelectionPopup(JPopupMenu jPopupMenu, JButton jButton) {
        this.initColumnSelectorItems();
        jPopupMenu.show(jButton, jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getHeight());
    }

    private void showInstancesForClass(JavaClass javaClass) {
        if (javaClass.getInstancesCount() == 0) {
            NetBeansProfiler.getDefaultNB().displayInfo(MessageFormat.format(NO_INSTANCES_MSG, javaClass.getName()));
        } else {
            this.classesListController.getClassesController().getHeapFragmentWalker().showInstancesForClass(javaClass);
        }
    }

    private void showSubclassesForClass(JavaClass javaClass) {
        this.filterComponent.setFilterType(1001);
        this.filterComponent.setFilterString(javaClass.getName());
    }

    private class ClassesListTableMouseListener
    extends MouseAdapter {
        private ClassesListTableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                    ClassesListControllerUI.this.showInstancesForClass((JavaClass)ClassesListControllerUI.this.displayCache[n][4]);
                } else if (mouseEvent.getModifiers() == 4) {
                    ClassesListControllerUI.this.tablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint());
            if (n != -1 && mouseEvent.getModifiers() == 4) {
                ClassesListControllerUI.this.classesListTable.setRowSelectionInterval(n, n);
            }
        }
    }

    private class ClassesListTableModel
    extends SortableTableModel {
        private ClassesListTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return Object.class;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            return ClassesListControllerUI.this.columnNames[n];
        }

        public String getColumnToolTipText(int n) {
            return ClassesListControllerUI.this.columnToolTips[n];
        }

        public boolean getInitialSorting(int n) {
            switch (n) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        public int getRowCount() {
            return ClassesListControllerUI.this.displayCache.length;
        }

        public Object getValueAt(int n, int n2) {
            return ClassesListControllerUI.this.displayCache[n][n2];
        }

        public void sortByColumn(int n, boolean bl) {
            ClassesListControllerUI.this.sortingColumn = n;
            ClassesListControllerUI.this.sortingOrder = bl;
            ClassesListControllerUI.this.initData();
            ClassesListControllerUI.this.repaint();
        }
    }

    private class ClassesListTableKeyListener
    extends KeyAdapter {
        private ClassesListTableKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ClassesListControllerUI.this.classesListTable.getSelectedRow()) != -1) {
                Rectangle rectangle = ClassesListControllerUI.this.classesListTable.getCellRect(n, 0, true);
                ClassesListControllerUI.this.tablePopup.show((Component)ClassesListControllerUI.this.classesListTable, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            }
        }
    }
}

