/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class RerunAction
extends CallableSystemAction
implements ProfilingStateListener {
    private boolean lastState = false;

    public RerunAction() {
        this.putProperty("ShortDescription", NbBundle.getMessage(RerunAction.class, (String)"HINT_RerunAction"));
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public boolean isEnabled() {
        if (!NetBeansProfiler.isInitialized()) {
            return false;
        }
        this.lastState = Profiler.getDefault().rerunAvaliable();
        return this.lastState;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(RerunAction.class, (String)"LBL_RerunAction");
    }

    public void instrumentationChanged(int n, int n2) {
    }

    public void performAction() {
        int n = Profiler.getDefault().getProfilingState();
        int n2 = Profiler.getDefault().getProfilingMode();
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RerunAction.class, (String)"MSG_ReRunOnProfile"), NbBundle.getMessage(RerunAction.class, (String)"CAPTION_Question"), 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                Profiler.getDefault().stopApp();
            } else {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RerunAction.class, (String)"MSG_ReRunOnAttach"), NbBundle.getMessage(RerunAction.class, (String)"CAPTION_Question"), 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        Profiler.getDefault().rerunLastProfiling();
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateAction();
    }

    public void threadsMonitoringChanged() {
    }

    public void updateAction() {
        if (this.lastState != Profiler.getDefault().rerunAvaliable()) {
            boolean bl = this.isEnabled();
            this.firePropertyChange("enabled", !bl, bl);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return "org/netbeans/modules/profiler/actions/resources/rerun.png";
    }
}

