/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.actions.FileSensitiveAction;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.actions.ProfilingSupport;
import org.netbeans.modules.profiler.actions.ProjectSensitiveAction;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.project.ui.support.MainProjectSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class AntActions {
    private static final String FILE_TEST_NOT_FOUND_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FileTestNotFoundMsg");
    private static final String FAILED_DETERMINE_JAVA_PLATFORM_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FailedDetermineJavaPlatformMsg");
    private static final String FAILED_DETERMINE_PROJECT_BUILDSCRIPT_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FailedDetermineProjectBuildScriptMsg");
    private static final String INCORRECT_JAVA_SPECVERSION_DIALOG_CAPTION = NbBundle.getMessage(AntActions.class, (String)"AntActions_IncorrectJavaSpecVersionDialogCaption");
    private static final String INCORRECT_JAVA_SPECVERSION_DIALOG_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_IncorrectJavaSpecVersionDialogMsg");
    private static final String UNSUPPORTED_PROJECT_TYPE_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_UnsupportedProjectTypeMsg");

    private AntActions() {
    }

    public static Action profileMainProject() {
        Action action = MainProjectSensitiveActions.mainProjectSensitiveAction((ProjectActionPerformer)new ProjectActionPerformer(){

            public boolean enable(Project project) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (OpenProjects.getDefault().getOpenProjects().length == 0) {
                    return false;
                }
                if (project == null) {
                    return true;
                }
                return AntActions.isProjectTypeSupported(project);
            }

            public void perform(Project project) {
                if (AntActions.isProjectTypeSupported(project)) {
                    AntActions.doProfileProject(project, null, false);
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(UNSUPPORTED_PROJECT_TYPE_MSG);
                }
            }
        }, (String)NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileMainProjectAction"), null);
        action.putValue("ShortDescription", NbBundle.getMessage(AntActions.class, (String)"HINT_ProfileMainProjectAction"));
        action.putValue("iconBase", "org/netbeans/modules/profiler/actions/resources/profile.png");
        action.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/profile.png")));
        return action;
    }

    public static Action profileProject() {
        ProjectSensitiveAction projectSensitiveAction = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            public boolean enable(Project project, Lookup lookup, boolean bl) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                return AntActions.isProjectTypeSupported(project);
            }

            public void perform(Project project, Lookup lookup) {
                AntActions.doProfileProject(project, null, false);
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectAction40_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectAction40"), null);
        projectSensitiveAction.putValue("noIconInMenu", Boolean.TRUE);
        return projectSensitiveAction;
    }

    public static Action profileProjectPopup() {
        ProjectSensitiveAction projectSensitiveAction = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            public boolean enable(Project project, Lookup lookup, boolean bl) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                return AntActions.isProjectTypeSupported(project);
            }

            public void perform(Project project, Lookup lookup) {
                AntActions.doProfileProject(project, null, false);
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectActionPopup"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectActionPopup"), null);
        projectSensitiveAction.putValue("noIconInMenu", Boolean.TRUE);
        return projectSensitiveAction;
    }

    public static Action profileSingle() {
        FileSensitiveAction fileSensitiveAction = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            public boolean enable(Project project, Lookup lookup, boolean bl) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fileObjectArray = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(lookup, project);
                if (fileObjectArray.length != 1) {
                    return false;
                }
                if (!bl) {
                    ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                    if (projectTypeProfiler == null) {
                        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                    }
                    return projectTypeProfiler.isFileObjectSupported(project, fileObjectArray[0]);
                }
                return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
            }

            public void perform(Project project, Lookup lookup) {
                FileObject[] fileObjectArray = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(lookup, project);
                if (fileObjectArray.length != 1) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, fileObjectArray[0], SourceUtils.isTest((FileObject)fileObjectArray[0]));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleAction40_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleAction40"), null);
        fileSensitiveAction.putValue("noIconInMenu", Boolean.TRUE);
        return fileSensitiveAction;
    }

    public static Action profileSinglePopup() {
        FileSensitiveAction fileSensitiveAction = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            public boolean enable(Project project, Lookup lookup, boolean bl) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fileObjectArray = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(lookup, project);
                if (fileObjectArray.length != 1) {
                    return false;
                }
                if (!bl) {
                    ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                    if (!projectTypeProfiler.isFileObjectSupported(project, fileObjectArray[0])) {
                        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                    }
                } else {
                    return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                }
                return true;
            }

            public void perform(Project project, Lookup lookup) {
                FileObject[] fileObjectArray = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(lookup, project);
                if (fileObjectArray.length != 1) {
                    throw new IllegalStateException();
                }
                if (!ProjectUtilities.getProjectTypeProfiler(project).isFileObjectSupported(project, fileObjectArray[0])) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, fileObjectArray[0], SourceUtils.isTest((FileObject)fileObjectArray[0]));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleActionPopup"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleActionPopup"), null);
        fileSensitiveAction.putValue("noIconInMenu", Boolean.TRUE);
        return fileSensitiveAction;
    }

    public static Action profileTest() {
        FileSensitiveAction fileSensitiveAction = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            public boolean enable(Project project, Lookup lookup, boolean bl) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fileObjectArray = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(lookup, project);
                if (fileObjectArray.length != 1) {
                    return false;
                }
                FileObject fileObject = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.findTestForFile((FileObject)fileObjectArray[0]);
                if (fileObject == null) {
                    return false;
                }
                if (!bl) {
                    ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                    return projectTypeProfiler.isFileObjectSupported(project, fileObject);
                }
                return true;
            }

            public void perform(Project project, Lookup lookup) {
                FileObject[] fileObjectArray = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(lookup, project);
                if (fileObjectArray.length != 1) {
                    throw new IllegalStateException();
                }
                FileObject fileObject = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.findTestForFile((FileObject)fileObjectArray[0]);
                if (fileObject == null) {
                    throw new IllegalStateException(FILE_TEST_NOT_FOUND_MSG);
                }
                if (!ProjectUtilities.getProjectTypeProfiler(project).isFileObjectSupported(project, fileObject)) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, fileObject, true);
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileTestAction_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileTestAction"), null);
        fileSensitiveAction.putValue("noIconInMenu", Boolean.TRUE);
        return fileSensitiveAction;
    }

    public static Action unintegrateProfiler() {
        ProjectSensitiveAction projectSensitiveAction = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            public boolean enable(Project project, Lookup lookup, boolean bl) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                return projectTypeProfiler.supportsUnintegrate(project);
            }

            public void perform(Project project, Lookup lookup) {
                ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                try {
                    projectTypeProfiler.unintegrateProfiler(project);
                }
                catch (Exception exception) {
                    ProfilerLogger.log((Exception)exception);
                }
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_UnintegrateProfilerAction"), NbBundle.getMessage(AntActions.class, (String)"LBL_UnintegrateProfilerAction"), null);
        projectSensitiveAction.putValue("noIconInMenu", Boolean.TRUE);
        return projectSensitiveAction;
    }

    private static String getHeapDumpPath(ProfilerIDESettings profilerIDESettings, Project project) {
        int n = profilerIDESettings.getOOMDetectionMode();
        switch (n) {
            case 1: {
                return System.getProperty("java.io.tmpdir");
            }
            case 2: {
                try {
                    return FileUtil.toFile((FileObject)IDEUtils.getProjectSettingsFolder(project, true)).getAbsolutePath();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, "Cannot resolve project settings directory:\n" + iOException.getMessage());
                    ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                    return null;
                }
            }
            case 3: {
                return profilerIDESettings.getCustomHeapdumpPath();
            }
        }
        return null;
    }

    private static void activateOOMProtection(ProfilerIDESettings profilerIDESettings, Properties properties, Project project) {
        if (profilerIDESettings.isOOMDetectionEnabled()) {
            String string = properties.getProperty("profiler.info.jvmargs");
            string = string != null ? string : "";
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = AntActions.getHeapDumpPath(profilerIDESettings, project);
            if (string2 != null && string2.length() > 0) {
                properties.setProperty("profiler.info.oomeprotection", "yes");
                properties.setProperty("profiler.info.oomeprotection.dumppath", string2);
                if (string2.contains(" ")) {
                    string2 = "\"" + string2 + "\"";
                }
                stringBuffer.append(" -XX:+HeapDumpOnOutOfMemoryError");
                stringBuffer.append(" -XX:HeapDumpPath=").append(string2).append(" ");
                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Enabled");
            }
            properties.setProperty("profiler.info.jvmargs", stringBuffer.toString());
        }
    }

    private static void doProfileProject(final Project project, final FileObject fileObject, final boolean bl) {
        if (ProfilingSupport.getDefault().isProfilingActionInvoked()) {
            return;
        }
        ProfilingSupport.getDefault().setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (ProfilingSupport.checkProfilingInProgress()) {
                        return;
                    }
                    ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                    if (!projectTypeProfiler.isProfilingSupported(project)) {
                        org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.invokeAction((Project)project, (String)(bl ? "profile-tests" : "profile"));
                    } else {
                        String string;
                        String string2;
                        JavaPlatform javaPlatform = AntActions.initPlatform(project, projectTypeProfiler);
                        if (javaPlatform == null) {
                            return;
                        }
                        if (!projectTypeProfiler.checkProjectIsModifiedForProfiler(project)) {
                            return;
                        }
                        if (!projectTypeProfiler.checkProjectCanBeProfiled(project, fileObject)) {
                            return;
                        }
                        ProfilerIDESettings profilerIDESettings = ProfilerIDESettings.getInstance();
                        String string3 = IDEUtils.getPlatformJavaFile(javaPlatform);
                        if (string3 == null) {
                            return;
                        }
                        String string4 = IDEUtils.getPlatformJDKVersion(javaPlatform);
                        if (string4 == null) {
                            Profiler.getDefault().displayError(MessageFormat.format(FAILED_DETERMINE_JAVA_PLATFORM_MSG, javaPlatform.getDisplayName()));
                            return;
                        }
                        SessionSettings sessionSettings = new SessionSettings();
                        sessionSettings.setJavaExecutable(string3);
                        sessionSettings.setJavaVersionString(string4);
                        sessionSettings.setSystemArchitecture(IDEUtils.getPlatformArchitecture(javaPlatform));
                        sessionSettings.setPortNo(profilerIDESettings.getPortNo());
                        projectTypeProfiler.setupProjectSessionSettings(project, sessionSettings);
                        boolean bl2 = false;
                        ProfilingSettings profilingSettings = null;
                        while (!bl2) {
                            profilingSettings = ProfilingSupport.getDefault().selectTaskForProfiling(project, sessionSettings, fileObject, projectTypeProfiler.supportsSettingsOverride());
                            if (profilingSettings == null) {
                                return;
                            }
                            bl2 = true;
                        }
                        ProfilingSettings profilingSettings2 = profilingSettings;
                        Properties properties = new Properties();
                        profilingSettings2.store((Map)properties);
                        sessionSettings.store((Map)properties);
                        String string5 = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
                        properties.setProperty("profiler.info.project.dir", string5);
                        if (fileObject != null) {
                            string2 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
                            properties.setProperty("profiler.info.single.file", string2);
                        }
                        string2 = sessionSettings.getJavaExecutable();
                        String string6 = sessionSettings.getJVMArgs();
                        if (profilingSettings2.getOverrideGlobalSettings()) {
                            string = profilingSettings2.getJavaPlatformName();
                            if (string != null) {
                                string2 = Profiler.getDefault().getPlatformJavaFile(string);
                                JavaPlatform javaPlatform2 = IDEUtils.getJavaPlatformByName(string);
                                if (javaPlatform2 != null) {
                                    properties.setProperty("profiler.info.javaPlatform", (String)javaPlatform2.getProperties().get("platform.ant.name"));
                                }
                            }
                            string6 = profilingSettings2.getJVMArgs();
                        } else {
                            properties.setProperty("profiler.info.javaPlatform", ((String)javaPlatform.getProperties().get("platform.ant.name")).toString());
                        }
                        properties.setProperty("profiler.info.jvm", string2);
                        properties.setProperty("profiler.info.jvmargs", string6);
                        if (string4.equals("jdk15")) {
                            properties.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument15(sessionSettings.getPortNo(), sessionSettings.getSystemArchitecture()));
                            if (IDEUtils.getPlatformJDKMinor(javaPlatform) >= 7) {
                                AntActions.activateOOMProtection(profilerIDESettings, properties, project);
                            } else {
                                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Disabled. Not supported JVM. Use at least 1.4.2_12 or 1.5.0_07");
                            }
                        } else if (string4.equals("jdk16")) {
                            properties.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument16(sessionSettings.getPortNo(), sessionSettings.getSystemArchitecture()));
                            AntActions.activateOOMProtection(profilerIDESettings, properties, project);
                        } else if (string4.equals("jdk17")) {
                            properties.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument17(sessionSettings.getPortNo(), sessionSettings.getSystemArchitecture()));
                            AntActions.activateOOMProtection(profilerIDESettings, properties, project);
                        } else {
                            throw new IllegalArgumentException("Unsupported JDK " + string4);
                        }
                        if (!projectTypeProfiler.startProfilingSession(project, fileObject, bl, properties)) {
                            string = projectTypeProfiler.getProjectBuildScript(project);
                            if (string == null) {
                                Profiler.getDefault().displayError(MessageFormat.format(FAILED_DETERMINE_PROJECT_BUILDSCRIPT_MSG, ProjectUtils.getInformation((Project)project).getName()));
                                return;
                            }
                            int n = bl ? (fileObject == null ? 3 : 4) : (fileObject == null ? 1 : 2);
                            String string7 = projectTypeProfiler.getProfilerTargetName(project, (FileObject)string, n, fileObject);
                            if (string7 == null) {
                                return;
                            }
                            projectTypeProfiler.configurePropertiesForProfiling(properties, project, fileObject);
                            NetBeansProfiler.getDefaultNB().runTarget((FileObject)string, string7, properties);
                        }
                    }
                }
                finally {
                    ProfilingSupport.getDefault().setProfilingActionInvoked(false);
                }
            }
        });
    }

    private static JavaPlatform initPlatform(Project project, ProjectTypeProfiler projectTypeProfiler) {
        ProfilerIDESettings profilerIDESettings = ProfilerIDESettings.getInstance();
        JavaPlatform javaPlatform = IDEUtils.getJavaPlatformByName(profilerIDESettings.getJavaPlatformForProfiling());
        JavaPlatform javaPlatform2 = projectTypeProfiler.getProjectJavaPlatform(project);
        if (!(javaPlatform != null || (javaPlatform = javaPlatform2) != null && MiscUtils.isSupportedJVM((Map)javaPlatform.getSystemProperties()) || (javaPlatform = JavaPlatformSelector.getDefault().selectPlatformToUse()) != null)) {
            return null;
        }
        if (javaPlatform2 != null) {
            Object object;
            while (javaPlatform2.getSpecification().getVersion().compareTo((Object)javaPlatform.getSpecification().getVersion()) > 0 && (object = ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)INCORRECT_JAVA_SPECVERSION_DIALOG_MSG, INCORRECT_JAVA_SPECVERSION_DIALOG_CAPTION, 1))) != NotifyDescriptor.YES_OPTION) {
                if (object == NotifyDescriptor.NO_OPTION) {
                    javaPlatform = JavaPlatformSelector.getDefault().selectPlatformToUse();
                    if (javaPlatform != null) continue;
                    return null;
                }
                return null;
            }
        }
        return javaPlatform;
    }

    private static boolean isProjectTypeSupported(Project project) {
        ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
        if (projectTypeProfiler.isProfilingSupported(project)) {
            return true;
        }
        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile");
    }
}

