/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.modules.profiler.ExportSnapshotAction;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ui.ImagePreviewPanel;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class SaveViewAction
extends AbstractAction {
    private static final String SAVE_VIEW_ACTION_NAME = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SaveViewActionName");
    private static final String SAVE_VIEW_ACTION_DESCR = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SaveViewActionDescr");
    private static final String NO_VIEW_MSG = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_NoViewMsg");
    private static final String SAVING_VIEW_MSG = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SavingViewMsg");
    private static final String OVERWRITE_FILE_CAPTION = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_OverwriteFileCaption");
    private static final String OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_OverwriteFileMsg");
    private static final String CANNOT_OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_CannotOverwriteFileMsg");
    private static final String SAVE_DIALOG_TITLE = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SaveDialogTitle");
    private static final String SAVE_DIALOG_BUTTON = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SaveDialogButton");
    private static final String SAVE_DIALOG_FILTER = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SaveDialogFilter");
    private static final String SAVE_DIALOG_PREVIEW = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SaveDialogPreview");
    private static final String SAVE_DIALOG_VISIBLE = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_SaveDialogVisible");
    private static final String OOME_SAVING_MSG = NbBundle.getMessage(ExportSnapshotAction.class, (String)"SaveViewAction_OomeSavingMsg");
    private static final ImageIcon ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/saveView.png"));
    private static File exportDir;
    private BufferedImage image;
    private ImagePreviewPanel imagePreview;
    private JCheckBox visibleAreaCheckBox;
    private JFileChooser fileChooser;
    private ViewProvider viewProvider;
    private boolean visibleArea;

    public SaveViewAction(ViewProvider viewProvider) {
        this.putValue("Name", SAVE_VIEW_ACTION_NAME);
        this.putValue("ShortDescription", SAVE_VIEW_ACTION_DESCR);
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", "org/netbeans/modules/profiler/resources/export.png");
        this.viewProvider = viewProvider;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SelectedFile selectedFile;
        if (!this.viewProvider.hasView()) {
            NetBeansProfiler.getDefaultNB().displayError(NO_VIEW_MSG);
            return;
        }
        final LiveResultsWindow liveResultsWindow = this.viewProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.viewProvider : null;
        final AppStatusHandler appStatusHandler = NetBeansProfiler.getDefaultNB().getTargetAppRunner().getAppStatusHandler();
        if (liveResultsWindow != null) {
            appStatusHandler.pauseLiveUpdates();
        }
        if ((selectedFile = this.selectSnapshotTargetFile(this.viewProvider)) == null) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        final File file = selectedFile.getSelectedFile();
        if (!this.checkFileExists(file)) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        final boolean bl = selectedFile.visibleArea;
        final BufferedImage bufferedImage = selectedFile.image;
        selectedFile = null;
        this.image = null;
        this.imagePreview.reset();
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progressHandle = null;
                try {
                    BufferedImage bufferedImage3;
                    progressHandle = ProgressHandleFactory.createHandle((String)SAVING_VIEW_MSG);
                    progressHandle.setInitialDelay(0);
                    progressHandle.start();
                    BufferedImage bufferedImage2 = bufferedImage3 = bufferedImage == null ? SaveViewAction.this.viewProvider.getViewImage(bl) : bufferedImage;
                    if (bufferedImage3 != null) {
                        ImageIO.write((RenderedImage)bufferedImage3, "png", file);
                    }
                }
                catch (IOException iOException) {
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NetBeansProfiler.getDefaultNB().displayError(OOME_SAVING_MSG);
                }
                finally {
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                    if (progressHandle != null) {
                        progressHandle.finish();
                    }
                    if (liveResultsWindow != null) {
                        appStatusHandler.resumeLiveUpdates();
                    }
                }
            }
        });
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(SAVE_DIALOG_TITLE);
            this.fileChooser.setApproveButtonText(SAVE_DIALOG_BUTTON);
            this.fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".png") || file.getName().endsWith(".PNG");
                }

                public String getDescription() {
                    return SAVE_DIALOG_FILTER;
                }
            });
            JLabel jLabel = new JLabel(SAVE_DIALOG_PREVIEW);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 5, 0));
            this.imagePreview = new ImagePreviewPanel();
            this.imagePreview.reset();
            this.imagePreview.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
            this.visibleAreaCheckBox = new JCheckBox(SAVE_DIALOG_VISIBLE);
            this.visibleAreaCheckBox.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 0));
            this.visibleAreaCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SaveViewAction.this.image = null;
                    SaveViewAction.this.imagePreview.clearImage();
                    SaveViewAction.this.visibleArea = SaveViewAction.this.visibleAreaCheckBox.isSelected();
                    SaveViewAction.this.imagePreview.setImage(new ImagePreviewPanel.ImageProvider(){

                        public BufferedImage getImage() {
                            SaveViewAction.this.image = SaveViewAction.this.viewProvider.getViewImage(SaveViewAction.this.visibleArea);
                            return SaveViewAction.this.image;
                        }
                    });
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)this.imagePreview, "Center");
            jPanel.add((Component)this.visibleAreaCheckBox, "South");
            this.fileChooser.setAccessory(jPanel);
        }
        return this.fileChooser;
    }

    private boolean checkFileExists(File file) {
        if (file.exists()) {
            if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(OVERWRITE_FILE_CAPTION, file.getName()), OVERWRITE_FILE_CAPTION, 0)) != NotifyDescriptor.YES_OPTION) {
                return false;
            }
            if (!file.delete()) {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_OVERWRITE_FILE_MSG, file.getName()));
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectSnapshotTargetFile(final ViewProvider viewProvider) {
        String string;
        File file;
        String string2 = viewProvider.getViewName();
        JFileChooser jFileChooser = this.getFileChooser();
        if (exportDir != null) {
            jFileChooser.setCurrentDirectory(exportDir);
        }
        this.visibleAreaCheckBox.setSelected(true);
        this.visibleAreaCheckBox.setEnabled(!viewProvider.fitsVisibleArea());
        this.image = null;
        this.imagePreview.clearImage();
        this.visibleArea = this.visibleAreaCheckBox.isSelected();
        this.imagePreview.setImage(new ImagePreviewPanel.ImageProvider(){

            public BufferedImage getImage() {
                SaveViewAction.this.image = viewProvider.getViewImage(true);
                return SaveViewAction.this.image;
            }
        });
        int n = jFileChooser.showSaveDialog(IDEUtils.getMainWindow());
        this.imagePreview.reset();
        if (n != 0) {
            this.image = null;
            this.imagePreview.reset();
            return null;
        }
        File file2 = jFileChooser.getSelectedFile();
        String string3 = "png";
        if (file2.isDirectory()) {
            exportDir = jFileChooser.getCurrentDirectory();
            file = file2;
            string = string2;
        } else {
            file = exportDir = jFileChooser.getCurrentDirectory();
            String string4 = file2.getName();
            int n2 = string4.lastIndexOf(".");
            if (n2 == -1) {
                string = string4;
            } else {
                string = string4.substring(0, n2);
                string3 = string4.substring(n2 + 1);
            }
        }
        return new SelectedFile(file, string, string3, this.image, this.visibleArea);
    }

    private static class SelectedFile {
        BufferedImage image;
        File folder;
        String fileExt;
        String fileName;
        boolean visibleArea;

        SelectedFile(File file, String string, String string2, BufferedImage bufferedImage, boolean bl) {
            this.folder = file;
            this.fileName = string;
            this.fileExt = string2;
            this.image = bufferedImage;
            this.visibleArea = bl;
        }

        File getSelectedFile() {
            return new File(this.folder + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    static interface ViewProvider {
        public BufferedImage getViewImage(boolean var1);

        public String getViewName();

        public boolean fitsVisibleArea();

        public boolean hasView();
    }
}

