/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.plugins;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.plugins.JsRefactoringPlugin;
import org.netbeans.modules.refactoring.javascript.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveRefactoringPlugin
extends JsRefactoringPlugin {
    private Map<FileObject, String> packagePostfix = new HashMap<FileObject, String>();
    private AbstractRefactoring refactoring;
    ArrayList<FileObject> filesToMove = new ArrayList();
    HashMap<FileObject, ElementHandle> classes;
    Map<FileObject, Set<FileObject>> whoReferences = new HashMap<FileObject, Set<FileObject>>();
    private FileObject[] origFilesToMove;

    public MoveRefactoringPlugin(MoveRefactoring moveRefactoring) {
        this.refactoring = moveRefactoring;
        Collection collection = moveRefactoring.getRefactoringSource().lookupAll(FileObject.class);
        this.setup(collection, "", true);
    }

    public MoveRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        FileObject fileObject = (FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject != null) {
            this.setup(Collections.singletonList(fileObject), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    @Override
    public Problem preCheck() {
        Problem problem = null;
        for (FileObject fileObject : this.filesToMove) {
            if (RetoucheUtils.isElementInOpenProject(fileObject)) continue;
            problem = MoveRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(JsRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
        }
        return problem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        if (this.refactoring instanceof RenameRefactoring) {
            FileObject fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            if (fileObject != null) {
                String string = ((RenameRefactoring)this.refactoring).getNewName();
                if (fileObject.getParent().getFileObject(string, fileObject.getExt()) != null) {
                    String string2 = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{string});
                    return new Problem(true, string2);
                }
            }
            return super.fastCheckParameters();
        }
        if (this.refactoring instanceof MoveRefactoring) {
            try {
                for (FileObject fileObject : this.filesToMove) {
                    if (!RetoucheUtils.isJsFile(fileObject)) continue;
                    String string = this.getTargetPackageName(fileObject);
                    FileObject fileObject2 = RetoucheUtils.getClassPathRoot((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
                    FileObject fileObject3 = fileObject2.getFileObject(string.replace('.', '/'));
                    String string3 = null;
                    if (fileObject3 != null && !fileObject3.canWrite()) {
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly")).format(new Object[]{string}));
                    }
                    string3 = string;
                    if (string3 == null) {
                        string3 = "";
                    } else if (string3.length() > 0) {
                        string3 = string3 + '.';
                    }
                    String string4 = fileObject.getName();
                    if (fileObject3 == null) continue;
                    FileObject[] fileObjectArray = fileObject3.getChildren();
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        if (!fileObjectArray[i].getName().equals(string4) || !"java".equals(fileObjectArray[i].getExt()) || fileObjectArray[i].equals(fileObject) || fileObjectArray[i].isVirtual()) continue;
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{string4}));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.fastCheckParameters();
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Iterator<Map.Entry<FileObject, ElementHandle>> iterator = this.classes.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<FileObject, ElementHandle> entry = iterator.next();
            Set set = Collections.emptySet();
            System.out.println("TODO");
            throw new RuntimeException("not yet implemented!");
        }
        hashSet.addAll(this.filesToMove);
        return hashSet;
    }

    private void initClasses() {
        this.classes = new HashMap();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            int n = i;
            try {
                Source source = RetoucheUtils.getSource(this.filesToMove.get(i));
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        System.out.println("TODO");
                        throw new RuntimeException("not yet implemented!");
                    }
                }, true);
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        this.initClasses();
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        if (!set.isEmpty()) {
            throw new RuntimeException("Not yet implemented");
        }
        this.fireProgressListenerStop();
        return null;
    }

    String getNewPackageName() {
        if (this.refactoring instanceof MoveRefactoring) {
            return RetoucheUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
        }
        return ((RenameRefactoring)this.refactoring).getNewName();
    }

    String getTargetPackageName(FileObject fileObject) {
        if (this.refactoring instanceof RenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject fileObject2 = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
            FileObject fileObject3 = classPath.findOwnerRoot(fileObject2);
            String string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2.getParent()).replace('/', '.');
            String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()).replace('/', '.');
            String string3 = this.concat(string, this.getNewPackageName(), string2);
            return string3;
        }
        if (this.packagePostfix != null) {
            String string = this.packagePostfix.get(fileObject);
            String string4 = this.concat(null, this.getNewPackageName(), string);
            return string4;
        }
        return this.getNewPackageName();
    }

    private void setup(Collection<FileObject> collection, String string, boolean bl) {
        for (FileObject fileObject : collection) {
            if (RetoucheUtils.isJsFile(fileObject)) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                this.filesToMove.add(fileObject);
                continue;
            }
            if (!fileObject.isFolder()) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fileObject)) continue;
            boolean bl2 = !"".equals(string);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (fileObject2.isFolder() && (!fileObject2.isFolder() || !bl)) continue;
                arrayList.add(fileObject2);
            }
            this.setup(arrayList, string + (bl2 ? "." : "") + fileObject.getName(), bl);
        }
    }

    private String concat(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && !"".equals(string)) {
            string4 = string4 + string + ".";
        }
        string4 = string4 + string2;
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + ("".equals(string4) ? "" : ".") + string3;
        }
        return string4;
    }

    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        return null;
    }

    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        return null;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController compilationController) throws IOException {
        return null;
    }

    @Override
    protected Source getJsSource(JsRefactoringPlugin.Phase phase) {
        return null;
    }
}

