/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.AbstractDesignEditor;
import org.netbeans.modules.xml.multiview.ui.ErrorPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ChoiceView;
import org.openide.explorer.view.NodeListModel;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ToolBarDesignEditor
extends AbstractDesignEditor {
    protected JComponent designPanel;
    private ErrorPanel errorPanel;
    private Object lastActive;

    public ToolBarDesignEditor() {
        this.createDesignPanel();
        this.add("Center", this.designPanel);
        this.add("South", this.createErrorPanel());
    }

    public ToolBarDesignEditor(PanelView panelView) {
        super(panelView);
        this.createDesignPanel();
        this.designPanel.add((Component)panelView, "Center");
        this.add("Center", this.designPanel);
        this.add("South", this.createErrorPanel());
        panelView.attachErrorPanel(this.errorPanel);
    }

    public JComponent createDesignPanel() {
        this.designPanel = new JPanel(new BorderLayout());
        return this.designPanel;
    }

    public void setContentView(PanelView panelView) {
        if (this.getContentView() != null) {
            this.designPanel.remove(this.getContentView());
        }
        this.designPanel.add((Component)panelView, "Center");
        panelView.attachErrorPanel(this.errorPanel);
        super.setContentView(panelView);
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    public Error getError() {
        return this.errorPanel == null ? null : this.errorPanel.getError();
    }

    private ErrorPanel createErrorPanel() {
        this.errorPanel = new ErrorPanel(this);
        return this.errorPanel;
    }

    public JComponent createStructureComponent() {
        ToolBarView toolBarView = new ToolBarView(this.getExplorerManager(), this.getContentView().getRoot(), this.helpAction);
        return toolBarView;
    }

    public Object getLastActive() {
        return this.lastActive;
    }

    public void setLastActive(Object object) {
        this.lastActive = object;
    }

    private static class ToolBarView
    extends JToolBar
    implements ExplorerManager.Provider,
    Lookup.Provider {
        private ExplorerManager manager;
        private Lookup lookup;
        private Action helpAction;

        ToolBarView(ExplorerManager explorerManager, Node node, Action action) {
            this.manager = explorerManager;
            this.helpAction = action;
            this.setLayout(new GridBagLayout());
            ActionMap actionMap = this.getActionMap();
            this.lookup = ExplorerUtils.createLookup((ExplorerManager)explorerManager, (ActionMap)actionMap);
            ChoiceView choiceView = new ChoiceView();
            ((NodeListModel)choiceView.getModel()).setNode(node);
            this.setFloatable(false);
            ((NodeListModel)choiceView.getModel()).setDepth(5);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 2, 4, 0);
            this.add((Component)choiceView, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel = new JPanel();
            this.add((Component)jPanel, gridBagConstraints);
            JButton jButton = new JButton(action);
            jButton.setText("");
            jButton.setContentAreaFilled(false);
            jButton.setFocusPainted(false);
            jButton.setBorderPainted(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            this.add((Component)jButton, gridBagConstraints);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public void addNotify() {
            super.addNotify();
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
        }

        public void removeNotify() {
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        }
    }
}

