/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionConstants;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionUtil;
import org.netbeans.modules.xslt.core.text.completion.XSLTEditorComponentHolder;
import org.netbeans.modules.xslt.core.text.completion.handler.BaseCompletionHandler;
import org.netbeans.modules.xslt.model.AttributeSet;
import org.netbeans.modules.xslt.model.Stylesheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerUseAttributeSets
extends BaseCompletionHandler
implements XSLTCompletionConstants {
    @Override
    public List<XSLTCompletionResultItem> getResultItemList(XSLTEditorComponentHolder xSLTEditorComponentHolder) {
        this.initHandler(xSLTEditorComponentHolder);
        return this.getAttributeSetNameList();
    }

    private List<XSLTCompletionResultItem> getAttributeSetNameList() {
        if (this.attributeName == null || this.xslModel == null) {
            return Collections.emptyList();
        }
        if (!XSLTCompletionUtil.ignoreNamespace(this.attributeName).equals("use-attribute-sets")) {
            return Collections.emptyList();
        }
        if (this.xslModel != null && this.xslModel.getState().equals((Object)Model.State.NOT_WELL_FORMED)) {
            return this.getIncorrectDocumentResultItem();
        }
        return this.findAttributeSetNames();
    }

    private List<XSLTCompletionResultItem> findAttributeSetNames() {
        Stylesheet stylesheet = this.xslModel.getStylesheet();
        List list = stylesheet.getChildren(AttributeSet.class);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<XSLTCompletionResultItem> arrayList = new ArrayList<XSLTCompletionResultItem>();
        for (AttributeSet attributeSet : list) {
            String string;
            QName qName = attributeSet.getName();
            if (qName == null || (string = qName.toString()) == null || string.length() <= 0) continue;
            XSLTCompletionResultItem xSLTCompletionResultItem = new XSLTCompletionResultItem(string, this.document, this.caretOffset);
            xSLTCompletionResultItem.setSortPriority(arrayList.size());
            arrayList.add(xSLTCompletionResultItem);
        }
        return arrayList;
    }
}

