/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.context;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.core.context.MapperContextImpl;
import org.netbeans.modules.xslt.mapper.model.MapperContext;
import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.OperationReference;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.util.TMapUtil;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperContextFactory {
    private static MapperContextFactory INSTANCE = new MapperContextFactory();

    private MapperContextFactory() {
    }

    public static MapperContextFactory getInstance() {
        return INSTANCE;
    }

    public MapperContext createMapperContext(FileObject fileObject, Project project) {
        assert (fileObject != null && project != null);
        MapperContextImpl mapperContextImpl = null;
        FileObject fileObject2 = Util.getTMapFo((Project)project);
        XslModel xslModel = org.netbeans.modules.xslt.core.util.Util.getXslModel(fileObject);
        if (fileObject2 == null) {
            fileObject2 = Util.createDefaultTransformmap((Project)project);
            return new MapperContextImpl(xslModel, Util.getTMapModel((FileObject)fileObject2));
        }
        TMapModel tMapModel = Util.getTMapModel((FileObject)fileObject2);
        if (tMapModel == null) {
            return new MapperContextImpl(xslModel, Util.getTMapModel((FileObject)fileObject2));
        }
        Transform transform = TMapUtil.getTransform((TMapModel)tMapModel, (FileObject)fileObject);
        if (transform == null) {
            return new MapperContextImpl(xslModel, Util.getTMapModel((FileObject)fileObject2));
        }
        AXIComponent aXIComponent = TMapUtil.getSourceComponent((Transform)transform);
        AXIComponent aXIComponent2 = TMapUtil.getTargetComponent((Transform)transform);
        mapperContextImpl = new MapperContextImpl(transform, xslModel, aXIComponent, aXIComponent2);
        return mapperContextImpl;
    }

    public void reinitMapperContext(MapperContextImpl mapperContextImpl, FileObject fileObject, Project project, EventObject eventObject) {
        XslModel xslModel;
        assert (project != null);
        FileObject fileObject2 = Util.getTMapFo((Project)project);
        TMapModel tMapModel = fileObject2 == null ? null : Util.getTMapModel((FileObject)fileObject2);
        XslModel xslModel2 = xslModel = fileObject == null ? null : org.netbeans.modules.xslt.core.util.Util.getXslModel(fileObject);
        if (fileObject == null || tMapModel == null) {
            mapperContextImpl.reinit(tMapModel, null, xslModel, null, null, eventObject);
            return;
        }
        Transform transform = TMapUtil.getTransform((TMapModel)tMapModel, (FileObject)fileObject);
        if (transform == null) {
            mapperContextImpl.reinit(tMapModel, null, xslModel, null, null, eventObject);
            return;
        }
        AXIComponent aXIComponent = TMapUtil.getSourceComponent((Transform)transform);
        AXIComponent aXIComponent2 = TMapUtil.getTargetComponent((Transform)transform);
        mapperContextImpl.reinit(tMapModel, transform, xslModel, aXIComponent, aXIComponent2, eventObject);
    }

    public ReferenceableSchemaComponent getSourceType(Transform transform) {
        assert (transform != null);
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        TMapComponent tMapComponent = (TMapComponent)transform.getParent();
        if (tMapComponent == null) {
            return null;
        }
        assert (tMapComponent instanceof org.netbeans.modules.xslt.tmap.model.api.Operation);
        Reference reference = ((org.netbeans.modules.xslt.tmap.model.api.Operation)tMapComponent).getOperation();
        Operation operation = null;
        if (reference != null) {
            operation = (Operation)reference.get();
        }
        if (operation != null) {
            NamedComponentReference namedComponentReference;
            Input input = operation.getInput();
            NamedComponentReference namedComponentReference2 = namedComponentReference = input == null ? null : input.getMessage();
            if (namedComponentReference != null) {
                referenceableSchemaComponent = this.getMessageSchemaType(operation.getModel(), (NamedComponentReference<Message>)namedComponentReference);
            }
        }
        return referenceableSchemaComponent;
    }

    public ReferenceableSchemaComponent getTargetType(Transform transform) {
        assert (transform != null);
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        TMapComponent tMapComponent = (TMapComponent)transform.getParent();
        if (tMapComponent == null) {
            return null;
        }
        assert (tMapComponent instanceof org.netbeans.modules.xslt.tmap.model.api.Operation);
        Reference reference = ((org.netbeans.modules.xslt.tmap.model.api.Operation)tMapComponent).getOperation();
        Operation operation = null;
        if (reference != null) {
            operation = (Operation)reference.get();
        }
        if (operation != null) {
            NamedComponentReference namedComponentReference;
            Output output = operation.getOutput();
            NamedComponentReference namedComponentReference2 = namedComponentReference = output == null ? null : output.getMessage();
            if (namedComponentReference != null) {
                referenceableSchemaComponent = this.getMessageSchemaType(operation.getModel(), (NamedComponentReference<Message>)namedComponentReference);
            }
        }
        return referenceableSchemaComponent;
    }

    private ReferenceableSchemaComponent getMessageSchemaType(WSDLModel wSDLModel, NamedComponentReference<Message> namedComponentReference) {
        NamedComponentReference namedComponentReference2;
        if (wSDLModel == null || namedComponentReference == null) {
            return null;
        }
        ReferenceableSchemaComponent referenceableSchemaComponent = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Collection collection = ((Message)namedComponentReference.get()).getParts();
        Part part = null;
        if (collection != null && collection.size() > 0) {
            part = (Part)collection.iterator().next();
        }
        if ((namedComponentReference2 = part.getElement()) == null) {
            namedComponentReference2 = part.getType();
        }
        referenceableSchemaComponent = (ReferenceableSchemaComponent)namedComponentReference2.get();
        return referenceableSchemaComponent;
    }

    private Message getVariableMessage(String string, Transform transform) {
        if (string == null || transform == null) {
            return null;
        }
        String string2 = this.getVarLocalName(string);
        if (string2 == null) {
            return null;
        }
        TMapComponent tMapComponent = (TMapComponent)transform.getParent();
        if (tMapComponent == null) {
            return null;
        }
        assert (tMapComponent instanceof org.netbeans.modules.xslt.tmap.model.api.Operation);
        Message message = null;
        if (string2.equals(((org.netbeans.modules.xslt.tmap.model.api.Operation)tMapComponent).getInputVariable())) {
            message = this.getMessage((OperationReference)((org.netbeans.modules.xslt.tmap.model.api.Operation)tMapComponent), true);
        } else if (string2.equals(((org.netbeans.modules.xslt.tmap.model.api.Operation)tMapComponent).getOutputVariable())) {
            message = this.getMessage((OperationReference)((org.netbeans.modules.xslt.tmap.model.api.Operation)tMapComponent), false);
        } else {
            List list = ((org.netbeans.modules.xslt.tmap.model.api.Operation)tMapComponent).getInvokes();
            if (list != null && list.size() > 0) {
                for (Invoke invoke : list) {
                    Object var9_9 = null;
                    if (invoke == null) continue;
                    if (string2.equals(invoke.getInputVariable())) {
                        message = this.getMessage((OperationReference)invoke, true);
                        break;
                    }
                    if (!string2.equals(invoke.getOutputVariable())) continue;
                    message = this.getMessage((OperationReference)invoke, false);
                    break;
                }
            }
        }
        return message;
    }

    private Message getMessage(OperationReference operationReference, boolean bl) {
        Operation operation;
        if (operationReference == null) {
            return null;
        }
        Message message = null;
        Reference reference = operationReference.getOperation();
        Operation operation2 = operation = reference == null ? null : (Operation)reference.get();
        if (operation != null) {
            Input input = bl ? operation.getInput() : operation.getOutput();
            NamedComponentReference namedComponentReference = input == null ? null : input.getMessage();
            message = namedComponentReference == null ? null : (Message)namedComponentReference.get();
        }
        return message;
    }

    private String getVarLocalName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String getVarPartName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }
}

