/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.integration;

import java.util.List;
import java.util.Vector;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.exceptions.ModificationException;
import org.netbeans.lib.profiler.common.integration.exceptions.RunException;

public interface IntegrationProvider {
    public IntegrationHints getAfterInstallationHints(AttachSettings var1, boolean var2);

    public IntegrationHints getIntegrationReview(AttachSettings var1);

    public IntegrationHints getModificationHints(AttachSettings var1);

    public void setTargetJava(String var1);

    public String getTargetJava();

    public void setTargetJavaHome(String var1);

    public String getTargetJavaHome();

    public String getTitle();

    public void modify(AttachSettings var1) throws ModificationException;

    public void run(AttachSettings var1) throws RunException;

    public boolean supportsAutomation();

    public boolean supportsDirect();

    public boolean supportsDynamic();

    public boolean supportsLocal();

    public boolean supportsManual();

    public boolean supportsRemote();

    public static class IntegrationHints {
        private List hints;
        private List steps = new Vector(10);
        private List warnings;
        private boolean warningsFirst = true;

        public IntegrationHints() {
            this.hints = new Vector(10);
            this.warnings = new Vector(10);
        }

        public List getHints() {
            return this.copyLock(this.hints);
        }

        public List getSteps() {
            return this.copyLock(this.steps);
        }

        public List getWarnings() {
            return this.copyLock(this.warnings);
        }

        public void setWarningsFirst(boolean bl) {
            this.warningsFirst = bl;
        }

        public boolean isWarningsFirst() {
            return this.warningsFirst;
        }

        public void addHint(String string) {
            this.hints.add(string);
        }

        public void addStep(String string) {
            this.steps.add(string);
        }

        public void addStep(int n, String string) {
            this.steps.add(n, string);
        }

        public void addWarning(String string) {
            this.warnings.add(string);
        }

        public void clear() {
            this.hints.clear();
            this.steps.clear();
            this.warnings.clear();
        }

        public void removeHint(String string) {
            this.hints.remove(string);
        }

        public void removeStep(String string) {
            this.steps.remove(string);
        }

        public void removeWarning(String string) {
            this.warnings.remove(string);
        }

        private List copyLock(List list) {
            Vector vector = new Vector();
            vector.addAll(list);
            return vector;
        }
    }
}

