/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Hashtable;
import java.util.Vector;
import org.netbeans.microedition.svg.SVGActionListener;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.SVGLabel;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.meta.ChildrenAcceptor;
import org.netbeans.microedition.svg.meta.MetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public abstract class SVGComponent
implements SVGForm.FocusListener {
    public static final String SVG_NS = "http://www.w3.org/2000/svg";
    public static final String LABEL_FOR = "labelFor";
    public static final String ENABLED = "enabled";
    protected static final String TRAIT_X = "x";
    protected static final String TRAIT_Y = "y";
    protected static final String TRAIT_VISIBILITY = "visibility";
    protected static final String TRAIT_FILL = "fill";
    protected static final String TRAIT_TEXT = "#text";
    protected static final String TYPE = "type";
    protected static final String REF = "ref";
    protected static final String TR_VALUE_VISIBLE = "visible";
    protected static final String TR_VALUE_HIDDEN = "hidden";
    protected static final String TR_VALUE_INHERIT = "inherit";
    protected static final String DASH = "_";
    private Hashtable myProperties;
    protected final SVGForm form;
    protected final SVGLocatableElement wrapperElement;
    protected Vector actionListeners;

    public SVGComponent(SVGForm form, SVGLocatableElement element) {
        this.form = form;
        this.wrapperElement = element;
    }

    public SVGComponent(SVGForm form, String elemId) {
        this.form = form;
        Document doc = form.getDocument();
        this.wrapperElement = (SVGLocatableElement)doc.getElementById(elemId);
    }

    public SVGLocatableElement getElement() {
        return this.wrapperElement;
    }

    public SVGForm getForm() {
        return this.form;
    }

    public void requestFocus() {
        this.form.requestFocus(this);
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public InputHandler getInputHandler() {
        return null;
    }

    public synchronized void addActionListener(SVGActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector(1);
        }
        this.actionListeners.addElement(listener);
    }

    public synchronized void removeActionListener(SVGActionListener listener) {
        if (this.actionListeners != null) {
            this.actionListeners.removeElement(listener);
            if (this.actionListeners.isEmpty()) {
                this.actionListeners = null;
            }
        }
    }

    protected Object getProperty(Object key) {
        if (this.myProperties == null) {
            return null;
        }
        return this.myProperties.get(key);
    }

    protected void setProperty(Object key, Object value) {
        if (this.myProperties == null) {
            this.myProperties = new Hashtable();
        }
        this.myProperties.put(key, value);
    }

    protected synchronized void fireActionPerformed() {
        if (this.actionListeners != null) {
            int listenersNum = this.actionListeners.size();
            for (int i = 0; i < listenersNum; ++i) {
                ((SVGActionListener)this.actionListeners.elementAt(i)).actionPerformed(this);
            }
        }
    }

    protected SVGLabel getLabel() {
        return this.getForm().getLabelFor(this);
    }

    protected void setTraitSafely(final SVGElement element, final String trait, final String value) {
        this.getForm().invokeAndWaitSafely(new Runnable(){

            public void run() {
                element.setTrait(trait, value);
            }
        });
    }

    protected void setTraitSafely(final SVGElement element, final String trait, final float value) {
        this.getForm().invokeAndWaitSafely(new Runnable(){

            public void run() {
                element.setFloatTrait(trait, value);
            }
        });
    }

    protected final SVGElement getElementById(final SVGElement parent, final String childId) {
        final Vector ret = new Vector(1);
        final Document doc = this.getForm().getDocument();
        Runnable runnable = new Runnable(){

            public void run() {
                IdFinder finder = new IdFinder(childId);
                ChildrenAcceptor acceptor = new ChildrenAcceptor(finder);
                acceptor.accept(parent);
                SVGElement result = finder.getFound();
                if (result == null) {
                    result = (SVGElement)doc.getElementById(childId);
                }
                ret.addElement(result);
            }
        };
        this.getForm().invokeAndWaitSafely(runnable);
        return (SVGElement)ret.elementAt(0);
    }

    protected final SVGElement getElementByMeta(final SVGElement parent, final String key, final String value, boolean runInsideDocumentUpdateThread) {
        final Vector ret = new Vector(1);
        Runnable runnable = new Runnable(){

            public void run() {
                MetaFinder finder = new MetaFinder(key, value);
                ChildrenAcceptor acceptor = new ChildrenAcceptor(finder);
                acceptor.accept(parent);
                ret.addElement(finder.getFound());
            }
        };
        if (runInsideDocumentUpdateThread) {
            runnable.run();
        } else {
            this.getForm().invokeAndWaitSafely(runnable);
        }
        return (SVGElement)ret.elementAt(0);
    }

    protected final SVGElement getElementByMeta(SVGElement parent, String key, String value) {
        return this.getElementByMeta(parent, key, value, false);
    }

    protected final SVGElement getNestedElementByMeta(final SVGElement parent, final String key, final String value) {
        final Vector ret = new Vector(1);
        Runnable runnable = new Runnable(){

            public void run() {
                MetaFinder finder = new MetaFinder(key, value);
                ChildrenAcceptor acceptor = new ChildrenAcceptor(finder);
                acceptor.accept(parent);
                ret.addElement(finder.getNestedElement());
            }
        };
        this.getForm().invokeAndWaitSafely(runnable);
        return (SVGElement)ret.elementAt(0);
    }

    private static class IdFinder
    implements ChildrenAcceptor.Visitor {
        private String myId;
        private SVGElement myFound;

        IdFinder(String id) {
            this.myId = id;
        }

        public boolean visit(Element element) {
            if (!(element instanceof SVGElement)) {
                return true;
            }
            String id = ((SVGElement)element).getId();
            if (this.myId.equals(id)) {
                this.myFound = (SVGElement)element;
                return false;
            }
            return true;
        }

        SVGElement getFound() {
            return this.myFound;
        }
    }

    private static class MetaFinder
    implements ChildrenAcceptor.Visitor {
        private String myKey;
        private String myValue;
        private MetaData myMeta;
        private SVGElement myFound;
        private SVGElement myNested;

        MetaFinder(String key, String value) {
            this.myKey = key;
            this.myValue = value;
            this.myMeta = new MetaData();
        }

        public boolean visit(Element element) {
            if (!(element instanceof SVGElement)) {
                return true;
            }
            this.myMeta.loadFromElement((SVGElement)element);
            if (this.myValue == null && this.myMeta.get(this.myKey) == null) {
                this.myFound = (SVGElement)element;
                this.myNested = this.myMeta.getNestedElement();
                return false;
            }
            if (this.myValue == null) {
                return true;
            }
            if (this.myValue.equals(this.myMeta.get(this.myKey))) {
                this.myFound = (SVGElement)element;
                this.myNested = this.myMeta.getNestedElement();
                return false;
            }
            return true;
        }

        SVGElement getFound() {
            return this.myFound;
        }

        SVGElement getNestedElement() {
            return this.myNested;
        }
    }
}

