/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.web.client.tools.common.dbgp.Breakpoint;
import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandFactory;
import org.netbeans.modules.web.client.tools.common.dbgp.Eval;
import org.netbeans.modules.web.client.tools.common.dbgp.Feature;
import org.netbeans.modules.web.client.tools.common.dbgp.HttpMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.InitMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Log;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.netbeans.modules.web.client.tools.common.dbgp.OnloadMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Property;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Source;
import org.netbeans.modules.web.client.tools.common.dbgp.SourcesMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Stack;
import org.netbeans.modules.web.client.tools.common.dbgp.StreamMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.WindowsMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerProxy {
    private volatile Socket sessionSocket;
    private String sessionID;
    private BlockingQueue<Message> suspensionPointQueue = new ArrayBlockingQueue<Message>(128);
    private BlockingQueue<HttpMessage> httpQueue = new ArrayBlockingQueue<HttpMessage>(200);
    private BlockingQueue<ResponseMessage> responseQueue = new ArrayBlockingQueue<ResponseMessage>(8);
    public static final List<DebuggerProxy> proxies = new CopyOnWriteArrayList<DebuggerProxy>();
    private CommandFactory commandFactory;
    private static final AtomicInteger transactionId = new AtomicInteger(0);
    private AtomicBoolean stop = new AtomicBoolean(false);
    private volatile Thread messageHandlerThread;
    private volatile Thread messageSentThread;
    private List<Integer> ignoreIDs = new LinkedList<Integer>();
    private static final String statusText = "<response command=\"status\" status=\"stopped\" reason=\"exception\"/>";

    public DebuggerProxy(Socket socket, String string) {
        this.sessionSocket = socket;
        this.sessionID = string;
    }

    public synchronized boolean isActive() {
        if (this.messageHandlerThread != null) {
            return true;
        }
        return this.suspensionPointQueue.size() > 0 || this.httpQueue.size() > 0;
    }

    public void setBooleanFeature(Feature.Name name, boolean bl) {
        this.sendCommand(this.getCommandFactory().featureSetCommand(name, String.valueOf(bl)));
    }

    public void openURI(URI uRI) throws URISyntaxException {
        this.sendCommand(this.getCommandFactory().openURICommand(uRI));
    }

    private void cleanup() {
        try {
            this.sessionSocket.close();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Cannot close socket", iOException);
        }
        proxies.remove(this);
        this.messageHandlerThread = null;
        this.sessionSocket = null;
    }

    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    int getTransactionId() {
        return transactionId.getAndIncrement();
    }

    public boolean startDebugging() {
        boolean bl = false;
        if (this.messageHandlerThread == null) {
            try {
                this.commandFactory = new CommandFactory(this);
                this.messageHandlerThread = new MessageHandler(this.sessionSocket.getInputStream(), this.sessionID);
                this.messageHandlerThread.start();
                bl = true;
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.SEVERE, "Cannot get socket's input stream", iOException);
            }
        }
        return bl;
    }

    public boolean stopDebugging() {
        boolean bl = false;
        if (this.messageHandlerThread != null) {
            this.sendCommand(this.commandFactory.stopCommand());
            this.stop.set(true);
            bl = true;
        }
        return bl;
    }

    public void run() {
        this.sendCommand(this.getCommandFactory().runCommand());
    }

    public void pause() {
        this.sendCommand(this.getCommandFactory().pauseCommand());
    }

    public void stepInto() {
        this.sendCommand(this.getCommandFactory().stepIntoCommand());
    }

    public void stepOver() {
        this.sendCommand(this.getCommandFactory().stepOverCommand());
    }

    public void stepOut() {
        this.sendCommand(this.getCommandFactory().stepOutCommand());
    }

    public void runToCursor(Breakpoint.BreakpointSetCommand breakpointSetCommand) {
        this.setBreakpoint(breakpointSetCommand);
    }

    public String setBreakpoint(Breakpoint.BreakpointSetCommand breakpointSetCommand) {
        Breakpoint.BreakpointSetResponse breakpointSetResponse = (Breakpoint.BreakpointSetResponse)this.sendCommand(breakpointSetCommand);
        return breakpointSetResponse != null ? breakpointSetResponse.getId() : null;
    }

    public boolean removeBreakpoint(String string) {
        Breakpoint.BreakpointRemoveResponse breakpointRemoveResponse = (Breakpoint.BreakpointRemoveResponse)this.sendCommand(this.commandFactory.breakpointRemoveCommand(string));
        return breakpointRemoveResponse != null;
    }

    public boolean updateBreakpoint(String string, Boolean bl, int n, int n2, Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE, String string2) {
        Breakpoint.BreakpointUpdateResponse breakpointUpdateResponse;
        Breakpoint.BreakpointUpdateCommand breakpointUpdateCommand = this.commandFactory.breakpointUpdateCommand(string);
        if (bl != null) {
            breakpointUpdateCommand.setState(bl);
        }
        if (n != -1) {
            breakpointUpdateCommand.setLineNumber(n);
        }
        if (n2 != -1) {
            breakpointUpdateCommand.setHitValue(n2);
        }
        if (hIT_COUNT_FILTERING_STYLE != null) {
            breakpointUpdateCommand.setHitCondition(hIT_COUNT_FILTERING_STYLE.name());
        }
        if (string2 != null) {
            breakpointUpdateCommand.setCondition(string2);
        }
        return (breakpointUpdateResponse = (Breakpoint.BreakpointUpdateResponse)this.sendCommand(breakpointUpdateCommand)) != null;
    }

    public List<Breakpoint> getBreakpoints(List<String> list) {
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (String string : list) {
            arrayList.add(this.getBreakpoint(string));
        }
        return arrayList;
    }

    public Breakpoint getBreakpoint(String string) {
        Breakpoint.BreakpointGetResponse breakpointGetResponse = (Breakpoint.BreakpointGetResponse)this.sendCommand(this.getCommandFactory().breakpointGetCommand(string));
        return breakpointGetResponse != null ? breakpointGetResponse.getBreakpoint() : null;
    }

    public List<Breakpoint> getBreakpoints() {
        Breakpoint.BreakpointListResponse breakpointListResponse = (Breakpoint.BreakpointListResponse)this.sendCommand(this.getCommandFactory().breakpointListCommand());
        return breakpointListResponse != null ? breakpointListResponse.getBreakpoints() : null;
    }

    public String getSource(URI uRI) {
        Source.SourceResponse sourceResponse = (Source.SourceResponse)this.sendCommand(this.getCommandFactory().sourceCommand(uRI));
        return sourceResponse != null ? sourceResponse.getSourceCode() : null;
    }

    public Message getSuspensionPoint() {
        try {
            return this.suspensionPointQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Log.getLogger().log(Level.FINEST, "Interrrupted while waiting for suspension point", interruptedException);
            return null;
        }
    }

    public Message getHttpMessage() {
        try {
            return this.httpQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Log.getLogger().log(Level.FINEST, "Interrrupted while waiting for http message", interruptedException);
            return null;
        }
    }

    public Stack getCallStack(int n) {
        Stack.StackGetResponse stackGetResponse = (Stack.StackGetResponse)this.sendCommand(this.getCommandFactory().stackGetCommand(n));
        return stackGetResponse != null ? stackGetResponse.getStackElements().get(0) : null;
    }

    public List<Stack> getCallStacks() {
        Stack.StackGetResponse stackGetResponse = (Stack.StackGetResponse)this.sendCommand(this.getCommandFactory().stackGetCommand(-1));
        return stackGetResponse != null ? stackGetResponse.getStackElements() : null;
    }

    public Property getProperty(String string, int n) {
        Property.PropertyGetResponse propertyGetResponse = (Property.PropertyGetResponse)this.sendCommand(this.getCommandFactory().propertyGetCommand(string, n));
        return propertyGetResponse != null ? propertyGetResponse.getProperty() : null;
    }

    public boolean setProperty(String string, String string2, int n) {
        Property.PropertySetResponse propertySetResponse = (Property.PropertySetResponse)this.sendCommand(this.getCommandFactory().propertySetCommand(string, string2, n));
        return propertySetResponse != null ? Boolean.valueOf(propertySetResponse.isSet()) : null;
    }

    public Property eval(String string, int n) {
        Eval.EvalResponse evalResponse = (Eval.EvalResponse)this.sendCommand(this.getCommandFactory().evalCommand(string, n));
        return evalResponse != null && evalResponse.isSuccess() ? evalResponse.getProperty() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResponseMessage sendCommand(Command command) {
        if (this.sessionSocket == null) {
            Log.getLogger().log(Level.INFO, "\nCannot send command after session is closed\n");
            return null;
        }
        try {
            this.messageSentThread = Thread.currentThread();
            command.send(this.sessionSocket.getOutputStream());
            if (command.wantAcknowledgment()) {
                Message message = this.responseQueue.poll(20L, TimeUnit.SECONDS);
                if (message instanceof ResponseMessage) {
                    ResponseMessage responseMessage = (ResponseMessage)message;
                    assert (responseMessage.getTransactionId() == command.getTransactionId());
                    ResponseMessage responseMessage2 = responseMessage;
                    return responseMessage2;
                }
                Log.getLogger().log(Level.FINE, command.getCommandName() + " request timed-out");
                this.ignoreIDs.add(command.getTransactionId());
            }
        }
        catch (SocketException socketException) {
            Log.getLogger().log(Level.WARNING, socketException.getMessage(), socketException);
            this.fireStoppedEvent();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        catch (InterruptedException interruptedException) {
            Log.getLogger().log(Level.FINE, "Interrrupted while waiting for response", interruptedException);
        }
        finally {
            this.messageSentThread = null;
        }
        return null;
    }

    private void handleMessage(Message message) {
        if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            int n = responseMessage.getTransactionId();
            if (n == -1) {
                this.suspensionPointQueue.add(message);
            } else {
                int n2;
                if (this.ignoreIDs.size() > 0 && (n2 = this.ignoreIDs.indexOf(n)) != -1) {
                    this.ignoreIDs.remove(n2);
                    return;
                }
                this.responseQueue.add((ResponseMessage)message);
            }
        } else if (message instanceof InitMessage || message instanceof OnloadMessage || message instanceof SourcesMessage || message instanceof WindowsMessage || message instanceof StreamMessage) {
            this.suspensionPointQueue.add(message);
        } else if (message instanceof HttpMessage) {
            this.httpQueue.add((HttpMessage)message);
        }
    }

    private void fireStoppedEvent() {
        if (this.messageSentThread != null) {
            this.messageSentThread.interrupt();
        }
        Message message = Message.createMessage(statusText);
        this.handleMessage(message);
    }

    private class MessageHandler
    extends Thread {
        private final InputStream is;

        MessageHandler(InputStream inputStream, String string) {
            super("Dbgp message handler " + string);
            this.setDaemon(true);
            this.is = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.getLogger().log(Level.FINEST, "Starting " + this.getName());
            try {
                while (!DebuggerProxy.this.stop.get()) {
                    DebuggerProxy.this.handleMessage(Message.create(this.is));
                }
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.FINE, this.getName() + " stopping because of exception", iOException);
            }
            finally {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    Log.getLogger().log(Level.SEVERE, "Cannot close socket's input stream", iOException);
                }
            }
            DebuggerProxy.this.cleanup();
            if (!DebuggerProxy.this.stop.get()) {
                DebuggerProxy.this.fireStoppedEvent();
            }
            Log.getLogger().log(Level.FINEST, "Ending " + this.getName());
        }
    }
}

