/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.web.client.tools.common.dbgp.Breakpoint;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandFactory;
import org.netbeans.modules.web.client.tools.common.dbgp.DebuggerProxy;
import org.netbeans.modules.web.client.tools.common.dbgp.InitMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Log;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.netbeans.modules.web.client.tools.common.dbgp.OnloadMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Property;
import org.netbeans.modules.web.client.tools.common.dbgp.Stack;
import org.netbeans.modules.web.client.tools.common.dbgp.Status;
import org.netbeans.modules.web.client.tools.common.dbgp.UnsufficientValueException;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSBreakpoint;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSErrorInfo;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSProperty;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSURILocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSValue;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSBreakpointImpl;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbgpUtils {
    public static JSBreakpoint getBreakpoint(Status.StatusResponse statusResponse) {
        if (statusResponse == null) {
            return null;
        }
        Status.DebugMessage debugMessage = statusResponse.getDebugMessage();
        JSBreakpointImpl jSBreakpointImpl = (JSBreakpointImpl)JSFactory.createJSBreakpoint(debugMessage.getFileName(), debugMessage.getLineNumber());
        if (debugMessage.getBreakpointId() != null) {
            jSBreakpointImpl.setId(debugMessage.getBreakpointId());
        }
        return jSBreakpointImpl;
    }

    public static boolean isStepSuccessfull(Status.StatusResponse statusResponse) {
        return statusResponse != null && statusResponse.getState() == Status.State.BREAKPOINT && statusResponse.getReason() == Status.Reason.OK;
    }

    public static Breakpoint.BreakpointSetCommand getDbgpBreakpointCommand(DebuggerProxy debuggerProxy, JSURILocation jSURILocation, boolean bl) {
        CommandFactory commandFactory = debuggerProxy.getCommandFactory();
        Breakpoint.LineBreakpointSetCommand lineBreakpointSetCommand = commandFactory.lineBreakpointSetCommand(jSURILocation.getURI(), jSURILocation.getLineNumber());
        lineBreakpointSetCommand.setTemporary(true);
        lineBreakpointSetCommand.setType(Breakpoint.Type.LINE);
        lineBreakpointSetCommand.setState(true);
        lineBreakpointSetCommand.setHitValue(0);
        lineBreakpointSetCommand.setHitCondition(Breakpoint.HitCondition.EQUAL.name());
        lineBreakpointSetCommand.setCondition("");
        return lineBreakpointSetCommand;
    }

    public static Breakpoint.BreakpointSetCommand getDbgpBreakpointCommand(DebuggerProxy debuggerProxy, JSBreakpoint jSBreakpoint) {
        Object object;
        Breakpoint.BreakpointSetCommand breakpointSetCommand = null;
        CommandFactory commandFactory = debuggerProxy.getCommandFactory();
        switch (jSBreakpoint.getType()) {
            case LINE: {
                object = jSBreakpoint.getLocation();
                breakpointSetCommand = commandFactory.lineBreakpointSetCommand(object.getURI(), object.getLineNumber());
                break;
            }
            case CALL: {
                breakpointSetCommand = commandFactory.callBreakpointSetCommand(jSBreakpoint.getFunction());
                break;
            }
            case CONDITIONAL: {
                breakpointSetCommand = commandFactory.conditionalBreakpointSetCommand(jSBreakpoint.getCondition());
                break;
            }
            case EXCEPTION: {
                breakpointSetCommand = commandFactory.conditionalBreakpointSetCommand(jSBreakpoint.getException());
                break;
            }
        }
        if (breakpointSetCommand != null) {
            String string;
            Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE;
            object = jSBreakpoint.isEnabled();
            if (object != null) {
                breakpointSetCommand.setState((Boolean)object);
            }
            if ((hIT_COUNT_FILTERING_STYLE = jSBreakpoint.getHitCondition()) != null) {
                breakpointSetCommand.setHitCondition(hIT_COUNT_FILTERING_STYLE.name());
                breakpointSetCommand.setHitValue(jSBreakpoint.getHitValue());
            }
            if ((string = jSBreakpoint.getCondition()) != null) {
                breakpointSetCommand.setCondition(string);
            }
        }
        return breakpointSetCommand;
    }

    public static JSDebuggerState getDebuggerState(Message message) {
        if (message instanceof InitMessage) {
            return JSDebuggerState.STARTING_INIT;
        }
        if (message instanceof OnloadMessage) {
            return JSDebuggerState.STARTING_READY;
        }
        if (message instanceof Status.StatusResponse) {
            Status.StatusResponse statusResponse = (Status.StatusResponse)message;
            if (statusResponse.getState() == Status.State.RUNNING) {
                return JSDebuggerState.RUNNING;
            }
            if (statusResponse.getState() == Status.State.FIRST_LINE) {
                return JSDebuggerState.SUSPENDED_FIRST_LINE;
            }
            if (statusResponse.getState() == Status.State.BREAKPOINT) {
                return JSDebuggerState.getDebuggerState(DbgpUtils.getBreakpoint((Status.StatusResponse)message));
            }
            if (statusResponse.getState() == Status.State.EXCEPTION) {
                return JSDebuggerState.getDebuggerState((JSErrorInfo)null);
            }
            if (statusResponse.getState() == Status.State.STEP) {
                return JSDebuggerState.SUSPENDED_STEP;
            }
            if (statusResponse.getState() == Status.State.DEBUGGER) {
                return JSDebuggerState.SUSPENDED_DEBUGGER;
            }
            if (statusResponse.getState() == Status.State.STOPPED) {
                return JSDebuggerState.DISCONNECTED;
            }
        }
        return null;
    }

    public static List<JSBreakpoint> getJSBreakpoints(List<Breakpoint> list) {
        ArrayList<JSBreakpoint> arrayList = new ArrayList<JSBreakpoint>();
        if (list != null) {
            for (Breakpoint breakpoint : list) {
                arrayList.add(DbgpUtils.getJSBreakpoint(breakpoint));
            }
        }
        return arrayList;
    }

    public static JSBreakpoint getJSBreakpoint(Breakpoint breakpoint) {
        if (breakpoint != null) {
            JSFactory.createJSBreakpoint(breakpoint.getFileURI(), breakpoint.getLineNumber(), breakpoint.getId());
        }
        return null;
    }

    public static JSCallStackFrame getJSCallStackFrame(JSDebugger jSDebugger, Stack stack) {
        if (stack != null) {
            return JSFactory.createJSCallStackFrame(jSDebugger, stack.getLevel(), JSCallStackFrame.TYPE.valueOf(stack.getType().name()), stack.getWhere(), stack.getFileName(), stack.getLine());
        }
        return null;
    }

    public static List<JSCallStackFrame> getJSCallStackFrames(JSDebugger jSDebugger, List<Stack> list) {
        ArrayList<JSCallStackFrame> arrayList = new ArrayList<JSCallStackFrame>();
        if (list != null) {
            for (Stack stack : list) {
                arrayList.add(DbgpUtils.getJSCallStackFrame(jSDebugger, stack));
            }
        }
        return arrayList;
    }

    public static JSProperty getJSProperty(JSCallStackFrame jSCallStackFrame, Property property) {
        if (property == null) {
            return null;
        }
        try {
            JSValue.TypeOf typeOf = JSValue.TypeOf.valueOf(property.getType().toUpperCase());
            String string = property.getFullName();
            String string2 = property.getName();
            String string3 = property.getStringValue();
            JSValue jSValue = null;
            switch (typeOf) {
                case BOOLEAN: 
                case DOUBLE: 
                case INT: 
                case VOID: 
                case NULL: 
                case STRING: {
                    jSValue = JSFactory.createJSPrimitive(jSCallStackFrame, string, typeOf, string3);
                    break;
                }
                case OBJECT: {
                    jSValue = JSFactory.createJSObject(jSCallStackFrame, string, property.getClassName());
                    break;
                }
                case ARRAY: {
                    jSValue = JSFactory.createJSArray(jSCallStackFrame, string);
                    break;
                }
                case FUNCTION: {
                    jSValue = JSFactory.createJSFunction(jSCallStackFrame, string, string2, string3, property.getClassName());
                }
            }
            if (jSValue != null) {
                if (jSValue instanceof JSObjectImpl) {
                    JSObjectImpl jSObjectImpl = (JSObjectImpl)jSValue;
                    if (property.getChildrenSize() == 0) {
                        jSObjectImpl.setProperties(JSProperty.EMPTY_ARRAY);
                    } else if (property.getChildrenSize() > 0) {
                        LinkedList<JSProperty> linkedList = new LinkedList<JSProperty>();
                        List<Property> list = property.getChildren();
                        if (list.size() > 0) {
                            for (Property property2 : list) {
                                linkedList.add(DbgpUtils.getJSProperty(jSCallStackFrame, property2));
                            }
                            jSObjectImpl.setProperties(linkedList.toArray(JSProperty.EMPTY_ARRAY));
                        }
                    }
                }
                return JSFactory.createJSProperty(property.getName(), jSValue);
            }
        }
        catch (UnsufficientValueException unsufficientValueException) {
            Log.getLogger().log(Level.SEVERE, "Unable to get JSProperty", unsufficientValueException);
        }
        return null;
    }

    public static JSProperty[] getJSProperties(JSCallStackFrame jSCallStackFrame, Property property) {
        if (property == null || property.getChildrenSize() == 0) {
            return JSProperty.EMPTY_ARRAY;
        }
        LinkedList<JSProperty> linkedList = new LinkedList<JSProperty>();
        for (Property property2 : property.getChildren()) {
            linkedList.add(DbgpUtils.getJSProperty(jSCallStackFrame, property2));
        }
        return linkedList.toArray(JSProperty.EMPTY_ARRAY);
    }
}

