/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.PrintWriter;

public interface JavacOption {
    public OptionKind getKind();

    public boolean hasArg();

    public boolean matches(String var1);

    public boolean process(Options var1, String var2, String var3);

    public boolean process(Options var1, String var2);

    public OptionName getName();

    public static class HiddenOption
    extends Option {
        HiddenOption(OptionName name) {
            super(name, null, null);
        }

        HiddenOption(OptionName name, String argsNameKey) {
            super(name, argsNameKey, null);
        }

        void help(PrintWriter out) {
        }

        void xhelp(PrintWriter out) {
        }

        public OptionKind getKind() {
            return OptionKind.HIDDEN;
        }
    }

    public static class XOption
    extends Option {
        XOption(OptionName name, String argsNameKey, String descrKey) {
            super(name, argsNameKey, descrKey);
        }

        XOption(OptionName name, String descrKey) {
            this(name, null, descrKey);
        }

        void help(PrintWriter out) {
        }

        void xhelp(PrintWriter out) {
            super.help(out);
        }

        public OptionKind getKind() {
            return OptionKind.EXTENDED;
        }
    }

    public static class Option
    implements JavacOption {
        OptionName name;
        String argsNameKey;
        String descrKey;
        boolean hasSuffix;

        Option(OptionName name, String argsNameKey, String descrKey) {
            this.name = name;
            this.argsNameKey = argsNameKey;
            this.descrKey = descrKey;
            char lastChar = name.optionName.charAt(name.optionName.length() - 1);
            this.hasSuffix = lastChar == ':' || lastChar == '=';
        }

        Option(OptionName name, String descrKey) {
            this(name, null, descrKey);
        }

        public String toString() {
            return this.name.optionName;
        }

        public boolean hasArg() {
            return this.argsNameKey != null && !this.hasSuffix;
        }

        public boolean matches(String arg) {
            return this.hasSuffix ? arg.startsWith(this.name.optionName) : arg.equals(this.name.optionName);
        }

        void help(PrintWriter out) {
            String s = "  " + this.helpSynopsis();
            out.print(s);
            for (int j = s.length(); j < 29; ++j) {
                out.print(" ");
            }
            Log.printLines(out, Main.getLocalizedString(this.descrKey, new Object[0]));
        }

        String helpSynopsis() {
            return (Object)((Object)this.name) + (this.argsNameKey == null ? "" : (this.hasSuffix ? "" : " ") + Main.getLocalizedString(this.argsNameKey, new Object[0]));
        }

        void xhelp(PrintWriter out) {
        }

        public boolean process(Options options, String option, String arg) {
            if (options != null) {
                options.put(option, arg);
            }
            return false;
        }

        public boolean process(Options options, String option) {
            if (this.hasSuffix) {
                return this.process(options, this.name.optionName, option.substring(this.name.optionName.length()));
            }
            return this.process(options, option, option);
        }

        public OptionKind getKind() {
            return OptionKind.NORMAL;
        }

        public OptionName getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionKind {
        NORMAL,
        EXTENDED,
        HIDDEN;

    }
}

