/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.type;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.jumpto.type.GoToTypeAction;
import org.netbeans.modules.jumpto.type.UiOptions;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GoToPanel
extends JPanel {
    private static Icon WAIT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/jumpto/resources/wait.gif"));
    private static Icon WARN_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/jumpto/resources/warning.png"));
    private static final int BRIGHTER_COLOR_COMPONENT = 10;
    private ContentProvider contentProvider;
    private boolean containsScrollPane;
    private JLabel messageLabel;
    private TypeDescriptor selectedType;
    private String oldText;
    long time = -1L;
    private JCheckBox caseSensitive;
    private JLabel jLabelList;
    private JLabel jLabelLocation;
    private JLabel jLabelText;
    private JLabel jLabelWarning;
    private JTextField jTextFieldLocation;
    private JPanel listPanel;
    private JList matchesList;
    private JScrollPane matchesScrollPane1;
    private JTextField nameField;

    public GoToPanel(ContentProvider contentProvider) throws IOException {
        this.contentProvider = contentProvider;
        this.initComponents();
        this.containsScrollPane = true;
        this.matchesList.setSelectionMode(0);
        this.matchesList.addListSelectionListener(null);
        Color color = new Color(Math.min(this.getBackground().getRed() + 10, 255), Math.min(this.getBackground().getGreen() + 10, 255), Math.min(this.getBackground().getBlue() + 10, 255));
        this.messageLabel = new JLabel();
        this.messageLabel.setBackground(color);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setEnabled(true);
        this.messageLabel.setText(NbBundle.getMessage(GoToPanel.class, (String)"TXT_NoTypesFound"));
        this.messageLabel.setFont(this.matchesList.getFont());
        this.matchesList.setCellRenderer(contentProvider.getListCellRenderer(this.matchesList));
        contentProvider.setListModel(this, null);
        PatternListener patternListener = new PatternListener(this);
        this.nameField.getDocument().addDocumentListener(patternListener);
        this.caseSensitive.setSelected(UiOptions.GoToTypeDialog.getCaseSensitive());
        this.caseSensitive.addItemListener(patternListener);
        this.matchesList.addListSelectionListener(patternListener);
    }

    public void setModel(final ListModel listModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (listModel.getSize() > 0 || GoToPanel.this.getText() == null || GoToPanel.this.getText().trim().length() == 0) {
                    GoToPanel.this.matchesList.setModel(listModel);
                    GoToPanel.this.matchesList.setSelectedIndex(0);
                    GoToPanel.this.setListPanelContent(null, false);
                    if (GoToPanel.this.time != -1L) {
                        GoToTypeAction.LOGGER.fine("Real search time " + (System.currentTimeMillis() - GoToPanel.this.time) + " ms.");
                        GoToPanel.this.time = -1L;
                    }
                } else {
                    GoToPanel.this.setListPanelContent(NbBundle.getMessage(GoToPanel.class, (String)"TXT_NoTypesFound"), false);
                }
            }
        });
    }

    public void setInitialText(final String string) {
        this.oldText = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string2 = GoToPanel.this.nameField.getText();
                if (string2 == null || string2.trim().length() == 0) {
                    GoToPanel.this.nameField.setText(string);
                    GoToPanel.this.nameField.setCaretPosition(string.length());
                    GoToPanel.this.nameField.setSelectionStart(0);
                    GoToPanel.this.nameField.setSelectionEnd(string.length());
                }
            }
        });
    }

    public void setSelectedType() {
        this.selectedType = (TypeDescriptor)this.matchesList.getSelectedValue();
    }

    public TypeDescriptor getSelectedType() {
        return this.selectedType;
    }

    void setWarning(String string) {
        if (string != null) {
            this.jLabelWarning.setIcon(WARN_ICON);
            this.jLabelWarning.setBorder(BorderFactory.createEmptyBorder(3, 1, 1, 1));
        } else {
            this.jLabelWarning.setIcon(null);
            this.jLabelWarning.setBorder(null);
        }
        this.jLabelWarning.setText(string);
    }

    private void initComponents() {
        this.jLabelText = new JLabel();
        this.nameField = new JTextField();
        this.jLabelList = new JLabel();
        this.listPanel = new JPanel();
        this.matchesScrollPane1 = new JScrollPane();
        this.matchesList = new JList();
        this.jLabelWarning = new JLabel();
        this.caseSensitive = new JCheckBox();
        this.jLabelLocation = new JLabel();
        this.jTextFieldLocation = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setFocusable(false);
        this.setNextFocusableComponent(this.nameField);
        this.setLayout(new GridBagLayout());
        this.jLabelText.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabelText, (String)NbBundle.getMessage(GoToPanel.class, (String)"TXT_GoToType_TypeName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelText, gridBagConstraints);
        this.nameField.setFont(new Font("Monospaced", 0, this.getFontSize()));
        this.nameField.setBorder(BorderFactory.createEtchedBorder());
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GoToPanel.this.nameFieldActionPerformed(actionEvent);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                GoToPanel.this.nameFieldKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                GoToPanel.this.nameFieldKeyReleased(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                GoToPanel.this.nameFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.nameField, gridBagConstraints);
        this.jLabelList.setLabelFor(this.matchesScrollPane1);
        this.jLabelList.setText(NbBundle.getMessage(GoToPanel.class, (String)"TXT_GoToType_MatchesList_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelList, gridBagConstraints);
        this.listPanel.setBorder(BorderFactory.createEtchedBorder());
        this.listPanel.setName("dataPanel");
        this.listPanel.setLayout(new BorderLayout());
        this.matchesScrollPane1.setBorder(null);
        this.matchesScrollPane1.setFocusable(false);
        this.matchesList.setFont(new Font("Monospaced", 0, this.getFontSize()));
        this.matchesList.setVisibleRowCount(15);
        this.matchesList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                GoToPanel.this.matchesListMouseReleased(mouseEvent);
            }
        });
        this.matchesScrollPane1.setViewportView(this.matchesList);
        this.matchesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToPanel.class, (String)"ACSD_GoToListName"));
        this.listPanel.add((Component)this.matchesScrollPane1, "Center");
        this.jLabelWarning.setFocusable(false);
        this.listPanel.add((Component)this.jLabelWarning, "Last");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.listPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitive, (String)NbBundle.getMessage(GoToPanel.class, (String)"TXT_GoToType_CaseSensitive"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.caseSensitive, gridBagConstraints);
        this.caseSensitive.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToPanel.class, (String)"GoToPanel.caseSensitive.AccessibleContext.accessibleDescription"));
        this.jLabelLocation.setText(NbBundle.getMessage(GoToPanel.class, (String)"LBL_GoToType_LocationJLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jLabelLocation, gridBagConstraints);
        this.jTextFieldLocation.setEditable(false);
        this.jTextFieldLocation.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jTextFieldLocation, gridBagConstraints);
    }

    private void matchesListMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.nameFieldActionPerformed(null);
        }
    }

    private void nameFieldKeyTyped(KeyEvent keyEvent) {
        if (this.boundScrollingKey(keyEvent)) {
            this.delegateScrollingKey(keyEvent);
        }
    }

    private void nameFieldKeyReleased(KeyEvent keyEvent) {
        if (this.boundScrollingKey(keyEvent)) {
            this.delegateScrollingKey(keyEvent);
        }
    }

    private void nameFieldKeyPressed(KeyEvent keyEvent) {
        if (this.boundScrollingKey(keyEvent)) {
            this.delegateScrollingKey(keyEvent);
        }
    }

    private void nameFieldActionPerformed(ActionEvent actionEvent) {
        if (this.contentProvider.hasValidContent()) {
            this.contentProvider.closeDialog();
            this.setSelectedType();
        }
    }

    private String getText() {
        try {
            String string = this.nameField.getDocument().getText(0, this.nameField.getDocument().getLength());
            return string;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private int getFontSize() {
        return this.jLabelList.getFont().getSize();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    void setListPanelContent(String string, boolean bl) {
        if (string == null && !this.containsScrollPane) {
            this.listPanel.remove(this.messageLabel);
            this.listPanel.add(this.matchesScrollPane1);
            this.containsScrollPane = true;
            this.revalidate();
            this.repaint();
        } else if (string != null) {
            this.jTextFieldLocation.setText("");
            this.messageLabel.setText(string);
            this.messageLabel.setIcon(bl ? WAIT_ICON : null);
            if (this.containsScrollPane) {
                this.listPanel.remove(this.matchesScrollPane1);
                this.listPanel.add(this.messageLabel);
                this.containsScrollPane = false;
            }
            this.revalidate();
            this.repaint();
        }
    }

    private String listActionFor(KeyEvent keyEvent) {
        InputMap inputMap = this.matchesList.getInputMap();
        Object object = inputMap.get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private boolean boundScrollingKey(KeyEvent keyEvent) {
        String string = this.listActionFor(keyEvent);
        return "selectPreviousRow".equals(string) || "selectNextRow".equals(string) || "scrollUp".equals(string) || "scrollDown".equals(string);
    }

    private void delegateScrollingKey(KeyEvent keyEvent) {
        String string = this.listActionFor(keyEvent);
        if ("selectNextRow".equals(string) && this.matchesList.getSelectedIndex() == this.matchesList.getModel().getSize() - 1) {
            this.matchesList.setSelectedIndex(0);
            this.matchesList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(string) && this.matchesList.getSelectedIndex() == 0) {
            int n = this.matchesList.getModel().getSize() - 1;
            this.matchesList.setSelectedIndex(n);
            this.matchesList.ensureIndexIsVisible(n);
            return;
        }
        Action action = this.matchesList.getActionMap().get(string);
        if (action != null) {
            action.actionPerformed(new ActionEvent(this.matchesList, 0, string));
        }
    }

    public static interface ContentProvider {
        public ListCellRenderer getListCellRenderer(JList var1);

        public void setListModel(GoToPanel var1, String var2);

        public void closeDialog();

        public boolean hasValidContent();
    }

    private static class PatternListener
    implements DocumentListener,
    ItemListener,
    ListSelectionListener {
        private final GoToPanel dialog;

        PatternListener(GoToPanel goToPanel) {
            this.dialog = goToPanel;
        }

        PatternListener(DocumentEvent documentEvent, GoToPanel goToPanel) {
            this.dialog = goToPanel;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            UiOptions.GoToTypeDialog.setCaseSensitive(this.dialog.isCaseSensitive());
            this.update();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object e = this.dialog.matchesList.getSelectedValue();
            if (e instanceof TypeDescriptor) {
                TypeDescriptor typeDescriptor = (TypeDescriptor)e;
                if (typeDescriptor != null) {
                    String string = "";
                    FileObject fileObject = typeDescriptor.getFileObject();
                    if (fileObject != null) {
                        string = FileUtil.getFileDisplayName((FileObject)fileObject);
                    }
                    this.dialog.jTextFieldLocation.setText(string);
                } else {
                    this.dialog.jTextFieldLocation.setText("");
                }
            } else {
                this.dialog.jTextFieldLocation.setText("");
            }
        }

        private void update() {
            this.dialog.time = System.currentTimeMillis();
            String string = this.dialog.getText();
            if (this.dialog.oldText == null || this.dialog.oldText.trim().length() == 0 || !string.startsWith(this.dialog.oldText)) {
                this.dialog.setListPanelContent(NbBundle.getMessage(GoToPanel.class, (String)"TXT_Searching"), true);
            }
            this.dialog.oldText = string;
            this.dialog.contentProvider.setListModel(this.dialog, string);
        }
    }
}

