/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.symbol;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.jumpto.file.LazyListModel;
import org.netbeans.modules.jumpto.symbol.GoToPanel;
import org.netbeans.modules.jumpto.symbol.SymbolProviderAccessor;
import org.netbeans.modules.jumpto.type.Models;
import org.netbeans.modules.jumpto.type.UiOptions;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoToSymbolAction
extends AbstractAction
implements GoToPanel.ContentProvider,
LazyListModel.Filter {
    static final Logger LOGGER = Logger.getLogger(GoToSymbolAction.class.getName());
    private SearchType nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToSymbolAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private GoToPanel panel;
    private Dialog dialog;
    private JButton okButton;
    private Collection<? extends SymbolProvider> typeProviders;
    private final String title;
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\.|\\$)*){2,}");
    private Dimension initialDimension;

    public GoToSymbolAction() {
        this(NbBundle.getMessage(GoToSymbolAction.class, (String)"DLG_GoToSymbol"));
    }

    public GoToSymbolAction(String string) {
        super(NbBundle.getMessage(GoToSymbolAction.class, (String)"TXT_GoToSymbol"));
        this.title = string;
    }

    private Collection<? extends SymbolProvider> getTypeProviders() {
        if (this.typeProviders == null) {
            this.typeProviders = Arrays.asList(Lookup.getDefault().lookupAll(SymbolProvider.class).toArray(new SymbolProvider[0]));
        }
        return this.typeProviders;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SymbolDescriptor symbolDescriptor = this.getSelectedSymbol();
        if (symbolDescriptor != null) {
            symbolDescriptor.open();
        }
    }

    public SymbolDescriptor getSelectedSymbol() {
        SymbolDescriptor symbolDescriptor = null;
        try {
            JEditorPane[] jEditorPaneArray;
            EditorCookie editorCookie;
            this.panel = new GoToPanel(this);
            this.dialog = this.createDialog(this.panel);
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            String string = null;
            if (nodeArray.length > 0 && (editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class)) != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && (string = Utilities.getSelectionOrIdentifier((JTextComponent)jEditorPaneArray[0])) != null && org.openide.util.Utilities.isJavaIdentifier((String)string)) {
                this.panel.setInitialText(string);
            }
            this.dialog.setVisible(true);
            symbolDescriptor = this.panel.getSelectedSymbol();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return symbolDescriptor;
    }

    @Override
    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    @Override
    public boolean accept(Object object) {
        return true;
    }

    @Override
    public void scheduleUpdate(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public ListCellRenderer getListCellRenderer(JList jList) {
        return new Renderer(jList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListModel(GoToPanel goToPanel, String string) {
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (string == null) {
            goToPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        boolean bl = goToPanel.isCaseSensitive();
        boolean bl2 = string.endsWith(" ");
        if ((string = string.trim()).length() == 0) {
            goToPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        int n = GoToSymbolAction.containsWildCard(string);
        this.nameKind = bl2 ? (bl ? SearchType.EXACT_NAME : SearchType.CASE_INSENSITIVE_EXACT_NAME) : (GoToSymbolAction.isAllUpper(string) && string.length() > 1 || GoToSymbolAction.isCamelCase(string) ? SearchType.CAMEL_CASE : (n != -1 ? (bl ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP) : (bl ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX)));
        GoToSymbolAction goToSymbolAction = this;
        synchronized (goToSymbolAction) {
            this.running = new Worker(string);
            this.task = rp.post((Runnable)this.running, 220);
            if (goToPanel.time != -1L) {
                LOGGER.fine("Worker posted after " + (System.currentTimeMillis() - goToPanel.time) + " ms.");
            }
        }
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int containsWildCard(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '?' && string.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private static boolean isCamelCase(String string) {
        return camelCasePattern.matcher(string).matches();
    }

    @Override
    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    @Override
    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    private Dialog createDialog(GoToPanel goToPanel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToSymbolAction.class, (String)"CTL_OK"));
        this.okButton.setEnabled(false);
        goToPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToSymbolAction.class, (String)"AN_GoToSymbol"));
        goToPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToSymbolAction.class, (String)"AD_GoToSymbol"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)goToPanel, this.title, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(goToPanel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        int n = UiOptions.GoToSymbolDialog.getWidth();
        int n2 = UiOptions.GoToSymbolDialog.getHeight();
        if (n != -1 && n2 != -1) {
            dialog.setPreferredSize(new Dimension(n, n2));
        }
        Rectangle rectangle = org.openide.util.Utilities.getUsableScreenBounds();
        int n3 = rectangle.width * 9 / 10;
        int n4 = rectangle.height * 9 / 10;
        Dimension dimension = dialog.getPreferredSize();
        dimension.width = Math.min(dimension.width, n3);
        dimension.height = Math.min(dimension.height, n4);
        dialog.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dimension));
        this.initialDimension = dimension;
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                GoToSymbolAction.this.cleanup();
            }
        });
        return dialog;
    }

    private void cleanup() {
        if (this.dialog != null) {
            int n = this.dialog.getWidth();
            int n2 = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != n || this.initialDimension.height != n2)) {
                UiOptions.GoToSymbolDialog.setHeight(n2);
                UiOptions.GoToSymbolDialog.setWidth(n);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            for (SymbolProvider symbolProvider : this.getTypeProviders()) {
                symbolProvider.cleanup();
            }
        }
    }

    private int compareStrings(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.compareTo(string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SymbolComparator
    implements Comparator<SymbolDescriptor> {
        private SymbolComparator() {
        }

        @Override
        public int compare(SymbolDescriptor symbolDescriptor, SymbolDescriptor symbolDescriptor2) {
            int n = GoToSymbolAction.this.compareStrings(symbolDescriptor.getSymbolName(), symbolDescriptor2.getSymbolName());
            if (n != 0) {
                return n;
            }
            return n;
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToPanel panel;

        public DialogButtonListener(GoToPanel goToPanel) {
            this.panel = goToPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GoToSymbolAction.this.okButton) {
                this.panel.setSelectedSymbol();
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        private MyPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlOwner = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private JList jList;

        public Renderer(JList jList) {
            this.jList = jList;
            Container container = jList.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new MyPanel();
            this.rendererComponent.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 7);
            this.rendererComponent.add((Component)this.jlName, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 7);
            this.rendererComponent.add((Component)this.jlOwner, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 13;
            this.rendererComponent.add((Component)this.jlPrj, gridBagConstraints);
            this.jlName.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(jList.getFont());
            this.jlPrj.setFont(jList.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = jList.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = jList.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = jList.getSelectionBackground();
            this.fgSelectionColor = jList.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = jList.getFixedCellHeight();
            int n3 = jList.getFixedCellWidth() - 1;
            n3 = n3 < 200 ? 200 : n3;
            Dimension dimension = new Dimension(n3, n2);
            this.rendererComponent.setMaximumSize(dimension);
            this.rendererComponent.setPreferredSize(dimension);
            if (bl) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlOwner.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlOwner.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(n % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (object instanceof SymbolDescriptor) {
                long l = System.currentTimeMillis();
                SymbolDescriptor symbolDescriptor = (SymbolDescriptor)object;
                this.jlName.setIcon(symbolDescriptor.getIcon());
                this.jlName.setText(symbolDescriptor.getSymbolName());
                this.jlOwner.setText(NbBundle.getMessage(GoToSymbolAction.class, (String)"MSG_DeclaredIn", (Object)symbolDescriptor.getOwnerName()));
                this.jlPrj.setText(symbolDescriptor.getProjectName());
                this.jlPrj.setIcon(symbolDescriptor.getProjectIcon());
                this.rendererComponent.setDescriptor(symbolDescriptor);
                FileObject fileObject = symbolDescriptor.getFileObject();
                if (fileObject != null) {
                    this.rendererComponent.setToolTipText(FileUtil.getFileDisplayName((FileObject)fileObject));
                }
                LOGGER.fine("  Time in paint " + (System.currentTimeMillis() - l) + " ms.");
            } else {
                this.jlName.setText(object.toString());
            }
            return this.rendererComponent;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/jumpto/type/sample.png")));
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jViewport.getExtentSize().width);
        }
    }

    private static class MyPanel
    extends JPanel {
        private SymbolDescriptor td;

        private MyPanel() {
        }

        void setDescriptor(SymbolDescriptor symbolDescriptor) {
            this.td = symbolDescriptor;
            this.putClientProperty("ToolTipText", null);
        }

        public String getToolTipText() {
            String string = (String)this.getClientProperty("ToolTipText");
            if (string == null) {
                FileObject fileObject;
                if (this.td != null && (fileObject = this.td.getFileObject()) != null) {
                    string = FileUtil.getFileDisplayName((FileObject)fileObject);
                }
                this.putClientProperty("ToolTipText", string);
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private volatile SymbolProvider current;
        private final String text;
        private final long createTime;

        public Worker(String string) {
            this.text = string;
            this.createTime = System.currentTimeMillis();
            LOGGER.fine("Worker for " + string + " - created after " + (System.currentTimeMillis() - ((GoToSymbolAction)GoToSymbolAction.this).panel.time) + " ms.");
        }

        @Override
        public void run() {
            LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
            final List<? extends SymbolDescriptor> list = this.getSymbolNames(this.text);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            final ListModel listModel = Models.fromList(list);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            if (!this.isCanceled && listModel != null) {
                LOGGER.fine("Worker for text " + this.text + " finished after " + (System.currentTimeMillis() - this.createTime) + " ms.");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GoToSymbolAction.this.panel.setModel(listModel);
                        if (GoToSymbolAction.this.okButton != null && !list.isEmpty()) {
                            GoToSymbolAction.this.okButton.setEnabled(true);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            SymbolProvider symbolProvider;
            if (((GoToSymbolAction)GoToSymbolAction.this).panel.time != -1L) {
                LOGGER.fine("Worker for text " + this.text + " canceled after " + (System.currentTimeMillis() - this.createTime) + " ms.");
            }
            Worker worker = this;
            synchronized (worker) {
                this.isCanceled = true;
                symbolProvider = this.current;
            }
            if (symbolProvider != null) {
                symbolProvider.cancel();
            }
        }

        private List<? extends SymbolDescriptor> getSymbolNames(String string) {
            ArrayList arrayList = new ArrayList(128);
            String[] stringArray = new String[1];
            SymbolProvider.Context context = SymbolProviderAccessor.DEFAULT.createContext(null, string, GoToSymbolAction.this.nameKind);
            SymbolProvider.Result result = SymbolProviderAccessor.DEFAULT.createResult(arrayList, stringArray);
            Iterator iterator = GoToSymbolAction.this.getTypeProviders().iterator();
            while (iterator.hasNext()) {
                SymbolProvider symbolProvider;
                this.current = symbolProvider = (SymbolProvider)iterator.next();
                if (this.isCanceled) {
                    return null;
                }
                symbolProvider.computeSymbolNames(context, result);
                this.current = null;
            }
            if (!this.isCanceled) {
                Collections.sort(arrayList, new SymbolComparator());
                GoToSymbolAction.this.panel.setWarning(stringArray[0]);
                return arrayList;
            }
            return null;
        }
    }
}

