/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties.common;

import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.properties.PropertiesNodesManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.lookup.InstanceContent;

public final class PropertiesSupport {
    public static final String DO_NOT_OPEN_PROPERTIES_WINDOW_TAG = "DO_NOT_OPEN_PROPERTIES_WINDOW";

    private PropertiesSupport() {
    }

    public static Sheet getSheet(DataEditorView dataEditorView, DesignComponent designComponent) {
        return PropertiesNodesManager.getInstance(dataEditorView).getSheet(designComponent);
    }

    public static void addInstanceContent(DataEditorView dataEditorView, InstanceContent instanceContent) {
        PropertiesNodesManager.getInstance(dataEditorView).add(instanceContent);
    }

    public static synchronized void showCustomPropertyEditor(DesignComponent designComponent, String string) {
        boolean bl = false;
        if (designComponent.getDocument().getTransactionManager().isWriteAccess()) {
            Debug.warning((Object[])new Object[]{"Calling PropertiesSupport.showPropertyEditorForCurrentComponent form write transaction may generate problems"});
        }
        DataEditorView dataEditorView = ActiveViewSupport.getDefault().getActiveView();
        assert (dataEditorView != null);
        Sheet sheet = PropertiesNodesManager.getInstance(dataEditorView).getSheet(designComponent);
        for (Node.PropertySet propertySet : sheet.toArray()) {
            for (Node.Property property : propertySet.getProperties()) {
                Object object;
                if (!string.equals(property.getName())) continue;
                PropertyPanel propertyPanel = new PropertyPanel(property, 2);
                bl = true;
                propertyPanel.setChangeImmediate(false);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyPanel, property.getDisplayName(), true, null);
                Object object2 = property.getValue("helpID");
                if (object2 != null) {
                    assert (object2 instanceof String);
                    object = new HelpCtx((String)object2);
                    dialogDescriptor.setHelpCtx(object);
                }
                property.getPropertyEditor().getCustomEditor();
                object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (object == DialogDescriptor.OK_OPTION) {
                    ((DesignPropertyEditor)property.getPropertyEditor()).customEditorOKButtonPressed();
                    try {
                        property.setValue(property.getPropertyEditor().getValue());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Exceptions.printStackTrace((Throwable)illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Exceptions.printStackTrace((Throwable)illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Exceptions.printStackTrace((Throwable)invocationTargetException);
                    }
                }
                return;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("PropertyEditor for " + string + " not found in the component " + designComponent);
        }
    }
}

