/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.xml.transform.Source;
import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.core.BadgedIconCache;
import org.netbeans.modules.bpel.core.SearchProvider;
import org.netbeans.modules.bpel.core.annotations.impl.AnnotationManagerProvider;
import org.netbeans.modules.bpel.core.helper.impl.BusinessProcessHelperImpl;
import org.netbeans.modules.bpel.core.multiview.BpelMultiViewSupport;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.TransformableSupport;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.xml.sax.InputSource;

public class BPELDataObject
extends MultiDataObject {
    private static final long serialVersionUID = 1L;
    private static final String ICON_BASE = "org/netbeans/modules/bpel/core/resources/bp_file.gif";
    private static final String FILE_DESC = "LBL_FileNode_desc";
    private transient BPELDataEditorSupport myEditorSupport;
    private transient AtomicReference<Lookup> myLookup = new AtomicReference();
    private transient AtomicBoolean isLookupInit = new AtomicBoolean(false);

    public BPELDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.myEditorSupport = new BPELDataEditorSupport(this);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)this.getEditorSupport());
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        cookieSet.add((Node.Cookie)new CheckXMLSupport(inputSource));
        Source source = DataObjectAdapters.source((DataObject)this);
        cookieSet.add((Node.Cookie)new TransformableSupport(source));
        cookieSet.add((Node.Cookie)new AnnotationManagerProvider(this));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BPELDataObject.class);
    }

    public void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    public void removeSaveCookie() {
        Node.Cookie cookie = this.getCookie(SaveCookie.class);
        if (cookie != null) {
            this.getCookieSet().remove(cookie);
        }
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            this.getCookieSet().add((Node.Cookie)this.getSaveCookie());
        } else {
            this.getCookieSet().remove((Node.Cookie)this.getSaveCookie());
        }
    }

    public BPELDataEditorSupport getEditorSupport() {
        return this.myEditorSupport;
    }

    private SaveCookie getSaveCookie() {
        return new SaveCookie(){

            public void save() throws IOException {
                BPELDataObject.this.getEditorSupport().saveDocument();
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object object) {
                return object != null && this.getClass().equals(object.getClass());
            }
        };
    }

    public final Lookup getLookup() {
        if (this.myLookup.get() == null) {
            LinkedList<Lookup> linkedList = new LinkedList<Lookup>();
            linkedList.add(Lookups.fixed((Object[])new Object[]{super.getLookup(), this, this.getEditorSupport(), new SearchProvider((DataObject)this), new BusinessProcessHelperImpl(this), XmlFileEncodingQueryImpl.singleton()}));
            linkedList.add(this.getCookieSet().getLookup());
            InstanceContent.Convertor<Class, Object> convertor = new InstanceContent.Convertor<Class, Object>(){
                private AtomicReference<Controller> valControllerRef = new AtomicReference();

                public Object convert(Class clazz) {
                    if (clazz == BpelModel.class) {
                        return BPELDataObject.this.getEditorSupport().getBpelModel();
                    }
                    if (clazz == Controller.class) {
                        this.valControllerRef.compareAndSet(null, new Controller((Model)BPELDataObject.this.getEditorSupport().getBpelModel()));
                        return this.valControllerRef.get();
                    }
                    return null;
                }

                public Class type(Class clazz) {
                    return clazz;
                }

                public String id(Class clazz) {
                    return clazz.toString();
                }

                public String displayName(Class clazz) {
                    return clazz.getName();
                }
            };
            linkedList.add(Lookups.fixed((Object[])new Class[]{BpelModel.class, Controller.class}, (InstanceContent.Convertor)convertor));
            ProxyLookup proxyLookup = new ProxyLookup(linkedList.toArray(new Lookup[linkedList.size()]));
            this.myLookup.compareAndSet(null, (Lookup)proxyLookup);
            this.isLookupInit.compareAndSet(false, true);
        }
        return this.myLookup.get();
    }

    protected Node createNodeDelegate() {
        return new BPELNode(this, this.getEditorSupport());
    }

    private static class BPELNode
    extends DataNode {
        private BPELDataEditorSupport myEditorSupport;

        public BPELNode(BPELDataObject bPELDataObject, BPELDataEditorSupport bPELDataEditorSupport) {
            super((DataObject)bPELDataObject, Children.LEAF);
            this.myEditorSupport = bPELDataEditorSupport;
            this.getCookieSet().add((Node.Cookie)bPELDataObject);
            this.setIconBaseWithExtension(BPELDataObject.ICON_BASE);
            this.setShortDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)BPELDataObject.FILE_DESC));
        }

        public Action getPreferredAction() {
            return new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (BPELNode.this.myEditorSupport.getOpenedPanes() == null || BPELNode.this.myEditorSupport.getOpenedPanes().length == 0) {
                        BPELNode.this.myEditorSupport.open();
                        BpelMultiViewSupport bpelMultiViewSupport = BpelMultiViewSupport.getInstance();
                        bpelMultiViewSupport.requestViewOpen(BPELNode.this.myEditorSupport);
                    } else {
                        BPELNode.this.myEditorSupport.open();
                    }
                }
            };
        }

        protected boolean isWarning() {
            return false;
        }

        protected boolean isError() {
            return false;
        }

        public Image getIcon(int n) {
            if (!this.isWarning() && !this.isError()) {
                return super.getIcon(n);
            }
            if (this.isError()) {
                return BadgedIconCache.getErrorIcon(super.getIcon(n));
            }
            return BadgedIconCache.getWarningIcon(super.getIcon(n));
        }

        public Image getOpenedIcon(int n) {
            if (!this.isWarning() && !this.isError()) {
                return super.getOpenedIcon(n);
            }
            if (this.isError()) {
                return BadgedIconCache.getErrorIcon(super.getOpenedIcon(n));
            }
            return BadgedIconCache.getWarningIcon(super.getOpenedIcon(n));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(BPELDataObject.class);
        }
    }
}

