/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.VersionsCacheExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class VersionsCache {
    public static final String REVISION_CURRENT = "";
    public static final String REVISION_BASE = "*";
    public static final String REVISION_HEAD = "HEAD";
    private static final String CACHE_DIR = "CVS/RevisionCache/";
    private static VersionsCache instance = new VersionsCache();
    private long purgeTimestamp = Long.MAX_VALUE;

    public static VersionsCache getInstance() {
        return instance;
    }

    private VersionsCache() {
    }

    public synchronized File getRemoteFile(File file, String string, ExecutorGroup executorGroup) throws IOException, IllegalCommandException, CommandException, AuthenticationException, NotVersionedException {
        return this.getRemoteFile(file, string, executorGroup, false);
    }

    public synchronized File getRemoteFile(File file, String string, ExecutorGroup executorGroup, boolean bl) throws IOException, IllegalCommandException, CommandException, AuthenticationException, NotVersionedException {
        String string2 = this.resolveRevision(file, string);
        if (string == REVISION_CURRENT) {
            return file.canRead() ? file : null;
        }
        File file2 = this.getCachedRevision(file, string2);
        if (file2 != null) {
            return file2;
        }
        file2 = this.checkoutRemoteFile(file, string, executorGroup, bl);
        if (file2 == null) {
            return null;
        }
        return this.saveRevision(file, file2, string2);
    }

    private String resolveRevision(File file, String string) throws IOException {
        Entry entry;
        if (string == REVISION_BASE) {
            return this.getBaseRevision(file);
        }
        if (string.equals(REVISION_HEAD) && (entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file)) != null && entry.getTag() != null) {
            return entry.getTag();
        }
        return string;
    }

    public void purgeVolatileRevisions() {
        this.purgeTimestamp = System.currentTimeMillis();
    }

    private File saveRevision(File file, File file2, String string) {
        File file3 = file.getParentFile().isDirectory() ? new File(file.getParentFile(), CACHE_DIR) : file2.getParentFile();
        if (!file3.exists() && !file3.mkdirs()) {
            return file2;
        }
        File file4 = new File(file3, this.cachedName(file, string));
        try {
            FileInputStream fileInputStream = new FileInputStream(file2);
            FileOutputStream fileOutputStream = new FileOutputStream(file4);
            FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
            fileInputStream.close();
            fileOutputStream.close();
            if (file2.equals(file)) {
                FileInformation fileInformation = CvsVersioningSystem.getInstance().getStatusCache().createFileInformation(file);
                if (fileInformation.getStatus() != 8) {
                    file4.delete();
                    return null;
                }
            } else {
                file2.delete();
            }
            return file4;
        }
        catch (IOException iOException) {
            return file2;
        }
    }

    private File getCachedRevision(File file, String string) {
        File file2 = new File(file.getParentFile(), CACHE_DIR + this.cachedName(file, string));
        if (this.isVolatile(string) && file2.lastModified() < this.purgeTimestamp) {
            file2.delete();
        }
        if (file2.canRead()) {
            return file2;
        }
        return null;
    }

    private boolean isVolatile(String string) {
        return string.indexOf(46) == -1;
    }

    private String getBaseRevision(File file) throws IOException {
        Entry entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file);
        if (entry == null) {
            throw new IllegalArgumentException("Cannot get BASE revision, there is no Entry for the file: " + file.getAbsolutePath());
        }
        String string = entry.getRevision();
        if (string != null && string.startsWith("-")) {
            return string.substring(1);
        }
        return string;
    }

    private String cachedName(File file, String string) {
        return file.getName() + "#" + string;
    }

    private String getRepositoryForDirectory(File file, String string) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return this.getRepositoryForDirectory(file.getParentFile(), string) + "/" + file.getName();
        }
        try {
            return CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getAbsolutePath(), string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File checkoutRemoteFile(File file, String string, ExecutorGroup executorGroup, boolean bl) throws IOException {
        FileInformation fileInformation;
        if (string == REVISION_BASE && (fileInformation = CvsVersioningSystem.getInstance().getStatusCache().createFileInformation(file)).getStatus() == 8) {
            return file;
        }
        string = this.resolveRevision(file, string);
        fileInformation = CvsVersioningSystem.createGlobalOptions();
        String string2 = Utils.getCVSRootFor(file.getParentFile());
        CVSRoot cVSRoot = CVSRoot.parse((String)string2);
        String string3 = cVSRoot.getRepository();
        fileInformation.setCVSRoot(string2);
        String string4 = this.getRepositoryForDirectory(file.getParentFile(), string3) + "/" + file.getName();
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        checkoutCommand.setRecursive(false);
        assert (string4.startsWith(string3)) : string4 + " does not start with: " + string3;
        if ((string4 = string4.substring(string3.length())).startsWith("/")) {
            string4 = string4.substring(1);
        }
        checkoutCommand.setModule(string4);
        checkoutCommand.setPipeToOutput(true);
        checkoutCommand.setCheckoutByRevision(string);
        String string5 = NbBundle.getMessage(VersionsCache.class, (String)"MSG_VersionsCache_FetchingProgress", (Object)string, (Object)file.getName());
        checkoutCommand.setDisplayName(string5);
        VersionsCacheExecutor versionsCacheExecutor = new VersionsCacheExecutor(checkoutCommand, (GlobalOptions)fileInformation, bl);
        if (executorGroup != null) {
            executorGroup.progress(string5);
            executorGroup.addExecutor(versionsCacheExecutor);
        }
        versionsCacheExecutor.execute();
        ExecutorSupport.wait(new ExecutorSupport[]{versionsCacheExecutor});
        if (executorGroup == null) {
            versionsCacheExecutor.getGroup().executed();
        }
        if (versionsCacheExecutor.isSuccessful()) {
            return versionsCacheExecutor.getCheckedOutVersion();
        }
        if (versionsCacheExecutor.isCancelled()) {
            return null;
        }
        IOException iOException = new IOException(NbBundle.getMessage(VersionsCache.class, (String)"Bk4001", (Object)string, (Object)file.getName()));
        iOException.initCause(versionsCacheExecutor.getFailure());
        throw iOException;
    }
}

