/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDestinationPanel
extends JPanel {
    public static final String IS_VALID = MessageDestinationPanel.class.getName() + ".IS_VALID";
    private final Map<String, MessageDestination.Type> destinationMap;
    private JLabel destinationNameLabel;
    private JTextField destinationNameText;
    private ButtonGroup destinationTypeGroup;
    private JLabel destinationTypeLabel;
    private JLabel errorLabel;
    private JRadioButton queueTypeRadio;
    private JRadioButton topicTypeRadio;

    private MessageDestinationPanel(Map<String, MessageDestination.Type> map) {
        this.initComponents();
        this.destinationMap = map;
    }

    public static MessageDestinationPanel newInstance(Map<String, MessageDestination.Type> map) {
        MessageDestinationPanel messageDestinationPanel = new MessageDestinationPanel(map);
        messageDestinationPanel.initialize();
        return messageDestinationPanel;
    }

    public String getDestinationName() {
        return this.destinationNameText.getText().trim();
    }

    public MessageDestination.Type getDestinationType() {
        if (this.queueTypeRadio.isSelected()) {
            return MessageDestination.Type.QUEUE;
        }
        return MessageDestination.Type.TOPIC;
    }

    private void initialize() {
        this.registerListeners();
        this.setupErrorLabel();
        this.verifyAndFire();
    }

    private void registerListeners() {
        this.destinationNameText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MessageDestinationPanel.this.verifyAndFire();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MessageDestinationPanel.this.verifyAndFire();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MessageDestinationPanel.this.verifyAndFire();
            }
        });
        this.queueTypeRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageDestinationPanel.this.verifyAndFire();
            }
        });
        this.topicTypeRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageDestinationPanel.this.verifyAndFire();
            }
        });
    }

    private void setupErrorLabel() {
        this.setError(null);
        this.errorLabel.setForeground(this.getErrorColor());
    }

    private void setError(String string) {
        if (string == null) {
            this.errorLabel.setText("");
            return;
        }
        this.errorLabel.setText(NbBundle.getMessage(MessageDestinationPanel.class, (String)string));
    }

    private Color getErrorColor() {
        Color color = UIManager.getColor("nb.errorForeground");
        if (color != null) {
            return color;
        }
        return new Color(255, 0, 0);
    }

    private void verifyAndFire() {
        boolean bl = this.verifyComponents();
        this.firePropertyChange(IS_VALID, !bl, bl);
    }

    private boolean verifyComponents() {
        String string = this.destinationNameText.getText();
        if (string == null || string.trim().length() == 0) {
            this.setError("ERR_NoDestinationName");
            return false;
        }
        MessageDestination.Type type = this.destinationMap.get(string = string.trim());
        if (type != null && type.equals((Object)this.getDestinationType())) {
            this.setError("ERR_DuplicateDestination");
            return false;
        }
        if (this.destinationTypeGroup.getSelection() == null) {
            this.setError("ERR_NoDestinationType");
            return false;
        }
        this.setError(null);
        return true;
    }

    private void initComponents() {
        this.destinationTypeGroup = new ButtonGroup();
        this.destinationNameLabel = new JLabel();
        this.destinationNameText = new JTextField();
        this.destinationTypeLabel = new JLabel();
        this.queueTypeRadio = new JRadioButton();
        this.topicTypeRadio = new JRadioButton();
        this.errorLabel = new JLabel();
        this.destinationNameLabel.setLabelFor(this.destinationNameText);
        Mnemonics.setLocalizedText((JLabel)this.destinationNameLabel, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_DestinationName"));
        this.destinationTypeLabel.setLabelFor(this.queueTypeRadio);
        Mnemonics.setLocalizedText((JLabel)this.destinationTypeLabel, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_DestinationType"));
        this.destinationTypeGroup.add(this.queueTypeRadio);
        this.queueTypeRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.queueTypeRadio, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_Queue"));
        this.queueTypeRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.queueTypeRadio.setMargin(new Insets(0, 0, 0, 0));
        this.destinationTypeGroup.add(this.topicTypeRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.topicTypeRadio, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"LBL_Topic"));
        this.topicTypeRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.topicTypeRadio.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(MessageDestinationPanel.class, (String)"ERR_NoDestinationName"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel, -1, 386, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.destinationTypeLabel).add((Component)this.destinationNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.topicTypeRadio).add((Component)this.queueTypeRadio).add((Component)this.destinationNameText, -1, 277, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.destinationNameLabel).add((Component)this.destinationNameText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.destinationTypeLabel).add((Component)this.queueTypeRadio)).addPreferredGap(0).add((Component)this.topicTypeRadio).addPreferredGap(0).add((Component)this.errorLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.destinationNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"MessageDestinationPanel.destinationNameLabel.AccessibleContext.accessibleDescription"));
        this.queueTypeRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"MessageDestinationPanel.queueTypeRadio.AccessibleContext.accessibleDescription"));
        this.topicTypeRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"MessageDestinationPanel.topicTypeRadio.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MessageDestinationPanel.class, (String)"ACSD_AddMessageDestination"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"ACSD_AddMessageDestination"));
    }
}

