/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnUtils {
    public static final String SVN_ADMIN_DIR;
    public static final String SVN_ENTRIES_DIR;
    private static final Pattern metadataPattern;
    private static final FileFilter svnFileFilter;

    public static Context getCurrentContext(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = TopComponent.getRegistry().getActivatedNodes();
        }
        VCSContext vCSContext = VCSContext.forNodes((Node[])nodeArray);
        return new Context(new ArrayList<File>(vCSContext.computeFiles(svnFileFilter)), new ArrayList<File>(vCSContext.getRootFiles()), new ArrayList<File>(vCSContext.getExclusions()));
    }

    public static Context getCurrentContext(Node[] nodeArray, int n, int n2) {
        Context context = SvnUtils.getCurrentContext(nodeArray);
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if (!(file.isDirectory() ? (fileInformation.getStatus() & n2) == 0 : (fileInformation.getStatus() & n) == 0)) continue;
            return Context.Empty;
        }
        return context;
    }

    public static boolean isVersionedProject(Node node) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return SvnUtils.isVersionedProject(project);
    }

    public static boolean isVersionedProject(Project project) {
        if (project != null) {
            FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                File file = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if ((fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void addProjectFiles(Collection<File> collection, Collection<File> collection2, Collection<File> collection3, Project project) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            if ((fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            collection2.add(file);
            boolean bl = false;
            FileObject[] fileObjectArray = fileObject.getChildren();
            HashSet<File> hashSet = new HashSet<File>(fileObjectArray.length);
            for (int j = 0; j < fileObjectArray.length; ++j) {
                FileObject fileObject2 = fileObjectArray[j];
                if (SvnUtils.isAdministrative(fileObject2.getNameExt())) continue;
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                if (sourceGroup.contains(fileObject2)) {
                    hashSet.add(file2);
                    continue;
                }
                int n = fileStatusCache.getStatus(file2).getStatus();
                if (n == 2) continue;
                collection3.add(file2);
                bl = true;
            }
            if (bl) {
                collection.addAll(hashSet);
                continue;
            }
            collection.add(file);
        }
    }

    public static Context getProjectsContext(Project[] projectArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        for (int i = 0; i < projectArray.length; ++i) {
            SvnUtils.addProjectFiles(arrayList, arrayList2, arrayList3, projectArray[i]);
        }
        return new Context(arrayList, arrayList2, arrayList3);
    }

    public static File[] toFileArray(Collection<FileObject> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        Iterator<FileObject> iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(FileUtil.toFile((FileObject)iterator.next()));
        }
        hashSet.remove(null);
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public static boolean isParentOrEqual(File file, File file2) {
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static boolean isAdministrative(File file) {
        String string = file.getName();
        boolean bl = SvnUtils.isAdministrative(string);
        return bl && !file.exists() || bl && file.exists() && file.isDirectory();
    }

    public static boolean isAdministrative(String string) {
        return string.equals(SVN_ADMIN_DIR);
    }

    public static boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof SubversionVCS && !SvnUtils.isPartOfSubversionMetadata(file);
    }

    public static String previousRevision(String string) {
        return string == null ? null : Long.toString(Long.parseLong(string) - 1L);
    }

    public static String getRelativePath(File file) throws SVNClientException {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        SVNUrl sVNUrl = null;
        boolean bl = false;
        while (SvnUtils.isManaged(file)) {
            SvnClient svnClient;
            ISVNInfo iSVNInfo;
            block8: {
                bl = true;
                iSVNInfo = null;
                try {
                    svnClient = Subversion.getInstance().getClient(false);
                    iSVNInfo = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block8;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNInfo != null && iSVNInfo.getUrl() != null) {
                svnClient = SvnUtils.decode(iSVNInfo.getUrl());
                sVNUrl = iSVNInfo.getRepository();
                if (svnClient != null && sVNUrl != null) {
                    String string2 = svnClient.toString();
                    String string3 = sVNUrl.toString();
                    string = string2.substring(string3.length());
                    Iterator iterator = arrayList.iterator();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        stringBuffer.append("/");
                        stringBuffer.append(string4);
                    }
                    string = string + stringBuffer.toString();
                    break;
                }
            }
            arrayList.add(0, file.getName());
            file = file.getParentFile();
        }
        if (sVNUrl == null && bl) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!bl) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
        }
        return string;
    }

    public static SVNUrl getRepositoryRootUrl(File file) throws SVNClientException {
        SvnClient svnClient;
        try {
            svnClient = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        SVNUrl sVNUrl = null;
        boolean bl = false;
        while (SvnUtils.isManaged(file)) {
            ISVNInfo iSVNInfo;
            block7: {
                bl = true;
                iSVNInfo = null;
                try {
                    iSVNInfo = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block7;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNInfo != null && (sVNUrl = SvnUtils.decode(iSVNInfo.getRepository())) != null) break;
            file = file.getParentFile();
        }
        if (sVNUrl == null && bl) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!bl) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
        }
        return sVNUrl;
    }

    public static SVNUrl getRepositoryUrl(File file) throws SVNClientException {
        StringBuffer stringBuffer = new StringBuffer();
        SVNUrl sVNUrl = null;
        SvnClient svnClient = null;
        try {
            svnClient = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        boolean bl = false;
        while (SvnUtils.isManaged(file)) {
            ISVNStatus iSVNStatus;
            block12: {
                block11: {
                    bl = true;
                    try {
                        iSVNStatus = SvnUtils.getSingleStatus(svnClient, file);
                        if (iSVNStatus != null && (sVNUrl = SvnUtils.decode(iSVNStatus.getUrl())) != null) {
                            break;
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block11;
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                    }
                }
                iSVNStatus = null;
                try {
                    iSVNStatus = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block12;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNStatus != null && (sVNUrl = SvnUtils.decode(iSVNStatus.getUrl())) != null) break;
            stringBuffer.insert(0, file.getName()).insert(0, "/");
            file = file.getParentFile();
        }
        if (sVNUrl == null && bl) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!bl) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
        }
        if (stringBuffer.length() > 0) {
            sVNUrl = sVNUrl.appendPath(stringBuffer.toString());
        }
        return sVNUrl;
    }

    private static ISVNStatus getSingleStatus(SvnClient svnClient, File file) throws SVNClientException {
        return svnClient.getSingleStatus(file);
    }

    private static SVNUrl decode(SVNUrl sVNUrl) {
        if (sVNUrl == null) {
            return null;
        }
        String string = sVNUrl.toString();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '?') {
                bl = true;
                continue;
            }
            if (c == '+' && bl) {
                stringBuffer.append(' ');
                continue;
            }
            if (SvnUtils.isEncodedByte(c, string, i)) {
                ArrayList<Byte> arrayList = new ArrayList<Byte>();
                do {
                    arrayList.add((byte)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                } while ((i += 3) < string.length() && SvnUtils.isEncodedByte(c = string.charAt(i), string, i));
                if (arrayList.size() <= 0) continue;
                byte[] byArray = new byte[arrayList.size()];
                for (int j = 0; j < arrayList.size(); ++j) {
                    byArray[j] = (Byte)arrayList.get(j);
                }
                try {
                    stringBuffer.append(new String(byArray, "UTF8"));
                }
                catch (Exception exception) {
                    Subversion.LOG.log(Level.INFO, null, exception);
                }
                --i;
                continue;
            }
            stringBuffer.append(c);
        }
        try {
            return new SVNUrl(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private static boolean isEncodedByte(char c, String string, int n) {
        return c == '%' && n + 2 < string.length() && SvnUtils.isHexDigit(string.charAt(n + 1)) && SvnUtils.isHexDigit(string.charAt(n + 2));
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String getRepositoryPath(File file) throws SVNClientException {
        SVNUrl sVNUrl = SvnUtils.getRepositoryUrl(file);
        SVNUrl sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
        return SVNUrlUtils.getRelativePath((SVNUrl)sVNUrl2, (SVNUrl)sVNUrl, (boolean)true);
    }

    public static boolean isBinary(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 32 || by == 9 || by == 10 || by == 13) continue;
            return true;
        }
        return false;
    }

    public static File[] flatten(File[] fileArray, int n) {
        LinkedList<File> linkedList = new LinkedList<File>();
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if ((n & fileInformation.getStatus()) != 0) {
                linkedList.add(file);
            }
            File[] fileArray2 = fileStatusCache.listFiles(file);
            for (int j = 0; j < fileArray2.length; ++j) {
                File file2 = fileArray2[j];
                fileInformation = fileStatusCache.getStatus(file2);
                if ((n & fileInformation.getStatus()) == 0) continue;
                linkedList.add(file2);
            }
        }
        return linkedList.toArray(new File[linkedList.size()]);
    }

    public static File[] getModifiedFiles(Context context, int n) {
        File[] fileArray;
        File[] fileArray2 = Subversion.getInstance().getStatusCache().listFiles(context, n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < fileArray2.length; ++i) {
            fileArray = fileArray2[i];
            String string = fileArray.getAbsolutePath();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(string)) continue;
            arrayList.add(fileArray);
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.isFile() || (fileStatusCache.getStatus(file).getStatus() & n) == 0 || arrayList.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static boolean isPartOfSubversionMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static int getComparableStatus(int n) {
        if (0 != (n & 0x40)) {
            return 0;
        }
        if (0 != (n & 0x80)) {
            return 1;
        }
        if (0 != (n & 0x800)) {
            return 10;
        }
        if (0 != (n & 0x100)) {
            return 11;
        }
        if (0 != (n & 4)) {
            return 12;
        }
        if (0 != (n & 0x1000)) {
            return 13;
        }
        if (0 != (n & 0x10)) {
            return 14;
        }
        if (0 != (n & 0x400)) {
            return 30;
        }
        if (0 != (n & 0x200)) {
            return 31;
        }
        if (0 != (n & 0x20)) {
            return 32;
        }
        if (0 != (n & 8)) {
            return 50;
        }
        if (0 != (n & 2)) {
            return 100;
        }
        if (0 != (n & 1)) {
            return 101;
        }
        if (n == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    public static String getCopy(File file) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        return SvnUtils.getCopy(sVNUrl, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    public static String getCopy(SVNUrl sVNUrl) {
        return SvnUtils.getCopy(sVNUrl, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    private static String getCopy(SVNUrl sVNUrl, List<AnnotationExpression> list) {
        if (sVNUrl != null) {
            String string = sVNUrl.toString();
            Iterator<AnnotationExpression> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getCopyName(string);
                if (string2 == null) continue;
                return string2;
            }
        }
        return null;
    }

    public static void refreshParents(File file) {
        if (file == null) {
            return;
        }
        SvnUtils.refreshParents(file.getParentFile());
        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    public static String ripUserFromHost(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static SVNRevision getSVNRevision(String string) {
        try {
            return SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            return new SVNRevision.Number(Long.parseLong(string));
        }
    }

    public static List<String> getMatchinIgnoreParterns(List<String> list, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                String string2 = iterator.next();
                String string3 = SvnUtils.regExpToFilePatterns(string2);
                Pattern pattern = Pattern.compile(string3);
                if (!pattern.matcher(string).matches()) continue;
                arrayList.add(string2);
                if (!bl) continue;
                return arrayList;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Subversion.LOG.log(Level.INFO, null, patternSyntaxException);
            }
        }
        return arrayList;
    }

    private static String regExpToFilePatterns(String string) {
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*");
        string = string.replaceAll("\\?", ".");
        string = string.replaceAll("\\$", "\\\\\\$");
        string = string.replaceAll("\\^", "\\\\^");
        string = string.replaceAll("\\<", "\\\\<");
        string = string.replaceAll("\\>", "\\\\>");
        string = string.replaceAll("\\[", "\\\\[");
        string = string.replaceAll("\\]", "\\\\]");
        string = string.replaceAll("\\{", "\\\\{");
        string = string.replaceAll("\\}", "\\\\}");
        string = string.replaceAll("\\(", "\\\\(");
        string = string.replaceAll("\\)", "\\\\)");
        string = string.replaceAll("\\+", "\\\\+");
        string = string.replaceAll("\\|", "\\\\|");
        return string;
    }

    public static String getMimeType(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        String string = fileObject == null ? "content/unknown" : fileObject.getMIMEType();
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        if ((fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            if (string.startsWith("text")) {
                return string;
            }
            return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
        }
        PropertiesClient propertiesClient = new PropertiesClient(file);
        try {
            byte[] byArray = propertiesClient.getProperties().get("svn:mime-type");
            if (byArray == null) {
                return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
            }
            return new String(byArray);
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static <T> boolean equals(List<T> list, List<T> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null && list2 != null && list2.size() > 0 || list2 == null && list != null && list.size() > 0) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (T t : list) {
            if (list2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static List<File> listRecursively(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file == null) {
            return arrayList;
        }
        arrayList.add(file);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (SvnUtils.isPartOfSubversionMetadata(file2) || SvnUtils.isAdministrative(file2)) continue;
                if (file2.isDirectory()) {
                    arrayList.addAll(SvnUtils.listRecursively(file2));
                    continue;
                }
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public static SvnFileNode[] getNodes(Context context, int n) {
        File[] fileArray = Subversion.getInstance().getStatusCache().listFiles(context, n);
        SvnFileNode[] svnFileNodeArray = new SvnFileNode[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            svnFileNodeArray[i] = new SvnFileNode(fileArray[i]);
        }
        return svnFileNodeArray;
    }

    public static SVNRevision toSvnRevision(String string) {
        Object object = "HEAD".equals(string) ? SVNRevision.HEAD : new SVNRevision.Number(Long.parseLong(string));
        return object;
    }

    public static ISVNLogMessage[] getLogMessages(ISVNClientAdapter iSVNClientAdapter, SVNUrl sVNUrl, String[] stringArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        HashSet<Long> hashSet = new HashSet<Long>();
        ArrayList<ISVNLogMessage> arrayList = new ArrayList<ISVNLogMessage>();
        for (String string : stringArray) {
            ISVNLogMessage[] iSVNLogMessageArray;
            for (ISVNLogMessage iSVNLogMessage : iSVNLogMessageArray = iSVNClientAdapter.getLogMessages(sVNUrl.appendPath(string), null, sVNRevision, sVNRevision2, bl, bl2, 0L)) {
                if (hashSet.contains(iSVNLogMessage.getRevision().getNumber())) continue;
                arrayList.add(iSVNLogMessage);
                hashSet.add(iSVNLogMessage.getRevision().getNumber());
            }
        }
        return arrayList.toArray(new ISVNLogMessage[arrayList.size()]);
    }

    static {
        String string;
        SVN_ADMIN_DIR = Utilities.isWindows() ? ((string = System.getenv("SVN_ASP_DOT_NET_HACK")) != null ? "_svn" : ".svn") : ".svn";
        SVN_ENTRIES_DIR = SVN_ADMIN_DIR + "/entries";
        metadataPattern = Pattern.compile(".*\\" + File.separatorChar + SVN_ADMIN_DIR + "(\\" + File.separatorChar + ".*|$)");
        svnFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (SvnUtils.isAdministrative(file)) {
                    return false;
                }
                return SharabilityQuery.getSharability((File)file) != 2;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation fileInformation, FileInformation fileInformation2) {
            return SvnUtils.getComparableStatus(fileInformation.getStatus()) - SvnUtils.getComparableStatus(fileInformation2.getStatus());
        }
    }
}

