/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsExecutor;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResolveConflictsAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "ResolveConflicts";
    }

    protected boolean enable(Node[] nodeArray) {
        Context context = SvnUtils.getCurrentContext(nodeArray);
        return SvnUtils.getModifiedFiles(context, 64).length > 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = fileStatusCache.listFiles(context, 64);
        ResolveConflictsAction.resolveConflicts(fileArray);
    }

    static void resolveConflicts(File[] fileArray) {
        if (fileArray.length == 0) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflictsFound"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                ResolveConflictsExecutor resolveConflictsExecutor = new ResolveConflictsExecutor(file);
                resolveConflictsExecutor.exec();
            }
        }
    }

    public boolean asynchronous() {
        return false;
    }
}

