/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.ignore;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreAction
extends ContextAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    @Override
    protected String getBaseName(Node[] nodeArray) {
        int n = this.getActionStatus(nodeArray);
        switch (n) {
            case 0: 
            case 1: {
                return "CTL_MenuItem_Ignore";
            }
            case 2: {
                return "CTL_MenuItem_Unignore";
            }
        }
        throw new RuntimeException("Invalid action status: " + n);
    }

    @Override
    protected int getFileEnabledStatus() {
        return 6;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 6;
    }

    public int getActionStatus(Node[] nodeArray) {
        return this.getActionStatus(SvnUtils.getCurrentContext(nodeArray).getFiles());
    }

    public int getActionStatus(File[] fileArray) {
        int n = -1;
        if (fileArray.length == 0) {
            return 0;
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().equals(SvnUtils.SVN_ADMIN_DIR)) {
                n = 0;
                break;
            }
            FileInformation fileInformation = fileStatusCache.getStatus(fileArray[i]);
            if (fileInformation.getStatus() == 4) {
                if (n == 2) {
                    n = 0;
                    break;
                }
                n = 1;
                continue;
            }
            if (fileInformation.getStatus() == 2) {
                if (n == 1) {
                    n = 0;
                    break;
                }
                n = 2;
                continue;
            }
            n = 0;
            break;
        }
        return n == -1 ? 0 : n;
    }

    @Override
    protected boolean enable(Node[] nodeArray) {
        return this.getActionStatus(nodeArray) != 0;
    }

    @Override
    public void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        final int n = this.getActionStatus(nodeArray);
        if (n != 1 && n != 2) {
            throw new RuntimeException("Invalid action status: " + n);
        }
        final File[] fileArray = SvnUtils.getCurrentContext(nodeArray).getRootFiles();
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                SvnClient svnClient;
                Map map = IgnoreAction.this.splitByParent(fileArray);
                try {
                    svnClient = Subversion.getInstance().getClient(false);
                }
                catch (SVNClientException sVNClientException) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                    return;
                }
                for (File file : map.keySet()) {
                    Set set = (Set)map.get(file);
                    if (this.isCanceled()) {
                        return;
                    }
                    try {
                        HashSet sVNClientException = new HashSet(svnClient.getIgnoredPatterns(file));
                        if (n == 1) {
                            IgnoreAction.ensureVersioned(file);
                            sVNClientException.addAll(set);
                        } else if (n == 2) {
                            sVNClientException.removeAll(set);
                        }
                        svnClient.setIgnoredPatterns(file, new ArrayList(sVNClientException));
                    }
                    catch (SVNClientException sVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                    }
                }
                for (File file : fileArray) {
                    Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
                for (File file : map.keySet()) {
                    Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }

    private Map<File, Set<String>> splitByParent(File[] fileArray) {
        HashMap<File, Set<String>> hashMap = new HashMap<File, Set<String>>(2);
        for (File file : fileArray) {
            File file2 = file.getParentFile();
            if (file2 == null) continue;
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(file2);
            if (hashSet == null) {
                hashSet = new HashSet<String>(5);
                hashMap.put(file2, hashSet);
            }
            hashSet.add(file.getName());
        }
        return hashMap;
    }

    private static void ensureVersioned(File file) throws SVNClientException {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        if ((fileStatusCache.getStatus(file).getStatus() & 0x1DF8) != 0) {
            return;
        }
        IgnoreAction.ensureVersioned(file.getParentFile());
        IgnoreAction.add(file);
        fileStatusCache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    private static void add(File file) throws SVNClientException {
        SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        SvnClient svnClient = Subversion.getInstance().getClient(sVNUrl);
        svnClient.addFile(file);
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ignore(File file) throws SVNClientException {
        File file2 = file.getParentFile();
        IgnoreAction.ensureVersioned(file2);
        Class<IgnoreAction> clazz = IgnoreAction.class;
        synchronized (IgnoreAction.class) {
            List list = Subversion.getInstance().getClient(true).getIgnoredPatterns(file2);
            if (!list.contains(file.getName())) {
                list.add(file.getName());
                Subversion.getInstance().getClient(true).setIgnoredPatterns(file2, list);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

