/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ListCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private byte[] output;
    private final SVNUrl url;
    private final SVNRevision revision;
    private final boolean recursive;

    public ListCommand(SVNUrl sVNUrl, SVNRevision sVNRevision, boolean bl) {
        this.url = sVNUrl;
        this.revision = sVNRevision;
        this.recursive = bl;
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected boolean hasBinaryOutput() {
        return true;
    }

    protected boolean notifyOutput() {
        return false;
    }

    protected int getCommand() {
        return 11;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("list");
        if (this.recursive) {
            arguments.add("-R");
        }
        arguments.add("--xml");
        arguments.add(this.revision);
        arguments.add(this.url);
    }

    public void output(byte[] byArray) {
        this.output = byArray;
    }

    public ISVNDirEntry[] getEntries() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new ISVNDirEntry[0];
        }
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            xMLReader.setContentHandler(xmlEntriesHandler);
            xMLReader.setErrorHandler(xmlEntriesHandler);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(this.output));
            xMLReader.parse(inputSource);
            return xmlEntriesHandler.getEntryAttributes();
        }
        catch (SAXException sAXException) {
            throw new SVNClientException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new SVNClientException((Throwable)iOException);
        }
    }

    private class DirEntry
    implements ISVNDirEntry {
        private String path;
        private Date lastChangedDate;
        private SVNRevision.Number lastChangedRevision;
        private boolean hasProps;
        private String lastCommitAuthor;
        private SVNNodeKind kind;
        private long size;

        public DirEntry(String string, Date date, SVNRevision.Number number, boolean bl, String string2, SVNNodeKind sVNNodeKind, long l) {
            this.path = string;
            this.lastChangedDate = date;
            this.lastChangedRevision = number;
            this.hasProps = bl;
            this.lastCommitAuthor = string2;
            this.kind = sVNNodeKind;
            this.size = l;
        }

        public String getPath() {
            return this.path;
        }

        public Date getLastChangedDate() {
            return this.lastChangedDate;
        }

        public SVNRevision.Number getLastChangedRevision() {
            return this.lastChangedRevision;
        }

        public boolean getHasProps() {
            return this.hasProps;
        }

        public String getLastCommitAuthor() {
            return this.lastCommitAuthor;
        }

        public SVNNodeKind getNodeKind() {
            return this.kind;
        }

        public long getSize() {
            return this.size;
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String LIST_ELEMENT_NAME = "list";
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String NAME_ELEMENT_NAME = "name";
        private static final String SIZE_ELEMENT_NAME = "size";
        private static final String COMMIT_ELEMENT_NAME = "commit";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String KIND_ATTRIBUTE = "kind";
        private static final String PATH_ATTRIBUTE = "path";
        private static final String REVISION_ATTRIBUTE = "revision";
        private String REVISION_ATTR = "revision_attr";
        private String KIND_ATTR = "kind_attr";
        private String PATH_ATTR = "path_attr";
        private List<ISVNDirEntry> entries = new ArrayList<ISVNDirEntry>();
        private Map<String, String> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.tag = string3.trim();
            if (ENTRY_ELEMENT_NAME.equals(string3)) {
                this.values = new HashMap<String, String>();
                this.values.put(this.KIND_ATTR, attributes.getValue(KIND_ATTRIBUTE));
            } else if (COMMIT_ELEMENT_NAME.equals(string3)) {
                this.values.put(this.REVISION_ATTR, attributes.getValue(REVISION_ATTRIBUTE));
            }
            if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String string = this.toString(n2, cArray, n);
            this.values.put(this.tag, string);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(string3)) {
                if (this.values != null) {
                    String string4 = this.values.get(NAME_ELEMENT_NAME);
                    if (string4 == null) {
                        throw new SAXException("'name' tag expected under 'entry'");
                    }
                    String string5 = this.values.get(COMMIT_ELEMENT_NAME);
                    if (string5 == null) {
                        throw new SAXException("'commit' tag expected under 'entry'");
                    }
                    String string6 = this.values.get(AUTHOR_ELEMENT_NAME);
                    Date date = null;
                    String string7 = this.values.get(DATE_ELEMENT_NAME);
                    if (string7 != null) {
                        try {
                            date = dateFormat.parse(string7);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    SVNRevision.Number number = null;
                    String string8 = this.values.get(this.REVISION_ATTR);
                    if (string8 != null && !string8.trim().equals("")) {
                        try {
                            number = new SVNRevision.Number(Long.parseLong(string8));
                        }
                        catch (NumberFormatException numberFormatException) {
                            number = new SVNRevision.Number(-1L);
                        }
                    }
                    long l = 0L;
                    String string9 = this.values.get(this.KIND_ATTR);
                    SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
                    if ("file".equals(string9)) {
                        sVNNodeKind = SVNNodeKind.FILE;
                        String string10 = this.values.get(SIZE_ELEMENT_NAME);
                        if (string10 == null) {
                            throw new SAXException("'size' tag expected under 'entry'");
                        }
                        try {
                            l = Long.parseLong(string10);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if ("dir".equals(string9)) {
                        sVNNodeKind = SVNNodeKind.DIR;
                    }
                    this.entries.add(new DirEntry(string4, date, number, false, string6, sVNNodeKind, l));
                }
                this.values = null;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public ISVNDirEntry[] getEntryAttributes() {
            return this.entries != null ? this.entries.toArray(new ISVNDirEntry[this.entries.size()]) : new ISVNDirEntry[]{};
        }

        private String toString(int n, char[] cArray, int n2) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, n2, cArray2, 0, n);
            return new String(cArray2);
        }
    }
}

