/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

final class IndentationModel {
    private static final Logger LOG = Logger.getLogger(IndentationModel.class.getName());
    private boolean originalExpandedTabs;
    private int originalSpacesPerTab = 0;
    private int originalTabSize = 0;
    private int originalRightMargin = 0;
    private boolean changed = false;
    private final Preferences preferences;

    IndentationModel(Preferences preferences) {
        this.preferences = preferences;
        this.originalExpandedTabs = this.isExpandTabs();
        this.originalSpacesPerTab = this.getSpacesPerTab();
        this.originalTabSize = this.getTabSize();
        this.originalRightMargin = this.getRightMargin();
    }

    boolean isExpandTabs() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Reading expand-tabs=" + this.preferences.get("expand-tabs", null));
        }
        return this.preferences.getBoolean("expand-tabs", false);
    }

    void setExpandTabs(boolean bl) {
        this.preferences.putBoolean("expand-tabs", bl);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Writing expand-tabs=" + bl);
        }
        this.updateChanged();
    }

    int getSpacesPerTab() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Reading spaces-per-tab=" + this.preferences.get("spaces-per-tab", null));
        }
        return this.preferences.getInt("spaces-per-tab", 4);
    }

    void setSpacesPerTab(int n) {
        assert (n > 0) : "Invalid 'spaces per tab': " + n;
        this.preferences.putInt("spaces-per-tab", n);
        this.preferences.putInt("indent-shift-width", n);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Writing spaces-per-tab=" + n + " and " + "indent-shift-width" + "=" + n);
        }
        this.updateChanged();
    }

    int getTabSize() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Readingtab-size=" + this.preferences.get("tab-size", null));
        }
        return this.preferences.getInt("tab-size", 4);
    }

    void setTabSize(int n) {
        assert (n > 0) : "Invalid 'tab size': " + n;
        this.preferences.putInt("tab-size", n);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Writing tab-size=" + n);
        }
        this.updateChanged();
    }

    Integer getRightMargin() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Reading text-limit-width=" + this.preferences.get("text-limit-width", null));
        }
        return this.preferences.getInt("text-limit-width", 80);
    }

    void setRightMargin(int n) {
        assert (n > 0) : "Invalid 'text limit width': " + n;
        this.preferences.putInt("text-limit-width", n);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Writing text-limit-width=" + n);
        }
        this.updateChanged();
    }

    boolean isChanged() {
        return this.changed;
    }

    void applyChanges() {
        if (!this.changed) {
            return;
        }
        this.applyParameterToAll("expand-tabs", this.isExpandTabs(), "setExpandTabs", Boolean.TYPE);
        this.applyParameterToAll("spaces-per-tab", this.getSpacesPerTab(), "setSpacesPerTab", Integer.TYPE);
        this.applyParameterToAll("indent-shift-width", this.getSpacesPerTab(), null, Integer.TYPE);
        this.applyParameterToAll("tab-size", this.getTabSize(), "setTabSize", Integer.TYPE);
        this.applyParameterToAll("text-limit-width", this.getRightMargin(), "setTextLimitWidth", Integer.TYPE);
    }

    void revertChanges() {
        if (!this.changed) {
            return;
        }
        if (this.isExpandTabs() != this.originalExpandedTabs) {
            this.setExpandTabs(this.originalExpandedTabs);
        }
        if (this.getSpacesPerTab() != this.originalSpacesPerTab && this.originalSpacesPerTab > 0) {
            this.setSpacesPerTab(this.originalSpacesPerTab);
        }
        if (this.getTabSize() != this.originalTabSize && this.originalTabSize > 0) {
            this.setTabSize(this.originalTabSize);
        }
        if (this.getRightMargin() != this.originalRightMargin && this.originalRightMargin > 0) {
            this.setRightMargin(this.originalRightMargin);
        }
    }

    private void updateChanged() {
        this.changed = this.isExpandTabs() != this.originalExpandedTabs || this.getSpacesPerTab() != this.originalSpacesPerTab || this.getTabSize() != this.originalTabSize || this.getRightMargin() != this.originalRightMargin;
    }

    private void applyParameterToAll(String string, Object object, String string2, Class clazz) {
        Object exception;
        Preferences preferences;
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<String> hashSet2 = new HashSet<String>(EditorSettings.getDefault().getMimeTypes());
        hashSet2.add("");
        for (String object3 : hashSet2) {
            preferences = (Preferences)MimeLookup.getLookup((String)object3).lookup(Preferences.class);
            if (preferences == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("!!! no Preferences for '" + object3 + "'");
                continue;
            }
            if (object instanceof Boolean) {
                preferences.putBoolean(string, (Boolean)object);
            } else if (object instanceof Integer) {
                preferences.putInt(string, (Integer)object);
            } else assert (false) : "Unexpected setting value: settingName='" + string + "', settingValue=" + object;
            if (object3.length() <= 0 || string2 == null || (exception = this.hacksForBaseOptionsAndIndentEngine(object3, string2, object, clazz)) == null) continue;
            hashSet.add(exception);
        }
        if (string2 != null) {
            Collection collection = Lookup.getDefault().lookupAll(IndentEngine.class);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                preferences = (IndentEngine)iterator.next();
                if (hashSet.contains(preferences)) continue;
                try {
                    exception = preferences.getClass().getMethod(string2, clazz);
                    ((Method)exception).invoke((Object)preferences, object);
                }
                catch (Exception exception2) {}
            }
        }
    }

    private IndentEngine hacksForBaseOptionsAndIndentEngine(String string, String string2, Object object, Class clazz) {
        Method method;
        GenericDeclaration genericDeclaration;
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Class<?> clazz2 = null;
        try {
            clazz2 = classLoader.loadClass("org.netbeans.modules.editor.options.BaseOptions");
        }
        catch (Exception exception) {
            return null;
        }
        Object object2 = MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(clazz2);
        if (object2 == null) {
            return null;
        }
        Object object3 = null;
        try {
            genericDeclaration = clazz2.getMethod("getIndentEngine", new Class[0]);
            object3 = (IndentEngine)((Method)genericDeclaration).invoke(object2, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object3 == null) {
            return null;
        }
        if (object2.getClass().getName().equals("org.netbeans.modules.java.editor.options.JavaOptions") && !object3.getClass().getName().equals("org.netbeans.modules.editor.java.JavaIndentEngine")) {
            try {
                genericDeclaration = classLoader.loadClass("org.netbeans.modules.editor.java.JavaIndentEngine");
                object3 = (IndentEngine)Lookup.getDefault().lookup((Class)genericDeclaration);
                method = clazz2.getMethod("setIndentEngine", IndentEngine.class);
                method.invoke(object2, object3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object2.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JSPOptions") && !object3.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JspIndentEngine")) {
            try {
                genericDeclaration = classLoader.loadClass("org.netbeans.modules.web.core.syntax.JspIndentEngine");
                object3 = (IndentEngine)Lookup.getDefault().lookup((Class)genericDeclaration);
                method = clazz2.getMethod("setIndentEngine", IndentEngine.class);
                method.invoke(object2, object3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            genericDeclaration = object2.getClass().getMethod(string2, clazz);
            ((Method)genericDeclaration).invoke(object2, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            genericDeclaration = object3.getClass().getMethod(string2, clazz);
            ((Method)genericDeclaration).invoke(object3, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object3;
    }
}

