/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeParser
extends DefaultHandler {
    private static Logger LOGGER = Logger.getLogger("glassfish");
    private final Node root;
    private Node rover;
    private String skipping;
    private int depth;
    private NodeReader childNodeReader;

    public static boolean readXml(File file, List<Path> list) throws IllegalStateException {
        boolean bl = false;
        InputStream inputStream = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            TreeParser treeParser = new TreeParser(list);
            inputStream = new BufferedInputStream(new FileInputStream(file));
            sAXParser.parse(new InputSource(inputStream), (DefaultHandler)treeParser);
            bl = true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                }
            }
        }
        return bl;
    }

    private TreeParser(List<Path> list) {
        this.root = TreeParser.buildTree(list);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.childNodeReader != null) {
            this.childNodeReader.readCData(this.skipping, cArray, n, n2);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.skipping != null) {
            ++this.depth;
            if (this.childNodeReader != null) {
                LOGGER.log(Level.FINER, "Skip: reading " + string3);
                this.childNodeReader.readChildren(string3, attributes);
            }
            LOGGER.log(Level.FINEST, "Skip: descend, depth is " + this.depth + ", qn is " + string3);
        } else {
            Node node = this.rover.findChild(string3);
            if (node != null) {
                this.rover = node;
                LOGGER.log(Level.FINER, "Rover descend to " + this.rover);
                NodeReader nodeReader = this.rover.getReader();
                if (nodeReader != null) {
                    LOGGER.log(Level.FINER, "Rover enter & read node " + string3);
                    nodeReader.readAttributes(string3, attributes);
                }
            } else {
                this.skipping = string3;
                this.depth = 1;
                this.childNodeReader = this.rover.getReader();
                if (this.childNodeReader != null) {
                    LOGGER.log(Level.FINER, "Skip: reading " + string3);
                    this.childNodeReader.readChildren(string3, attributes);
                }
                LOGGER.log(Level.FINEST, "Skip: start, depth is " + this.depth + ", qn is " + string3);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.skipping != null) {
            if (--this.depth == 0) {
                if (!this.skipping.equals(string3)) {
                    LOGGER.log(Level.WARNING, "Skip: " + this.skipping + " does not match " + string3 + " at depth " + this.depth);
                }
                LOGGER.log(Level.FINEST, "Skip: ascend, depth is " + this.depth);
                this.skipping = null;
                this.childNodeReader = null;
            } else {
                LOGGER.log(Level.FINEST, "Skip: ascend, depth is " + this.depth);
            }
        } else {
            NodeReader nodeReader = this.rover.getReader();
            if (nodeReader != null) {
                LOGGER.log(Level.FINER, "Rover exit & read node " + string3);
                nodeReader.endNode(string3);
            }
            this.rover = this.rover.getParent();
            LOGGER.log(Level.FINER, "Rover ascend to " + this.rover);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.rover = this.root;
        this.skipping = null;
        this.depth = 0;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private static Node buildTree(List<Path> list) {
        Node node = null;
        for (Path path : list) {
            String[] stringArray = path.getPath().split("/");
            if (stringArray == null || stringArray.length == 0) {
                LOGGER.log(Level.WARNING, "Invalid entry, no parts, skipping: " + path);
                continue;
            }
            if (stringArray[0] == null) {
                LOGGER.log(Level.WARNING, "Invalid entry, null root, skipping: " + path);
                continue;
            }
            if (node == null) {
                LOGGER.log(Level.FINER, "Root node created: " + stringArray[0]);
                node = new Node(stringArray[0]);
            }
            Node node2 = node;
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i] != null && stringArray[i].length() > 0) {
                    Node node3 = node2.findChild(stringArray[i]);
                    if (node3 != null) {
                        LOGGER.log(Level.FINER, "Existing node " + stringArray[i] + " at level " + i);
                        node2 = node3;
                        continue;
                    }
                    LOGGER.log(Level.FINER, "Adding node " + stringArray[i] + " at level " + i);
                    node2 = node2.addChild(stringArray[i]);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Broken parts found in " + path + " at level " + i);
            }
            if (node2 == null) continue;
            node2.setReader(path.getReader());
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node
    implements Comparable<Node> {
        private final String element;
        private final Map<String, Node> children;
        private Node parent;
        private NodeReader reader;

        public Node(String string) {
            this(string, null);
        }

        private Node(String string, Node node) {
            this.element = string;
            this.children = new HashMap<String, Node>();
            this.parent = node;
        }

        public Node addChild(String string) {
            Node node = new Node(string, this);
            this.children.put(string, node);
            return node;
        }

        public Node findChild(String string) {
            return this.children.get(string);
        }

        public Node getParent() {
            return this.parent;
        }

        public NodeReader getReader() {
            return this.reader;
        }

        public void setReader(NodeReader nodeReader) {
            this.reader = nodeReader;
        }

        @Override
        public int compareTo(Node node) {
            return this.element.compareTo(node.element);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Node node = (Node)object;
            return this.element == node.element || this.element != null && this.element.equals(node.element);
        }

        public int hashCode() {
            int n = 3;
            n = 41 * n + (this.element != null ? this.element.hashCode() : 0);
            return n;
        }

        public String toString() {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer(500);
            stringBuffer.append("{ ");
            if (this.element != null && this.element.length() > 0) {
                stringBuffer.append(this.element);
                bl = true;
            }
            if (this.parent == null) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("root");
                bl = true;
            }
            if (this.children.size() > 0) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.children.size());
                stringBuffer.append(" sub(s)");
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class Path {
        private final String path;
        private final NodeReader reader;

        public Path(String string) {
            this(string, null);
        }

        public Path(String string, NodeReader nodeReader) {
            this.path = string;
            this.reader = nodeReader;
        }

        public String getPath() {
            return this.path;
        }

        public NodeReader getReader() {
            return this.reader;
        }

        public String toString() {
            return this.path;
        }
    }

    public static abstract class NodeReader {
        public void readAttributes(String string, Attributes attributes) throws SAXException {
        }

        public void readChildren(String string, Attributes attributes) throws SAXException {
        }

        public void readCData(String string, char[] cArray, int n, int n2) throws SAXException {
        }

        public void endNode(String string) throws SAXException {
        }
    }
}

