/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerUtilities {
    public static final int ACTION_TIMEOUT = 10000;
    public static final TimeUnit ACTION_TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    public static final String GFV3_MODULES_DIR_NAME = "modules";
    public static final String GFV3_PREFIX_JAR_NAME = "glassfish-10.0";
    public static final String PROP_FIRST_RUN = "first_run";

    private ServerUtilities() {
    }

    public static ServerInstance getServerInstance(String string) {
        return GlassfishInstanceProvider.getDefault().getInstance(string);
    }

    public static Lookup getLookupFor(ServerInstance serverInstance) {
        return GlassfishInstanceProvider.getDefault().getLookupFor(serverInstance);
    }

    public static <T> T getInstanceByCapability(String string, Class<T> clazz) {
        return GlassfishInstanceProvider.getDefault().getInstanceByCapability(string, clazz);
    }

    public static <T> List<T> getInstancesByCapability(Class<T> clazz) {
        return GlassfishInstanceProvider.getDefault().getInstancesByCapability(clazz);
    }

    public static ServerInstanceImplementation getInternalServerInstance(String string) {
        return GlassfishInstanceProvider.getDefault().getInternalInstance(string);
    }

    public static WizardDescriptor.InstantiatingIterator getAddInstanceIterator() {
        return new ServerWizardIterator();
    }

    public static ServerInstanceProvider getServerProvider() {
        return GlassfishInstanceProvider.getDefault();
    }

    public static File getJarName(String string, String string2) {
        File[] fileArray;
        File file = new File(string + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            fileArray = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            file = new File(file, (String)fileArray);
        }
        if ((fileArray = file.listFiles(new VersionFilter(string2))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    public static final String quote(String string) {
        return string.indexOf(32) == -1 ? string : "\"" + string + "\"";
    }

    public static boolean isTP2(String string) {
        return ServerUtilities.getJarName(string, GFV3_PREFIX_JAR_NAME).getName().indexOf("-tp-2-") > -1;
    }

    private static class VersionFilter
    implements FileFilter {
        private String nameprefix;

        public VersionFilter(String string) {
            this.nameprefix = string;
        }

        public boolean accept(File file) {
            return file.getName().startsWith(this.nameprefix);
        }
    }
}

