/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.glassfish.common.wizards.Util;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Retriever
implements Runnable {
    public static final int LOCATION_DOWNLOAD_TIMEOUT = 20000;
    public static final int LOCATION_TRIES = 3;
    public static final int ZIP_DOWNLOAD_TIMEOUT = 120000;
    public static final int STATUS_START = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_DOWNLOADING = 2;
    public static final int STATUS_COMPLETE = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_TERMINATED = 5;
    public static final int STATUS_BAD_DOWNLOAD = 6;
    private static final String[] STATUS_MESSAGE = new String[]{"Ready.", "Connecting...", "Downloading...", "", "{0}: {1}", "", "Response from this URL is not a valid WSDL file."};
    private Updater updater;
    private final String locationUrl;
    private final String targetUrlPrefix;
    private final String defaultTargetUrl;
    private File targetInstallDir;
    private volatile boolean shutdown;
    private volatile int status;
    private static final int READ_BUF_SIZE = 131072;
    private static final int WRITE_BUF_SIZE = 131072;
    private static final String TOP_LEVEL_PREFIX = "glassfishv3";

    public Retriever(File file, String string, String string2, String string3, Updater updater) {
        this.targetInstallDir = file;
        this.locationUrl = string;
        this.targetUrlPrefix = string2;
        this.defaultTargetUrl = string3;
        this.updater = updater;
    }

    public void stopRetrieval() {
        this.shutdown = true;
    }

    public int getDownloadState() {
        return this.status;
    }

    private void setDownloadState(int n) {
        this.status = n;
        this.updateMessage(STATUS_MESSAGE[n]);
    }

    private void setDownloadState(int n, String string, Exception exception) {
        this.status = n;
        Object[] objectArray = new Object[]{string, exception.getMessage()};
        this.updateStatus(MessageFormat.format(STATUS_MESSAGE[n], objectArray));
    }

    private void updateMessage(String string, int n) {
        String string2 = this.countAsString(n);
        this.updateMessage(string + string2);
    }

    private void updateMessage(String string) {
        this.updater.updateMessageText(string);
    }

    private void updateStatus(String string) {
        this.updater.updateStatusText(string);
    }

    private String countAsString(int n) {
        String string = "";
        if (n < 1024) {
            string = n + " bytes";
        } else if (n < 1048676) {
            string = n / 1024 + "k";
        } else {
            int n2 = n / 1048676;
            int n3 = (n - n2 * 1048676) * 10 / 1048676;
            string = n2 + "." + n3 + "m";
        }
        return " (" + string + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setName("V3Downloader");
        this.shutdown = false;
        this.status = 0;
        URL uRL = null;
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        File file = null;
        long l = System.currentTimeMillis();
        try {
            file = this.backupInstallDir(this.targetInstallDir);
            this.setDownloadState(1);
            uRL = new URL(this.getDownloadLocation());
            Logger.getLogger("glassfish").fine("Downloading V3 from " + uRL);
            uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(120000);
            uRLConnection.setReadTimeout(120000);
            inputStream = uRLConnection.getInputStream();
            this.setDownloadState(2);
            this.downloadAndInstall(inputStream, this.targetInstallDir);
            if (!this.shutdown) {
                long l2 = System.currentTimeMillis();
                String string = this.getDurationString((int)(l2 - l));
                this.setDownloadState(3);
                this.updateMessage(NbBundle.getMessage(Retriever.class, (String)"MSG_DownloadComplete", (Object)string));
            } else {
                this.setDownloadState(5);
                this.updateMessage(NbBundle.getMessage(Retriever.class, (String)"MSG_DownloadCancelled"));
            }
        }
        catch (ConnectException connectException) {
            Logger.getLogger("glassfish").log(Level.FINE, connectException.getLocalizedMessage(), connectException);
            this.setDownloadState(4, "Connection Exception", connectException);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger("glassfish").log(Level.FINE, malformedURLException.getLocalizedMessage(), malformedURLException);
            this.setDownloadState(4, "Badly formed URL", malformedURLException);
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish").log(Level.FINE, iOException.getLocalizedMessage(), iOException);
            this.setDownloadState(4, "I/O Exception", iOException);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger("glassfish").log(Level.FINE, runtimeException.getLocalizedMessage(), runtimeException);
            this.setDownloadState(4, "Runtime Exception", runtimeException);
        }
        finally {
            if (this.shutdown || this.status != 3) {
                this.restoreInstallDir(this.targetInstallDir, file);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.updater.clearCancelState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDownloadLocation() {
        URLConnection uRLConnection = null;
        FilterInputStream filterInputStream = null;
        String string = this.defaultTargetUrl;
        if (this.locationUrl != null && this.locationUrl.length() > 0) {
            int n = 0;
            while (n++ < 3) {
                try {
                    URL uRL = new URL(this.locationUrl);
                    Logger.getLogger("glassfish").fine("Attempt " + n + " to get V3 download URL suffix from " + uRL);
                    uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(20000);
                    uRLConnection.setReadTimeout(20000);
                    filterInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
                    string = ((DataInputStream)filterInputStream).readLine();
                    if (string == null) continue;
                    String string2 = this.targetUrlPrefix + string;
                    return string2;
                }
                catch (Exception exception) {
                    Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
                }
                finally {
                    try {
                        if (filterInputStream == null) continue;
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadAndInstall(InputStream inputStream, File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            JarEntry jarEntry;
            byte[] byArray = new byte[131072];
            bufferedInputStream = new BufferedInputStream(inputStream, 131072);
            ZipInputStream zipInputStream2 = zipInputStream = new JarInputStream(bufferedInputStream);
            while (!this.shutdown && (jarEntry = (JarEntry)((JarInputStream)zipInputStream).getNextEntry()) != null) {
                String string = this.stripTopLevelDir(jarEntry.getName());
                if (string == null || string.length() == 0) continue;
                File file2 = new File(file, string);
                if (file2.exists()) {
                    throw new RuntimeException("Target " + file2.getPath() + " already exists.  Terminating archive installation.");
                }
                if (jarEntry.isDirectory()) {
                    if (file2.mkdirs()) continue;
                    throw new RuntimeException("Failed to create folder: " + file2.getName() + ".  Terminating archive installation.");
                }
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new RuntimeException("Failed to create folder: " + file3.getName() + ".  Terminating archive installation.");
                }
                int n = 0;
                FileOutputStream fileOutputStream = null;
                try {
                    int n2;
                    fileOutputStream = new FileOutputStream(file2);
                    long l = 1L;
                    while (!this.shutdown && (n2 = ((InputStream)zipInputStream2).read(byArray)) >= 0) {
                        n += n2;
                        long l2 = System.currentTimeMillis() / 333L;
                        if (l2 != l) {
                            this.updateMessage("Installing " + string, n);
                            l = l2;
                        }
                        fileOutputStream.write(byArray, 0, n2);
                    }
                }
                finally {
                    if (fileOutputStream == null) continue;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!this.shutdown) {
            this.ensureExecutable(file);
        }
        return this.shutdown;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureExecutable(File file) {
        String[] stringArray;
        void file2;
        if (Utilities.isWindows()) {
            return;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Object object = new String[]{"bin", "glassfish/bin", "javadb/bin"};
        int n = ((String[])object).length;
        boolean bl = false;
        while (file2 < n) {
            String string = object[file2];
            stringArray = new File(file, string);
            if (stringArray.exists()) {
                arrayList.add(stringArray);
            }
            ++file2;
        }
        if (arrayList.size() == 0) {
            return;
        }
        object = new File("/bin/chmod");
        if (!((File)object).isFile()) {
            object = new File("/usr/bin/chmod");
        }
        if (((File)object).isFile()) {
            try {
                for (File file3 : arrayList) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(((File)object).getAbsolutePath());
                    arrayList2.add("u+rx");
                    stringArray = file3.list();
                    for (String string : stringArray) {
                        if (string.indexOf(46) != -1) continue;
                        arrayList2.add(string);
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(arrayList2);
                    processBuilder.directory(file3);
                    Process process = processBuilder.start();
                    int n2 = process.waitFor();
                    if (n2 == 0) continue;
                    throw new IOException("could not run " + arrayList2 + " : Exit value=" + n2);
                }
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
        }
    }

    private String stripTopLevelDir(String string) {
        int n;
        if (string.startsWith(TOP_LEVEL_PREFIX) && (n = Retriever.slashIndexOf(string, TOP_LEVEL_PREFIX.length())) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private static int slashIndexOf(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '/' && c != '\\') continue;
            return i;
        }
        return -1;
    }

    private File backupInstallDir(File file) throws IOException {
        if (file.exists()) {
            File file2 = file.getParentFile();
            String string = file.getName();
            for (int i = 1; i < 100; ++i) {
                File file3 = new File(file2, string + i);
                if (file3.exists()) continue;
                if (!file.renameTo(file3)) {
                    throw new IOException("Unable to move existing " + (file.isDirectory() ? "folder \"" : "file \"") + file.getAbsolutePath() + "\" out of the way.");
                }
                return file3;
            }
            throw new IOException("Unable to backup \"" + file.getAbsolutePath() + "\".  Too many V3 backups already.");
        }
        return null;
    }

    private void restoreInstallDir(File file, File file2) {
        if (file != null && file.exists()) {
            Util.deleteFolder(file);
        }
        if (file2 != null && file2.exists()) {
            file2.renameTo(file);
        }
    }

    private String getDurationString(int n) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (n < 0) {
            stringBuilder.append("an eternity");
        } else if (n == 0) {
            stringBuilder.append("no time at all");
        } else {
            int n2;
            if (n >= 3600000) {
                n2 = n / 3600000;
                n %= 3600000;
                stringBuilder.append(n2);
                stringBuilder.append(n2 > 1 ? " hours" : " hour");
            }
            if (n >= 60000) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                n2 = n / 60000;
                n %= 60000;
                stringBuilder.append(n2);
                stringBuilder.append(n2 > 1 ? " minutes" : " minute");
            }
            if (n >= 1000 || stringBuilder.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                n2 = (n + 500) / 1000;
                n %= 1000;
                if (n2 > 0) {
                    stringBuilder.append(n2);
                    stringBuilder.append(n2 > 1 ? " seconds" : " second");
                }
            } else {
                stringBuilder.append(n);
                stringBuilder.append(" ms");
            }
        }
        return stringBuilder.toString();
    }

    public static interface Updater {
        public void updateMessageText(String var1);

        public void updateStatusText(String var1);

        public void clearCancelState();
    }
}

