/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationVisualPanel;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AddServerLocationPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private static final String DOMAIN_XML_PATH = "config/domain.xml";
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private ServerWizardIterator wizardIterator;
    private AddServerLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private AtomicBoolean isValidating = new AtomicBoolean();

    public AddServerLocationPanel(ServerWizardIterator serverWizardIterator) {
        this.wizardIterator = serverWizardIterator;
        this.wizard = null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent changeEvent) {
        Iterator<ChangeListener> iterator;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerLocationVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("registering_app_server_hk2_location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.isValidating.compareAndSet(false, true)) {
            try {
                this.wizardIterator.setHttpPort(-1);
                AddServerLocationVisualPanel addServerLocationVisualPanel = (AddServerLocationVisualPanel)this.getComponent();
                AddServerLocationVisualPanel.DownloadState downloadState = addServerLocationVisualPanel.getDownloadState();
                if (downloadState == AddServerLocationVisualPanel.DownloadState.DOWNLOADING) {
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)addServerLocationVisualPanel.getStatusText());
                    boolean bl = false;
                    return bl;
                }
                String string = addServerLocationVisualPanel.getHk2HomeLocation();
                String string2 = string = string != null ? string.trim() : null;
                if (string == null || string.length() == 0) {
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_BlankInstallDir"));
                    boolean bl = false;
                    return bl;
                }
                File file = new File(string);
                File file2 = this.getGlassfishRoot(file);
                File file3 = this.getDefaultDomain(file2);
                if (!file.exists()) {
                    if (AddServerLocationPanel.canCreate(file)) {
                        if (downloadState == AddServerLocationVisualPanel.DownloadState.AVAILABLE) {
                            addServerLocationVisualPanel.updateMessageText(NbBundle.getMessage(AddServerLocationPanel.class, (String)"LBL_InstallDirWillBeUsed", (Object)string));
                            this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)addServerLocationVisualPanel.getStatusText());
                            boolean bl = false;
                            return bl;
                        }
                        this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirDoesNotExist", (Object)string));
                        boolean bl = false;
                        return bl;
                    }
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_CannotCreate", (Object)string));
                    boolean bl = false;
                    return bl;
                }
                if (!this.isValidV3Install(file, file2)) {
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirInvalid", (Object)string));
                    boolean bl = false;
                    return bl;
                }
                if (!AddServerLocationPanel.isRegisterableV3Domain(file3)) {
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_DefaultDomainInvalid", (Object)string));
                    this.wizardIterator.setInstallRoot(file2.getParentFile().getAbsolutePath());
                    this.wizardIterator.setGlassfishRoot(file2.getAbsolutePath());
                    boolean bl = true;
                    return bl;
                }
                AddServerLocationPanel.readServerConfiguration(file3, this.wizardIterator);
                int bl = this.wizardIterator.getHttpPort();
                String string3 = "[" + file + "]" + "deployer:gfv3" + ":" + "localhost" + ":" + Integer.toString(bl);
                if (GlassfishInstanceProvider.getDefault().hasServer(string3)) {
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_DomainExists", (Object)string));
                    boolean string4 = false;
                    return string4;
                }
                String string4 = addServerLocationVisualPanel.getStatusText();
                if (string4 != null && string4.length() > 0) {
                    this.wizard.putProperty(PROP_ERROR_MESSAGE, (Object)string4);
                    boolean bl2 = false;
                    return bl2;
                }
                this.wizard.putProperty(PROP_ERROR_MESSAGE, null);
                this.wizardIterator.setInstallRoot(file2.getParentFile().getAbsolutePath());
                this.wizardIterator.setGlassfishRoot(file2.getAbsolutePath());
                this.wizardIterator.setDomainLocation(file3.getAbsolutePath());
                boolean bl3 = true;
                return bl3;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return true;
    }

    static boolean canCreate(File file) {
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        return file != null ? file.canRead() && file.canWrite() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    public void readSettings(Object object) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)object;
        }
    }

    public void storeSettings(Object object) {
    }

    public boolean isFinishPanel() {
        return this.wizardIterator.getHttpPort() != -1;
    }

    private boolean isValidV3Install(File file, File file2) {
        File file3 = ServerUtilities.getJarName(file2.getAbsolutePath(), "glassfish-10.0");
        if (file3 == null || !file3.exists()) {
            return false;
        }
        File file4 = new File(file2, "config" + File.separator + "glassfish.container");
        return file4.exists();
    }

    static boolean isRegisterableV3Domain(File file) {
        File file2 = new File(file, "logs");
        if (!file2.exists()) {
            file2 = file;
        }
        return file2.canWrite() && AddServerLocationPanel.readServerConfiguration(file, null);
    }

    private File getGlassfishRoot(File file) {
        File file2 = new File(file, "glassfish");
        if (!file2.exists()) {
            file2 = file;
        }
        return file2;
    }

    private File getDefaultDomain(File file) {
        File file2;
        File[] fileArray;
        File file3 = new File(file, "domains/domain1");
        if (!AddServerLocationPanel.isRegisterableV3Domain(file3) && null != (fileArray = (file2 = new File(file, "domains")).listFiles()) && fileArray.length > 0) {
            for (File file4 : fileArray) {
                if (!AddServerLocationPanel.isRegisterableV3Domain(file3)) continue;
                file3 = file4;
                break;
            }
        }
        return file3;
    }

    static boolean readServerConfiguration(File file, ServerWizardIterator serverWizardIterator) {
        boolean bl = false;
        File file2 = new File(file, DOMAIN_XML_PATH);
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (file2.exists()) {
            ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
            arrayList.add(new TreeParser.Path("/domain/configs/config/http-service/http-listener", new TreeParser.NodeReader(){

                public void readAttributes(String string, Attributes attributes) throws SAXException {
                    try {
                        String string2 = attributes.getValue("id");
                        if (string2 != null && string2.length() > 0) {
                            int n = Integer.parseInt(attributes.getValue("port"));
                            boolean bl = "true".equals(attributes.getValue("security-enabled"));
                            boolean bl2 = "true".equals(attributes.getValue("enabled"));
                            if (bl2) {
                                HttpData httpData = new HttpData(string2, n, bl);
                                Logger.getLogger("glassfish").log(Level.FINER, " Adding " + httpData);
                                linkedHashMap.put(string2, httpData);
                            } else {
                                Logger.getLogger("glassfish").log(Level.FINER, "http-listener " + string2 + " is not enabled and won't be used.");
                            }
                        } else {
                            Logger.getLogger("glassfish").log(Level.FINEST, "http-listener found with no name");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException(numberFormatException);
                    }
                }
            }));
            try {
                int n;
                TreeParser.readXml(file2, arrayList);
                HttpData httpData = (HttpData)linkedHashMap.remove("admin-listener");
                if (null != serverWizardIterator) {
                    serverWizardIterator.setAdminPort(httpData != null ? httpData.getPort() : -1);
                }
                HttpData httpData2 = null;
                HttpData httpData3 = null;
                for (HttpData httpData4 : linkedHashMap.values()) {
                    if (httpData4.isSecure()) {
                        if (httpData3 == null) {
                            httpData3 = httpData4;
                        }
                    } else if (httpData2 == null) {
                        httpData2 = httpData4;
                    }
                    if (httpData2 == null || httpData3 == null) continue;
                    break;
                }
                int n2 = n = httpData2 != null ? httpData2.getPort() : -1;
                if (null != serverWizardIterator) {
                    serverWizardIterator.setHttpPort(n);
                    serverWizardIterator.setHttpsPort(httpData3 != null ? httpData3.getPort() : -1);
                }
                bl = n != -1;
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger("glassfish").log(Level.INFO, illegalStateException.getLocalizedMessage(), illegalStateException);
            }
        }
        return bl;
    }

    private static class HttpData {
        private final String id;
        private final int port;
        private final boolean secure;

        public HttpData(String string, int n, boolean bl) {
            this.id = string;
            this.port = n;
            this.secure = bl;
        }

        public String getId() {
            return this.id;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String toString() {
            return "{ " + this.id + ", " + this.port + ", " + this.secure + " }";
        }
    }
}

