/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.actions.DebugAction;
import org.netbeans.modules.glassfish.common.actions.RefreshAction;
import org.netbeans.modules.glassfish.common.actions.RestartAction;
import org.netbeans.modules.glassfish.common.actions.StartServerAction;
import org.netbeans.modules.glassfish.common.actions.StopServerAction;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class LogViewMgr {
    private static final int DELAY = 1000;
    private static final Map<String, WeakReference<LogViewMgr>> instances = new HashMap<String, WeakReference<LogViewMgr>>();
    private InputOutput io;
    private final List<WeakReference<LoggerRunnable>> readers = Collections.synchronizedList(new ArrayList());
    private static final WeakHashMap<ServerInstance, InputOutput> ioWeakMap = new WeakHashMap();

    private LogViewMgr(String string) {
        this.io = LogViewMgr.getServerIO(string);
        if (this.io == null) {
            return;
        }
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogViewMgr getInstance(String string) {
        LogViewMgr logViewMgr = null;
        Map<String, WeakReference<LogViewMgr>> map = instances;
        synchronized (map) {
            WeakReference<LogViewMgr> weakReference = instances.get(string);
            LogViewMgr logViewMgr2 = logViewMgr = weakReference != null ? (LogViewMgr)weakReference.get() : null;
            if (logViewMgr == null) {
                logViewMgr = new LogViewMgr(string);
                instances.put(string, new WeakReference<LogViewMgr>(logViewMgr));
            }
        }
        return logViewMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureActiveReader(File file) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            boolean bl = false;
            for (WeakReference<LoggerRunnable> weakReference : this.readers) {
                LoggerRunnable loggerRunnable = (LoggerRunnable)weakReference.get();
                if (loggerRunnable == null) continue;
                bl = true;
                break;
            }
            if (!bl && file != null) {
                this.readFiles(new File[]{file});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readInputStreams(InputStream ... inputStreamArray) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            this.stopReaders();
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            for (InputStream inputStream : inputStreamArray) {
                LoggerRunnable loggerRunnable = new LoggerRunnable(this, inputStream, false);
                this.readers.add(new WeakReference<LoggerRunnable>(loggerRunnable));
                requestProcessor.post((Runnable)loggerRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFiles(File[] fileArray) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            this.stopReaders();
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            for (File file : fileArray) {
                try {
                    LoggerRunnable loggerRunnable = new LoggerRunnable(this, new FileInputStream(file), true);
                    this.readers.add(new WeakReference<LoggerRunnable>(loggerRunnable));
                    requestProcessor.post((Runnable)loggerRunnable);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.getLogger("glassfish").log(Level.FINE, fileNotFoundException.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReaders() {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            for (WeakReference<LoggerRunnable> weakReference : this.readers) {
                LoggerRunnable loggerRunnable = (LoggerRunnable)weakReference.get();
                if (loggerRunnable == null) continue;
                loggerRunnable.stop();
            }
            this.readers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReader(LoggerRunnable loggerRunnable) {
        List<WeakReference<LoggerRunnable>> list = this.readers;
        synchronized (list) {
            int n = this.readers.size();
            for (int i = 0; i < n; ++i) {
                WeakReference<LoggerRunnable> weakReference = this.readers.get(i);
                if (loggerRunnable != weakReference.get()) continue;
                this.readers.remove(i);
                break;
            }
        }
    }

    public synchronized void write(String string) {
        this.io.getOut().print(string);
    }

    public synchronized void selectIO() {
        this.io.select();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutput getServerIO(String string) {
        ServerInstance serverInstance = GlassfishInstanceProvider.getDefault().getInstance(string);
        if (serverInstance == null) {
            return null;
        }
        WeakHashMap<ServerInstance, InputOutput> weakHashMap = ioWeakMap;
        synchronized (weakHashMap) {
            InputOutput inputOutput = ioWeakMap.get(serverInstance);
            if (inputOutput != null) {
                return inputOutput;
            }
            Node node = serverInstance.getFullNode();
            if (node == null) {
                return null;
            }
            GlassfishModule glassfishModule = (GlassfishModule)node.getLookup().lookup(GlassfishModule.class);
            if (glassfishModule == null) {
                return null;
            }
            Action[] actionArray = new Action[]{new StartServerAction.OutputAction(glassfishModule), new DebugAction.OutputAction(glassfishModule), new RestartAction.OutputAction(glassfishModule), new StopServerAction.OutputAction(glassfishModule), new RefreshAction.OutputAction(glassfishModule)};
            InputOutput inputOutput2 = IOProvider.getDefault().getIO(serverInstance.getDisplayName(), actionArray);
            ioWeakMap.put(serverInstance, inputOutput2);
            return inputOutput2;
        }
    }

    private static class LogParser {
        private String time;
        private String type;
        private String version;
        private String classinfo;
        private String threadinfo;
        private String message;
        private int state = 0;
        private StringBuilder msg = new StringBuilder(128);

        LogParser() {
            this.reset();
        }

        private void reset() {
            this.message = "";
            this.threadinfo = "";
            this.classinfo = "";
            this.version = "";
            this.type = "";
            this.time = "";
        }

        String parse(char c) {
            String string = null;
            switch (this.state) {
                case 0: {
                    if (c == '[') {
                        this.state = 1;
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        string = this.msg.toString() + '\n';
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append(c);
                    break;
                }
                case 1: {
                    if (c == '#') {
                        this.state = 2;
                        break;
                    }
                    this.state = 0;
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        string = this.msg.toString() + '\n';
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.msg.append('[');
                    this.msg.append(c);
                    break;
                }
                case 2: {
                    if (c == '|') {
                        this.state = 3;
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\n') {
                        if (this.msg.length() <= 0) break;
                        string = this.msg.toString() + '\n';
                        this.msg.setLength(0);
                        break;
                    }
                    if (c == '\r') break;
                    this.state = 0;
                    this.msg.append('[');
                    this.msg.append('#');
                    this.msg.append(c);
                    break;
                }
                case 3: {
                    if (c == '|') {
                        this.state = 4;
                        this.time = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 4: {
                    if (c == '|') {
                        this.state = 5;
                        this.type = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 5: {
                    if (c == '|') {
                        this.state = 6;
                        this.version = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 6: {
                    if (c == '|') {
                        this.state = 7;
                        this.classinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 7: {
                    if (c == '|') {
                        this.state = 8;
                        this.threadinfo = this.msg.toString();
                        this.msg.setLength(0);
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 8: {
                    if (c == '|') {
                        this.state = 9;
                        this.message = this.msg.toString();
                        break;
                    }
                    this.msg.append(c);
                    break;
                }
                case 9: {
                    if (c == '#') {
                        this.state = 10;
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append(c);
                    break;
                }
                case 10: {
                    if (c == ']') {
                        this.state = 0;
                        this.msg.setLength(0);
                        string = this.time + ' ' + this.type + ": " + this.message + '\n';
                        this.reset();
                        break;
                    }
                    this.state = 8;
                    this.msg.append('|');
                    this.msg.append('#');
                    this.msg.append(c);
                }
            }
            return string;
        }
    }

    private class LoggerRunnable
    implements Runnable {
        private final LogViewMgr logView;
        private final InputStream inputStream;
        private final boolean ignoreEof;
        private volatile boolean shutdown;

        public LoggerRunnable(LogViewMgr logViewMgr2, InputStream inputStream, boolean bl) {
            this.logView = logViewMgr2;
            this.inputStream = inputStream;
            this.ignoreEof = bl;
            this.shutdown = false;
        }

        public void stop() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string = Thread.currentThread().getName();
            Reader reader = null;
            try {
                Thread.currentThread().setName(this.getClass().getName() + " - " + this.inputStream);
                reader = new BufferedReader(new InputStreamReader(this.inputStream));
                LogParser logParser = new LogParser();
                char[] cArray = new char[1024];
                int n = 0;
                while (!this.shutdown && n != -1) {
                    if (this.ignoreEof) {
                        while (!this.shutdown && reader.ready()) {
                            String string2 = logParser.parse((char)reader.read());
                            if (string2 == null) continue;
                            LogViewMgr.this.write(string2);
                            LogViewMgr.this.selectIO();
                        }
                    } else {
                        while (!this.shutdown && (n = reader.read(cArray)) != -1) {
                            LogViewMgr.this.write(new String(cArray, 0, n));
                            LogViewMgr.this.selectIO();
                            if (reader.ready()) continue;
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.SEVERE, "I/O exception reading server log", iOException);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish").log(Level.SEVERE, "I/O exception closing server log", iOException);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish").log(Level.WARNING, "I/O exception closing stream buffer", iOException);
                    }
                }
                this.logView.removeReader(this);
                Thread.currentThread().setName(string);
            }
        }
    }
}

