/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.coloring;

import java.awt.Color;
import java.util.EventListener;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class EmbeddingHighlightsContainer
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(EmbeddingHighlightsContainer.class.getName());
    private static final String CSS_BACKGROUND_TOKEN_NAME = "css-embedded";
    private static final String JAVASCRIPT_BACKGROUND_TOKEN_NAME = "javascript-embedded";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String CSS_MIME_TYPE = "text/x-css";
    private static final String CSS_INLINED_MIME_TYPE = "text/x-css-inlined";
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    private final AttributeSet cssBackground;
    private final AttributeSet javascriptBackground;
    private final Document document;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    EmbeddingHighlightsContainer(Document document) {
        this.document = document;
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)HTML_MIME_TYPE).lookup(FontColorSettings.class);
        Color color = null;
        Color color2 = null;
        if (fontColorSettings != null) {
            color = EmbeddingHighlightsContainer.getColoring(fontColorSettings, CSS_BACKGROUND_TOKEN_NAME);
            color2 = EmbeddingHighlightsContainer.getColoring(fontColorSettings, JAVASCRIPT_BACKGROUND_TOKEN_NAME);
        }
        this.cssBackground = color == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, ATTR_EXTENDS_EOL, Boolean.TRUE});
        this.javascriptBackground = color2 == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color2, ATTR_EXTENDS_EOL, Boolean.TRUE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        EmbeddingHighlightsContainer embeddingHighlightsContainer = this;
        synchronized (embeddingHighlightsContainer) {
            if (this.javascriptBackground != null || this.cssBackground != null) {
                if (this.hierarchy == null) {
                    this.hierarchy = TokenHierarchy.get((Document)this.document);
                    if (this.hierarchy != null) {
                        this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
                    }
                }
                if (this.hierarchy != null) {
                    return new Highlights(this.version, this.hierarchy, n, n2);
                }
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
        EmbeddingHighlightsContainer embeddingHighlightsContainer = this;
        synchronized (embeddingHighlightsContainer) {
            ++this.version;
        }
        this.fireHighlightsChange(tokenHierarchyEvent.affectedStartOffset(), tokenHierarchyEvent.affectedEndOffset());
    }

    private static Color getColoring(FontColorSettings fontColorSettings, String string) {
        AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
        if (attributeSet != null) {
            return (Color)attributeSet.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Highlights
    implements HighlightsSequence {
        private final long version;
        private final TokenHierarchy<? extends Document> scanner;
        private final int startOffsetBoundary;
        private final int endOffsetBoundary;
        private List<TokenSequence<?>> tokenSequenceList = null;
        private int startOffset;
        private int endOffset;
        private int realEndOffset;
        private AttributeSet attributeSet;
        private boolean finished = false;

        private Highlights(long l, TokenHierarchy<? extends Document> tokenHierarchy, int n, int n2) {
            this.version = l;
            this.scanner = tokenHierarchy;
            this.startOffsetBoundary = n;
            this.endOffsetBoundary = n2;
        }

        private boolean _moveNext() {
            Object object;
            LanguagePath languagePath;
            if (this.tokenSequenceList == null) {
                this.startOffset = this.startOffsetBoundary;
                this.endOffset = this.startOffsetBoundary;
                this.realEndOffset = this.startOffsetBoundary;
                String string = (String)EmbeddingHighlightsContainer.this.document.getProperty("mimeType");
                Language language = Language.find((String)string);
                if (language != null) {
                    languagePath = LanguagePath.get((Language)language);
                    if (string.equals(EmbeddingHighlightsContainer.HTML_MIME_TYPE)) {
                        this.tokenSequenceList = this.scanner.tokenSequenceList(languagePath, this.startOffsetBoundary, this.endOffsetBoundary);
                    } else {
                        object = LanguagePath.get((LanguagePath)languagePath, (Language)HTMLTokenId.language());
                        this.tokenSequenceList = this.scanner.tokenSequenceList((LanguagePath)object, this.startOffsetBoundary, this.endOffsetBoundary);
                    }
                } else {
                    LOG.log(Level.WARNING, "Language " + (String)string + " obtained from the document mimeType property cannot be found!");
                }
            }
            if (this.tokenSequenceList != null) {
                for (TokenSequence<?> tokenSequence : this.tokenSequenceList) {
                    assert (tokenSequence.language().mimeType().equals(EmbeddingHighlightsContainer.HTML_MIME_TYPE));
                    tokenSequence.move(this.realEndOffset);
                    while (tokenSequence.moveNext() && tokenSequence.offset() < this.endOffsetBoundary) {
                        languagePath = tokenSequence.embedded();
                        if (languagePath == null || !languagePath.moveNext() || !EmbeddingHighlightsContainer.CSS_MIME_TYPE.equals(object = languagePath.language().mimeType()) && !EmbeddingHighlightsContainer.CSS_INLINED_MIME_TYPE.equals(object) && !EmbeddingHighlightsContainer.JAVASCRIPT_MIME_TYPE.equals(object)) continue;
                        try {
                            int n;
                            this.endOffset = this.startOffset = languagePath.offset();
                            while (languagePath.moveNext()) {
                                this.endOffset = languagePath.offset() + languagePath.token().length();
                            }
                            this.realEndOffset = this.endOffset > this.realEndOffset ? this.endOffset : this.realEndOffset + 1;
                            int n2 = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)this.startOffset);
                            if (n2 != (n = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)this.endOffset))) {
                                if (Utilities.getFirstNonWhiteBwd((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)Utilities.getRowEnd((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)this.startOffset)) + 1 == this.startOffset) {
                                    this.startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)(n2 + 1));
                                }
                                if (Utilities.getFirstNonWhiteFwd((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)n)) == this.endOffset) {
                                    this.endOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddingHighlightsContainer.this.document), (int)n);
                                }
                            }
                            this.attributeSet = ((String)object).equals(EmbeddingHighlightsContainer.JAVASCRIPT_MIME_TYPE) ? EmbeddingHighlightsContainer.this.javascriptBackground : EmbeddingHighlightsContainer.this.cssBackground;
                            return true;
                        }
                        catch (BadLocationException badLocationException) {
                            LOG.log(Level.INFO, "An error occured when creating coloured background for CSS and JavaScript.", badLocationException);
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.checkVersion() && this._moveNext()) {
                    return true;
                }
            }
            this.finished = true;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.tokenSequenceList != null) : "Sequence not initialized, call moveNext() first.";
                return this.startOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.tokenSequenceList != null) : "Sequence not initialized, call moveNext() first.";
                return this.endOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            EmbeddingHighlightsContainer embeddingHighlightsContainer = EmbeddingHighlightsContainer.this;
            synchronized (embeddingHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.tokenSequenceList != null) : "Sequence not initialized, call moveNext() first.";
                return this.attributeSet;
            }
        }

        private boolean checkVersion() {
            return this.version == EmbeddingHighlightsContainer.this.version;
        }
    }
}

