/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellEditor;
import org.netbeans.modules.visualweb.propertyeditors.css.BorderWidthField;
import org.netbeans.modules.visualweb.propertyeditors.css.ColorSelectionField;
import org.netbeans.modules.visualweb.propertyeditors.css.model.BorderModel;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;
import org.openide.util.NbBundle;

public class BorderDataTable
extends JTable {
    CssStyleData cssStyleData;
    private String value;
    JComboBox allStyleCombo;
    BorderWidthField allWidthField;
    ColorSelectionField allColorField;
    JComboBox topStyleCombo;
    BorderWidthField topWidthField;
    ColorSelectionField topColorField;
    JComboBox bottomStyleCombo;
    BorderWidthField bottomWidthField;
    ColorSelectionField bottomColorField;
    JComboBox leftStyleCombo;
    BorderWidthField leftWidthField;
    ColorSelectionField leftColorField;
    JComboBox rightStyleCombo;
    BorderWidthField rightWidthField;
    ColorSelectionField rightColorField;
    private StyleItemListener styleItemListener = new StyleItemListener();
    private WidthPropertyChangeListener widthPropertyChangeListener = new WidthPropertyChangeListener();
    private ColorPropertyChangeListener colorPropertyChangeListener = new ColorPropertyChangeListener();

    public BorderDataTable(CssStyleData cssStyleData) {
        super(6, 4);
        this.cssStyleData = cssStyleData;
        this.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setRowHeight(fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25);
        this.setAutoResizeMode(0);
        this.setIntercellSpacing(new Dimension(5, 5));
        this.setTableHeader(null);
        this.setBackground(new JPanel().getBackground());
        this.initCells();
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.getColumnModel().getColumn(2).setPreferredWidth(125);
        this.getColumnModel().getColumn(3).setPreferredWidth(125);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE_TABLE_ACCESS_NAME"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE_TABLE_ACCESS_DESC"));
    }

    public void initCells() {
        JPanel jPanel = new JPanel();
        this.setValueAt(jPanel, 0, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE")));
        this.setValueAt(jPanel2, 0, 1);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_WIDTH")));
        this.setValueAt(jPanel3, 0, 2);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_COLOR")));
        this.setValueAt(jPanel4, 0, 3);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_ALL")));
        this.setValueAt(jPanel5, 1, 0);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_TOP")));
        this.setValueAt(jPanel6, 2, 0);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_BOTTOM")));
        this.setValueAt(jPanel7, 3, 0);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_LEFT")));
        this.setValueAt(jPanel8, 4, 0);
        JPanel jPanel9 = new JPanel();
        jPanel9.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_RIGHT")));
        this.setValueAt(jPanel9, 5, 0);
        BorderModel borderModel = new BorderModel();
        this.allStyleCombo = new JComboBox();
        this.allStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.allStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.allStyleCombo.setModel(borderModel.getStyleList());
        this.allStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.allStyleCombo, 1, 1);
        this.allWidthField = new BorderWidthField();
        this.allWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.allWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.allWidthField.addCssPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.allWidthField, 1, 2);
        this.allColorField = new ColorSelectionField();
        this.allColorField.addCssPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.allColorField, 1, 3);
        this.topStyleCombo = new JComboBox();
        this.topStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.topStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.topStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-top-style") != null) {
            this.topStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-top-style"));
        }
        this.topStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.topStyleCombo, 2, 1);
        this.topWidthField = new BorderWidthField();
        this.topWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.topWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.topWidthField.setWidthString(this.cssStyleData.getProperty("border-top-width"));
        this.topWidthField.addCssPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.topWidthField, 2, 2);
        this.topColorField = new ColorSelectionField();
        this.topColorField.setColorString(this.cssStyleData.getProperty("border-top-color"));
        this.topColorField.addCssPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.topColorField, 2, 3);
        this.bottomStyleCombo = new JComboBox();
        this.bottomStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.bottomStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.bottomStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-bottom-style") != null) {
            this.bottomStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-bottom-style"));
        }
        this.bottomStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.bottomStyleCombo, 3, 1);
        this.bottomWidthField = new BorderWidthField();
        this.bottomWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.bottomWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.bottomWidthField.setWidthString(this.cssStyleData.getProperty("border-bottom-width"));
        this.bottomWidthField.addCssPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.bottomWidthField, 3, 2);
        this.bottomColorField = new ColorSelectionField();
        this.bottomColorField.setColorString(this.cssStyleData.getProperty("border-bottom-color"));
        this.bottomColorField.addCssPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.bottomColorField, 3, 3);
        this.leftStyleCombo = new JComboBox<String>(new String[0]);
        this.leftStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.leftStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.leftStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-left-style") != null) {
            this.leftStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-left-style"));
        }
        this.leftStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.leftStyleCombo, 4, 1);
        this.leftWidthField = new BorderWidthField();
        this.leftWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.leftWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.leftWidthField.setWidthString(this.cssStyleData.getProperty("border-left-width"));
        this.leftWidthField.addCssPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.leftWidthField, 4, 2);
        this.leftColorField = new ColorSelectionField();
        this.leftColorField.setColorString(this.cssStyleData.getProperty("border-left-color"));
        this.leftColorField.addCssPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.leftColorField, 4, 3);
        this.rightStyleCombo = new JComboBox();
        this.rightStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_NAME"));
        this.rightStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_DESC"));
        this.rightStyleCombo.setModel(borderModel.getStyleList());
        if (this.cssStyleData.getProperty("border-right-style") != null) {
            this.rightStyleCombo.setSelectedItem(this.cssStyleData.getProperty("border-right-style"));
        }
        this.rightStyleCombo.addItemListener(this.styleItemListener);
        this.setValueAt(this.rightStyleCombo, 5, 1);
        this.rightWidthField = new BorderWidthField();
        this.rightWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.rightWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
        this.rightWidthField.setWidthString(this.cssStyleData.getProperty("border-right-width"));
        this.rightWidthField.addCssPropertyChangeListener(this.widthPropertyChangeListener);
        this.setValueAt(this.rightWidthField, 5, 2);
        this.rightColorField = new ColorSelectionField();
        this.rightColorField.setColorString(this.cssStyleData.getProperty("border-right-color"));
        this.rightColorField.addCssPropertyChangeListener(this.colorPropertyChangeListener);
        this.setValueAt(this.rightColorField, 5, 3);
        this.checkBorderStyleAll();
        this.checkBorderWidthAll();
        this.checkBorderColorAll();
    }

    private void checkBorderStyleAll() {
        this.allStyleCombo.removeItemListener(this.styleItemListener);
        String string = this.cssStyleData.getProperty("border-top-style");
        String string2 = this.cssStyleData.getProperty("border-bottom-style");
        String string3 = this.cssStyleData.getProperty("border-left-style");
        String string4 = this.cssStyleData.getProperty("border-right-style");
        if (string != null && string2 != null && string3 != null && string4 != null && string.equals(string2) && string.equals(string3) && string.equals(string4)) {
            this.allStyleCombo.setSelectedItem(string);
        } else {
            this.allStyleCombo.setSelectedIndex(0);
        }
        this.allStyleCombo.addItemListener(this.styleItemListener);
    }

    private void checkBorderWidthAll() {
        this.allWidthField.removeCssPropertyChangeListener(this.widthPropertyChangeListener);
        String string = this.cssStyleData.getProperty("border-top-width");
        String string2 = this.cssStyleData.getProperty("border-bottom-width");
        String string3 = this.cssStyleData.getProperty("border-left-width");
        String string4 = this.cssStyleData.getProperty("border-right-width");
        if (string != null && string2 != null && string3 != null && string4 != null && string.equals(string2) && string.equals(string3) && string.equals(string4)) {
            this.allWidthField.setWidthString(string);
        } else {
            this.allWidthField.setWidthString(null);
        }
        this.allWidthField.addCssPropertyChangeListener(this.widthPropertyChangeListener);
    }

    private void checkBorderColorAll() {
        this.allColorField.removeCssPropertyChangeListener(this.colorPropertyChangeListener);
        String string = this.cssStyleData.getProperty("border-top-color");
        String string2 = this.cssStyleData.getProperty("border-bottom-color");
        String string3 = this.cssStyleData.getProperty("border-left-color");
        String string4 = this.cssStyleData.getProperty("border-right-color");
        if (string != null && string2 != null && string3 != null && string4 != null && string.equals(string2) && string.equals(string3) && string.equals(string4)) {
            this.allColorField.setColorString(string);
        } else {
            this.allColorField.setColorString(null);
        }
        this.allColorField.addCssPropertyChangeListener(this.colorPropertyChangeListener);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            Object object;
            Class<?> clazz = this.getColumnClass(n2);
            if (clazz.equals(Object.class) && (object = this.getValueAt(n, n2)) != null) {
                clazz = this.getValueAt(n, n2).getClass();
            }
            tableCellRenderer = this.getDefaultRenderer(clazz);
        }
        return tableCellRenderer;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            Object object;
            Class<?> clazz = this.getColumnClass(n2);
            if (clazz.equals(Object.class) && (object = this.getValueAt(n, n2)) != null) {
                clazz = this.getValueAt(n, n2).getClass();
            }
            tableCellEditor = this.getDefaultEditor(clazz);
        }
        return tableCellEditor;
    }

    class JComponentCellEditor
    implements TableCellEditor,
    TreeCellEditor,
    Serializable {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        protected JComponent editorComponent = null;
        protected JComponent container = null;

        JComponentCellEditor() {
        }

        public Component getComponent() {
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.editorComponent;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            if (this.editorComponent != null && eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getID() == 501) {
                Component component = SwingUtilities.getDeepestComponentAt(this.editorComponent, 3, 3);
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                MouseEvent mouseEvent2 = new MouseEvent(component, 502, mouseEvent.getWhen() + 100000L, mouseEvent.getModifiers(), 3, 3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                component.dispatchEvent(mouseEvent2);
                mouseEvent2 = new MouseEvent(component, 500, mouseEvent.getWhen() + 100001L, mouseEvent.getModifiers(), 3, 3, 1, mouseEvent.isPopupTrigger());
                component.dispatchEvent(mouseEvent2);
            }
            return false;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.add(CellEditorListener.class, cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.remove(CellEditorListener.class, cellEditorListener);
        }

        protected void fireEditingStopped() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
            }
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
            this.editorComponent = (JComponent)object;
            this.container = jTree;
            return this.editorComponent;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editorComponent = (JComponent)object;
            this.container = jTable;
            return this.editorComponent;
        }
    }

    class JComponentCellRenderer
    implements TableCellRenderer {
        JComponentCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)object;
            jComponent.setMinimumSize(new Dimension(100, 25));
            return jComponent;
        }
    }

    class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    private class ColorPropertyChangeListener
    implements PropertyChangeListener {
        private ColorPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BorderDataTable.this.allColorField) {
                BorderDataTable.this.topColorField.removeCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.bottomColorField.removeCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.leftColorField.removeCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.rightColorField.removeCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.topColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.bottomColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.leftColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.rightColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-color", BorderDataTable.this.allColorField.getColorString());
                BorderDataTable.this.topColorField.addCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.bottomColorField.addCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.leftColorField.addCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
                BorderDataTable.this.rightColorField.addCssPropertyChangeListener(BorderDataTable.this.colorPropertyChangeListener);
            }
            if (propertyChangeEvent.getSource() == BorderDataTable.this.topColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-color", BorderDataTable.this.topColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
            if (propertyChangeEvent.getSource() == BorderDataTable.this.bottomColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-color", BorderDataTable.this.bottomColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
            if (propertyChangeEvent.getSource() == BorderDataTable.this.leftColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-color", BorderDataTable.this.leftColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
            if (propertyChangeEvent.getSource() == BorderDataTable.this.rightColorField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-color", BorderDataTable.this.rightColorField.getColorString());
                BorderDataTable.this.checkBorderColorAll();
            }
        }
    }

    private class WidthPropertyChangeListener
    implements PropertyChangeListener {
        private WidthPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BorderDataTable.this.allWidthField) {
                BorderDataTable.this.topWidthField.removeCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.bottomWidthField.removeCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.leftWidthField.removeCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.rightWidthField.removeCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.topWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.bottomWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.leftWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.rightWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.topWidthField.addCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.bottomWidthField.addCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.leftWidthField.addCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
                BorderDataTable.this.rightWidthField.addCssPropertyChangeListener(BorderDataTable.this.widthPropertyChangeListener);
            } else if (propertyChangeEvent.getSource() == BorderDataTable.this.topWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            } else if (propertyChangeEvent.getSource() == BorderDataTable.this.bottomWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            } else if (propertyChangeEvent.getSource() == BorderDataTable.this.leftWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            } else if (propertyChangeEvent.getSource() == BorderDataTable.this.rightWidthField) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-width", propertyChangeEvent.getNewValue().toString());
                BorderDataTable.this.checkBorderWidthAll();
            }
        }
    }

    private class StyleItemListener
    implements ItemListener {
        private StyleItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == BorderDataTable.this.allStyleCombo) {
                BorderDataTable.this.topStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.bottomStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.leftStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.rightStyleCombo.removeItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.topStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.bottomStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.leftStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-style", BorderDataTable.this.allStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.rightStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                BorderDataTable.this.topStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.bottomStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.leftStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
                BorderDataTable.this.rightStyleCombo.addItemListener(BorderDataTable.this.styleItemListener);
            } else if (itemEvent.getSource() == BorderDataTable.this.topStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-top-style", BorderDataTable.this.topStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            } else if (itemEvent.getSource() == BorderDataTable.this.bottomStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-bottom-style", BorderDataTable.this.bottomStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            } else if (itemEvent.getSource() == BorderDataTable.this.leftStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-left-style", BorderDataTable.this.leftStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            } else if (itemEvent.getSource() == BorderDataTable.this.rightStyleCombo) {
                BorderDataTable.this.cssStyleData.modifyProperty("border-right-style", BorderDataTable.this.rightStyleCombo.getSelectedItem().toString());
                BorderDataTable.this.checkBorderStyleAll();
            }
        }
    }
}

