/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.binding.nodes;

import com.sun.data.provider.DataProvider;
import com.sun.data.provider.FieldKey;
import com.sun.rave.designtime.DesignBean;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import javax.faces.model.SelectItem;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.propertyeditors.binding.BindingTargetNode;
import org.netbeans.modules.visualweb.propertyeditors.binding.BindingTargetNodeFactory;
import org.netbeans.modules.visualweb.propertyeditors.binding.PropertyBindingHelper;
import org.netbeans.modules.visualweb.propertyeditors.binding.nodes.PropertyTargetNode;
import org.netbeans.modules.visualweb.propertyeditors.util.Bundle;
import org.openide.ErrorManager;

public class DataProviderTargetNodeFactory
implements BindingTargetNodeFactory {
    private static final Bundle bundle = Bundle.getBundle(DataProviderTargetNodeFactory.class);

    public boolean supportsTargetClass(Class clazz) {
        return DataProvider.class.isAssignableFrom(clazz);
    }

    public BindingTargetNode createTargetNode(BindingTargetNode bindingTargetNode, DesignBean designBean, PropertyDescriptor[] propertyDescriptorArray, Object object) {
        return new DataProviderTargetNode(bindingTargetNode, designBean, propertyDescriptorArray, object);
    }

    public class DataProviderTargetNode
    extends PropertyTargetNode {
        public DataProviderTargetNode(BindingTargetNode bindingTargetNode, DesignBean designBean, PropertyDescriptor[] propertyDescriptorArray, Object object) {
            super(bindingTargetNode, designBean, propertyDescriptorArray, object);
        }

        public void lazyLoadCustomTargetNodes() {
            if (this.propInstance == null) {
                this.propInstance = PropertyBindingHelper.getPropInstance(this.bean, this.propPath);
            }
            if (this.propInstance instanceof DataProvider) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        final DataProvider dataProvider = (DataProvider)DataProviderTargetNode.this.propInstance;
                        try {
                            final FieldKey[] fieldKeyArray = dataProvider.getFieldKeys();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    for (int i = 0; fieldKeyArray != null && i < fieldKeyArray.length; ++i) {
                                        DataProviderTargetNode.super.add(new FieldKeyNode(DataProviderTargetNode.this, DataProviderTargetNode.this.bean, DataProviderTargetNode.this.propPath, dataProvider, fieldKeyArray[i]));
                                    }
                                    DataProviderTargetNode.super.add(new OptionsNode(DataProviderTargetNode.this, dataProvider, fieldKeyArray));
                                    DataProviderTargetNode.super.add(new SelectItemsNode(DataProviderTargetNode.this, dataProvider, fieldKeyArray));
                                }
                            });
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    }
                });
                thread.setPriority(1);
                thread.start();
            }
        }

        public class ComboDisplayColumnRenderer
        extends DefaultListCellRenderer {
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof ComboDisplayColumn) {
                    ComboDisplayColumn comboDisplayColumn = (ComboDisplayColumn)object;
                    String string = comboDisplayColumn.fieldType != null ? comboDisplayColumn.fieldType.getName() : "";
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<html><b>");
                    stringBuffer.append(comboDisplayColumn.fieldKey.getDisplayName());
                    stringBuffer.append("</b> &nbsp; <font size=\"-1\"><i>");
                    stringBuffer.append(string);
                    stringBuffer.append("</i></font></html>");
                    this.setText(stringBuffer.toString());
                } else {
                    this.setText(bundle.getMessage("noneBrackets"));
                }
                return this;
            }
        }

        public class ComboDisplayColumn {
            public FieldKey fieldKey;
            public Class fieldType;

            public ComboDisplayColumn(FieldKey fieldKey, Class clazz) {
                this.fieldKey = fieldKey;
                this.fieldType = clazz;
            }
        }

        public class SelectItemsNode
        extends BindingTargetNode {
            protected DataProvider provider;
            FieldKey[] cols;
            protected String displayTextEnabled;
            protected String displayTextDisabled;
            JPanel pickerPanel;
            JLabel valueLabel;
            JLabel labelLabel;
            JLabel descrLabel;
            JComboBox valueCombo;
            JComboBox labelCombo;
            JComboBox descrCombo;
            ActionListener updateCallback;
            ActionListener updateAdapter;

            public SelectItemsNode(BindingTargetNode bindingTargetNode, DataProvider dataProvider, FieldKey[] fieldKeyArray) {
                super(bindingTargetNode);
                this.displayTextEnabled = null;
                this.displayTextDisabled = null;
                this.pickerPanel = new JPanel();
                this.valueLabel = new JLabel(bundle.getMessage("valueField"));
                this.labelLabel = new JLabel(bundle.getMessage("displayField"));
                this.descrLabel = new JLabel(bundle.getMessage("tooltipField"));
                this.valueCombo = new JComboBox();
                this.labelCombo = new JComboBox();
                this.descrCombo = new JComboBox();
                this.updateCallback = null;
                this.updateAdapter = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SelectItemsNode.this.updateCallback != null) {
                            SelectItemsNode.this.updateCallback.actionPerformed(actionEvent);
                        }
                    }
                };
                this.provider = dataProvider;
                this.cols = fieldKeyArray;
                this.initCustomPanel();
                this.displayTextEnabled = this.getDisplayText(true);
                this.displayTextDisabled = this.getDisplayText(false);
            }

            public String getNodeDisplayName() {
                return bundle.getMessage("selectItems");
            }

            public String getDisplayText(boolean bl) {
                if (bl && this.displayTextEnabled != null) {
                    return this.displayTextEnabled;
                }
                if (!bl && this.displayTextDisabled != null) {
                    return this.displayTextDisabled;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                if (!bl) {
                    stringBuffer.append("<font color=\"gray\">");
                }
                if (bl) {
                    stringBuffer.append("<b>");
                }
                stringBuffer.append(this.getNodeDisplayName());
                if (bl) {
                    stringBuffer.append("</b>");
                }
                stringBuffer.append(" &nbsp; <font size=\"-1\"><i>");
                stringBuffer.append(bundle.getMessage("parenItemsForListBoxOr"));
                stringBuffer.append("</i></font>");
                if (!bl) {
                    stringBuffer.append("</font>");
                }
                stringBuffer.append("</html>");
                return stringBuffer.toString();
            }

            public int getChildCount() {
                return 0;
            }

            public boolean lazyLoad() {
                return true;
            }

            public Class getTargetTypeClass() {
                return SelectItem[].class;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "selectItems['" + this.getColumnPicks() + "']";
            }

            String getColumnPicks() {
                StringBuffer stringBuffer = new StringBuffer();
                Object object = this.valueCombo.getSelectedItem();
                if (object instanceof ComboDisplayColumn) {
                    stringBuffer.append(((ComboDisplayColumn)object).fieldKey.getFieldId());
                }
                if ((object = this.labelCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    stringBuffer.append(",");
                    stringBuffer.append(((ComboDisplayColumn)object).fieldKey.getFieldId());
                }
                if ((object = this.descrCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    stringBuffer.append(",");
                    stringBuffer.append(((ComboDisplayColumn)object).fieldKey.getFieldId());
                }
                return stringBuffer.toString();
            }

            void initCustomPanel() {
                ComboDisplayColumnRenderer comboDisplayColumnRenderer = new ComboDisplayColumnRenderer();
                this.valueCombo.setRenderer(comboDisplayColumnRenderer);
                this.labelCombo.setRenderer(comboDisplayColumnRenderer);
                this.descrCombo.setRenderer(comboDisplayColumnRenderer);
                this.labelCombo.addItem(bundle.getMessage("noneBrackets"));
                this.descrCombo.addItem(bundle.getMessage("noneBrackets"));
                if (this.cols != null && this.cols.length > 0) {
                    for (int i = 0; i < this.cols.length; ++i) {
                        ComboDisplayColumn comboDisplayColumn = new ComboDisplayColumn(this.cols[i], this.provider.getType(this.cols[i]));
                        this.valueCombo.addItem(comboDisplayColumn);
                        this.labelCombo.addItem(comboDisplayColumn);
                        this.descrCombo.addItem(comboDisplayColumn);
                    }
                }
                this.pickerPanel.setLayout(new GridBagLayout());
                this.pickerPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
                this.pickerPanel.add((Component)this.valueCombo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.valueCombo.addActionListener(this.updateAdapter);
                this.labelCombo.addActionListener(this.updateAdapter);
                this.descrCombo.addActionListener(this.updateAdapter);
            }

            public JComponent getCustomDisplayPanel(ActionListener actionListener) {
                this.updateCallback = actionListener;
                return this.pickerPanel;
            }
        }

        public class OptionsNode
        extends SelectItemsNode {
            public OptionsNode(BindingTargetNode bindingTargetNode, DataProvider dataProvider, FieldKey[] fieldKeyArray) {
                super(bindingTargetNode, dataProvider, fieldKeyArray);
            }

            public String getNodeDisplayName() {
                return bundle.getMessage("options");
            }

            public String getBindingExpressionPart() {
                return "options['" + this.getColumnPicks() + "']";
            }
        }

        public class FieldKeyNode
        extends BindingTargetNode {
            protected DesignBean bean;
            protected PropertyDescriptor[] propPath;
            protected DataProvider provider;
            protected FieldKey key;

            public FieldKeyNode(BindingTargetNode bindingTargetNode, DesignBean designBean, PropertyDescriptor[] propertyDescriptorArray, DataProvider dataProvider, FieldKey fieldKey) {
                super(bindingTargetNode);
                this.bean = designBean;
                this.propPath = propertyDescriptorArray;
                this.provider = dataProvider;
                this.key = fieldKey;
            }

            public boolean lazyLoad() {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.getTargetTypeClass());
                    PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    for (int i = 0; propertyDescriptorArray != null && i < propertyDescriptorArray.length; ++i) {
                        if (propertyDescriptorArray[i].getReadMethod() == null) continue;
                        PropertyDescriptor[] propertyDescriptorArray2 = new PropertyDescriptor[this.propPath.length + 1];
                        System.arraycopy(this.propPath, 0, propertyDescriptorArray2, 0, this.propPath.length);
                        propertyDescriptorArray2[propertyDescriptorArray2.length - 1] = propertyDescriptorArray[i];
                        super.add(FieldKeyNode._createTargetNode(this, this.bean, propertyDescriptorArray2, null));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "value['" + this.key.getFieldId() + "']";
            }

            public Class getTargetTypeClass() {
                return this.provider.getType(this.key);
            }

            public String getDisplayText(boolean bl) {
                String string = this.getTargetTypeDisplayName();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                if (!bl) {
                    stringBuffer.append("<font color=\"gray\">");
                }
                stringBuffer.append(bundle.getMessage("key"));
                stringBuffer.append(" ");
                if (bl) {
                    stringBuffer.append("<b>");
                }
                stringBuffer.append(this.key.getDisplayName());
                if (bl) {
                    stringBuffer.append("</b>");
                }
                stringBuffer.append(" &nbsp; <font size=\"-1\"><i>");
                stringBuffer.append(string);
                stringBuffer.append("</i></font>");
                if (!bl) {
                    stringBuffer.append("</font>");
                }
                stringBuffer.append("</html>");
                return stringBuffer.toString();
            }
        }
    }
}

