/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.propertyeditors.domains.EditableDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class EditElementDialog
extends JPanel {
    static ResourceBundle bundle = ResourceBundle.getBundle(EditElementDialog.class.getPackage().getName() + ".Bundle");
    private Element element;
    private EditableDomain domain;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JLabel labelLabel;
    private JTextField labelTextField;
    private JButton okButton;
    private JCheckBox valueCheckBox;
    private JLabel valueLabel;
    private JTextField valueTextField;
    private JDialog dialog;

    EditElementDialog(EditableDomain editableDomain) {
        this(null, editableDomain);
    }

    EditElementDialog(Element element, EditableDomain editableDomain) {
        this.element = element;
        this.domain = editableDomain;
        this.initComponents();
    }

    private void initComponents() {
        this.labelLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.labelTextField = new JTextField();
        if (this.element != null) {
            this.labelTextField.setText(this.element.getLabel());
        }
        this.labelTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                EditElementDialog.this.labelTextFieldUpdated();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditElementDialog.this.labelTextFieldUpdated();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                EditElementDialog.this.labelTextFieldUpdated();
            }
        });
        this.valueTextField = new JTextField();
        if (this.element != null) {
            this.valueTextField.setText(this.element.getValue().toString());
        }
        this.valueCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.labelLabel.setText(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.value"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.labelLabel, gridBagConstraints);
        this.valueLabel.setText(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.labelTextField.setColumns(24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.labelTextField, gridBagConstraints);
        this.valueTextField.setColumns(24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.valueTextField, gridBagConstraints);
        this.valueCheckBox.setText(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.same"));
        this.valueCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.valueCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.valueCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditElementDialog.this.valueCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.valueCheckBox, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2, 6, 6));
        this.okButton.setText(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.ok"));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditElementDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText(ResourceBundle.getBundle("org.netbeans.modules.visualweb.propertyeditors.Bundle").getString("EditElementDialog.cancel"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditElementDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void valueCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.valueCheckBox) {
            if (this.valueCheckBox.getModel().isSelected()) {
                this.valueTextField.setEnabled(false);
                this.valueTextField.setText(this.labelTextField.getText());
            } else {
                this.valueTextField.setEnabled(true);
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.element = null;
        this.dialog.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.labelTextField.getText().trim();
        String string2 = this.valueTextField.getText().trim();
        if (string2.length() == 0) {
            this.element = null;
            String string3 = bundle.getString("EditElementDialog.emptyValueError");
            JOptionPane.showMessageDialog(this.dialog, string3);
        } else {
            this.element = new Element((Object)string2, string);
            this.dialog.setVisible(false);
        }
    }

    private void labelTextFieldUpdated() {
        if (this.valueCheckBox.getModel().isSelected()) {
            this.valueTextField.setText(this.labelTextField.getText());
        }
    }

    public Element showDialog(JPanel jPanel) {
        String string = this.domain.getDisplayName();
        String string2 = string == null ? bundle.getString("EditElementDialog.title.default") : MessageFormat.format(bundle.getString("EditElementDialog.title"), string);
        this.dialog = new JDialog((Dialog)jPanel.getRootPane().getParent(), string2, true);
        this.valueCheckBox.getModel().setSelected(true);
        this.valueTextField.setEnabled(false);
        if (this.element != null) {
            String string3 = this.element.getLabel();
            String string4 = this.element.getValue().toString();
            this.labelTextField.setText(string3);
            this.valueTextField.setText(string4);
            if (!string3.equals(string4)) {
                this.valueCheckBox.getModel().setSelected(false);
                this.valueTextField.setEnabled(true);
            }
        }
        this.dialog.setContentPane(this);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog);
        this.labelTextField.requestFocusInWindow();
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        return this.element;
    }
}

