/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.netbeans.modules.visualweb.propertyeditors.IllegalTextArgumentException;
import org.netbeans.modules.visualweb.propertyeditors.PropertyEditorBase;
import org.openide.util.NbBundle;

public class DatePropertyEditor
extends PropertyEditorBase {
    public static final String DATE_FORMAT_PATTERN = "dateFormatPattern";

    private DateFormat getDateFormat() {
        DesignProperty designProperty = this.getDesignProperty().getDesignBean().getProperty(DATE_FORMAT_PATTERN);
        Object object = designProperty.getValue();
        if (object instanceof String) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object);
            return simpleDateFormat;
        }
        return DateFormat.getDateInstance(3);
    }

    public String getAsText() {
        Date date = (Date)this.getValue();
        if (date != null) {
            return this.getDateFormat().format(date);
        }
        return "";
    }

    public void setAsText(String string) {
        if (string.trim().length() == 0) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.getDateFormat().parse(string));
        }
        catch (ParseException parseException) {
            String string2 = NbBundle.getMessage(DatePropertyEditor.class, (String)"DatePropertyEditor.formatErrorMessage", (Object[])new String[]{string});
            throw new IllegalTextArgumentException(MessageFormat.format(string2, string), parseException);
        }
    }

    public String getJavaInitializationString() {
        Date date = (Date)this.getValue();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return "(new java.util.GregorianCalendar(" + gregorianCalendar.get(1) + ", " + gregorianCalendar.get(2) + ", " + gregorianCalendar.get(5) + ")).getTime()";
    }
}

