/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class NewReferenceDataItemDialog
extends JPanel
implements DocumentListener,
UndoableEditListener,
ActionListener {
    protected JButton cancelButton;
    protected JDialog dialog;
    protected JTextField nameTextField;
    protected JButton okButton;
    protected CompositeReferenceData referenceData;
    protected JCheckBox sameCheckBox;
    protected JTextField valueTextField;
    protected ReferenceDataItem newItem;

    public NewReferenceDataItemDialog(CompositeReferenceData compositeReferenceData) {
        this.referenceData = compositeReferenceData;
        this.initializeComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sameCheckBox) {
            if (this.isValueSameAsName()) {
                this.valueTextField.setEditable(false);
            } else {
                this.valueTextField.setEditable(true);
                this.valueTextField.selectAll();
                this.valueTextField.requestFocusInWindow();
            }
            this.handleNameTextChanged();
        } else if (object == this.okButton) {
            this.handleOkButton();
        } else if (object == this.cancelButton && this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.nameTextField.getDocument()) {
            this.handleNameTextChanged();
        } else if (documentEvent.getDocument() == this.valueTextField.getDocument()) {
            this.handleValueTextChanged();
        }
    }

    protected void addDialogButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        this.okButton = new JButton(BundleHolder.bundle.getMessage("OK"));
        this.okButton.addActionListener(this);
        jPanel.add(this.okButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.cancelButton = new JButton(BundleHolder.bundle.getMessage("Cancel"));
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void handleNameTextChanged() {
        if (this.isValueSameAsName()) {
            this.valueTextField.setText(this.nameTextField.getText());
        }
    }

    public void handleValueTextChanged() {
    }

    protected void handleOkButton() {
        String string = this.nameTextField.getText().trim();
        String string2 = this.valueTextField.getText().trim();
        this.newItem = this.referenceData.getDefiner().newItem(string, string2, null, false, true);
        this.newItem.setIsRemovable(true);
        String string3 = string2.length() == 0 ? BundleHolder.bundle.getMessage("newReferenceDataItemEmptyValueError") : (this.referenceData.getItems().indexOf(this.newItem) >= 0 ? BundleHolder.bundle.getMessage("newReferenceDataItemAlreadyExistError", string2) : null);
        if (string3 == null) {
            this.referenceData.add(this.newItem);
            this.dialog.setVisible(false);
        } else {
            this.newItem = null;
            JOptionPane.showMessageDialog(this.dialog, string3);
        }
    }

    protected void initializeComponents() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(BundleHolder.bundle.getMessage("newReferenceDataItemName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField();
        this.nameTextField.setColumns(20);
        this.nameTextField.getDocument().addDocumentListener(this);
        this.nameTextField.getDocument().addUndoableEditListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        jLabel = new JLabel();
        jLabel.setText(BundleHolder.bundle.getMessage("newReferenceDataItemValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        this.valueTextField = new JTextField();
        this.valueTextField.setEditable(false);
        this.valueTextField.getDocument().addDocumentListener(this);
        this.valueTextField.getDocument().addUndoableEditListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.valueTextField, gridBagConstraints);
        this.sameCheckBox = new JCheckBox(BundleHolder.bundle.getMessage("newReferenceDataItemSameCheckbox"), true);
        this.sameCheckBox.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.sameCheckBox, gridBagConstraints);
    }

    protected boolean isValueSameAsName() {
        return this.sameCheckBox.getModel().isSelected();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.nameTextField.getDocument()) {
            this.handleNameTextChanged();
        } else if (documentEvent.getDocument() == this.valueTextField.getDocument()) {
            this.handleValueTextChanged();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.nameTextField.getDocument()) {
            this.handleNameTextChanged();
        } else if (documentEvent.getDocument() == this.valueTextField.getDocument()) {
            this.handleValueTextChanged();
        }
    }

    public ReferenceDataItem showDialog(JPanel jPanel) {
        this.addDialogButtons();
        Dialog dialog = (Dialog)jPanel.getRootPane().getParent();
        this.dialog = new JDialog(dialog, BundleHolder.bundle.getMessage("newReferenceDataItemPanelTitle", this.referenceData.getDisplayName()), true);
        this.dialog.setContentPane(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog);
        this.nameTextField.requestFocusInWindow();
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        this.cancelButton = null;
        this.okButton = null;
        return this.newItem;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (undoableEditEvent.getSource() == this.nameTextField) {
            this.handleNameTextChanged();
        } else if (undoableEditEvent.getSource() == this.valueTextField) {
            this.handleValueTextChanged();
        }
    }
}

