/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std;

import com.sun.jsfcl.std.RaveStringEditor;
import com.sun.jsfcl.util.ComponentBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class RaveStringCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    protected static final ComponentBundle bundle = ComponentBundle.getBundle(RaveStringCustomEditor.class);
    boolean oneline = false;
    String instructions = null;
    private JScrollPane textAreaScroll;
    private JTextComponent textArea;
    protected boolean ignoreCrs;
    protected RaveStringEditor propertyEditor;

    RaveStringCustomEditor(String string, boolean bl, boolean bl2, String string2, boolean bl3, RaveStringEditor raveStringEditor) {
        this.oneline = bl2;
        this.instructions = string2;
        this.ignoreCrs = bl3;
        this.propertyEditor = raveStringEditor;
        this.init(string, bl);
    }

    public RaveStringCustomEditor(String string, boolean bl, RaveStringEditor raveStringEditor) {
        this.propertyEditor = raveStringEditor;
        this.init(string, bl);
    }

    private void init(String string, boolean bl) {
        this.setLayout(new BorderLayout());
        if (this.oneline) {
            this.textArea = new JTextField();
            this.add((Component)this.textArea, "Center");
        } else {
            this.textAreaScroll = new JScrollPane();
            this.textArea = new JTextArea();
            this.textAreaScroll.setViewportView(this.textArea);
            this.add((Component)this.textAreaScroll, "Center");
            if (this.ignoreCrs) {
                this.textArea.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            keyEvent.consume();
                        }
                    }

                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            keyEvent.consume();
                        }
                    }

                    public void keyTyped(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            keyEvent.consume();
                        }
                    }
                });
            }
        }
        this.textArea.setEditable(bl);
        this.textArea.setText(string);
        if (this.textArea instanceof JTextArea) {
            ((JTextArea)this.textArea).setWrapStyleWord(true);
            ((JTextArea)this.textArea).setLineWrap(true);
            this.setPreferredSize(new Dimension(500, 300));
            if (!bl) {
                JTextField jTextField = new JTextField();
                jTextField.setEditable(false);
                this.textArea.setBackground(jTextField.getBackground());
                this.textArea.setForeground(jTextField.getForeground());
            }
        } else {
            this.textArea.setMinimumSize(new Dimension(100, 20));
        }
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.textArea.getAccessibleContext().setAccessibleName(bundle.getMessage("ACS_TextArea"));
        if (this.instructions == null) {
            this.textArea.getAccessibleContext().setAccessibleDescription(bundle.getMessage("ACSD_TextArea"));
        } else {
            this.textArea.getAccessibleContext().setAccessibleDescription(this.instructions);
        }
        this.getAccessibleContext().setAccessibleDescription("ACSD_CustomStringEditor");
        int n = this.textArea.getPreferredSize().height + 8;
        if (this.instructions != null) {
            final JTextArea jTextArea = new JTextArea(this.instructions);
            jTextArea.setEditable(false);
            Color color = UIManager.getColor("control");
            if (color != null) {
                jTextArea.setBackground(color);
            } else {
                jTextArea.setBackground(this.getBackground());
            }
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setFont(this.getFont());
            this.add(jTextArea, "North", 0);
            jTextArea.getAccessibleContext().setAccessibleName(bundle.getMessage("ACS_Instructions"));
            jTextArea.getAccessibleContext().setAccessibleDescription(bundle.getMessage("ACSD_Instructions"));
            n += jTextArea.getPreferredSize().height;
            jTextArea.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    jTextArea.setSelectionStart(0);
                    jTextArea.setSelectionEnd(jTextArea.getText().length());
                }

                public void focusLost(FocusEvent focusEvent) {
                    jTextArea.setSelectionStart(0);
                    jTextArea.setSelectionEnd(0);
                }
            });
        }
        if (this.textArea instanceof JTextField) {
            this.setPreferredSize(new Dimension(300, n));
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.isEnabled() && this.isFocusable()) {
            this.textArea.requestFocus();
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.propertyEditor.getCustomEditorValue(this.textArea.getText());
    }
}

