/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wsdlextensions.jms.validator;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.modules.wsdlextensions.jms.validator.ConnectionUrl;
import org.netbeans.modules.wsdlextensions.jms.validator.ValidationException;

public class UrlParser
extends ConnectionUrl {
    private String mUrl;
    private boolean mParsed;
    private String mProtocol;
    private int mPort;
    private String mHost;
    private String mPath;
    private String mFile;
    private String mQuery;

    public UrlParser(String string) {
        this.mUrl = string;
    }

    private void parse() throws ValidationException {
        if (this.mParsed) {
            return;
        }
        String string = this.mUrl;
        this.mParsed = true;
        int n = string.indexOf("://");
        if (n < 0) {
            throw new ValidationException("Invalid URL [" + this.mUrl + "]: no protocol specified");
        }
        this.mProtocol = string.substring(0, n);
        if ((n = (string = string.substring(n + "://".length())).indexOf(47)) < 0) {
            n = string.indexOf(63);
        }
        String string2 = n >= 0 ? string.substring(0, n) : string;
        string = n >= 0 ? string.substring(n) : "";
        n = string2.indexOf(58);
        if (n >= 0) {
            this.mHost = string2.substring(0, n);
            String string3 = string2.substring(n + 1);
            this.mPort = string3.length() > 0 ? Integer.parseInt(string3) : -1;
        } else {
            this.mHost = string2;
            this.mPort = -1;
        }
        this.mFile = string.length() > 0 ? string.substring(0) : "";
        if (!string.startsWith("/")) {
            this.mPath = "";
        } else {
            n = string.indexOf(63);
            if (n >= 0) {
                this.mPath = string.substring(0, n);
                string = string.substring(n);
            } else {
                this.mPath = string;
                string = "";
            }
        }
        if (string.startsWith("?")) {
            this.mQuery = string.substring(1);
        }
    }

    public void setPort(int n) throws ValidationException {
        this.parse();
        this.mPort = n;
        this.mUrl = null;
    }

    public void setHost(String string) throws ValidationException {
        this.parse();
        this.mHost = string;
        this.mUrl = null;
    }

    public String toString() {
        if (this.mUrl == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.mProtocol).append("://").append(this.mHost);
            if (this.mPort != -1) {
                stringBuffer.append(":").append(this.mPort);
            }
            stringBuffer.append(this.mFile);
            this.mUrl = stringBuffer.toString();
        }
        return this.mUrl;
    }

    public String getProtocol() throws ValidationException {
        this.parse();
        return this.mProtocol;
    }

    public String getHost() throws ValidationException {
        this.parse();
        return this.mHost;
    }

    public int getPort() throws ValidationException {
        this.parse();
        return this.mPort;
    }

    public String getFile() throws ValidationException {
        this.parse();
        return this.mFile;
    }

    public String getPath() throws ValidationException {
        this.parse();
        return this.mPath;
    }

    public String getQuery() throws ValidationException {
        this.parse();
        return this.mQuery;
    }

    public void getQueryProperties(Properties properties) throws ValidationException {
        String string = this.getQuery();
        UrlParser.getQueryProperties(string, properties);
    }

    public static void getQueryProperties(String string, Properties properties) throws ValidationException {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n <= 0) {
                throw new ValidationException("Invalid pair [" + string2 + "] in query string [" + string + "]");
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            try {
                string3 = URLDecoder.decode(string3, "UTF-8");
                string4 = URLDecoder.decode(string4, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ValidationException("Invalid encoding in [" + string2 + "] in query string [" + string + "]", unsupportedEncodingException);
            }
            properties.setProperty(string3, string4);
        }
    }
}

