/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties;

import java.awt.Component;
import javax.swing.JComponent;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextAreaOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.modules.visualweb.gravy.TopComponentOperator;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.actions.HelpAction;
import org.netbeans.modules.visualweb.gravy.actions.PropertiesAction;
import org.netbeans.modules.visualweb.gravy.actions.ShowDescriptionAreaAction;
import org.netbeans.modules.visualweb.gravy.actions.SortByCategoryAction;
import org.netbeans.modules.visualweb.gravy.actions.SortByNameAction;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetTabOperator;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetToolbarOperator;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.windows.TopComponent;

public class PropertySheetOperator
extends TopComponentOperator {
    private JTableOperator _tblSheet;
    private JLabelOperator _lblDescriptionHeader;
    private JTextAreaOperator _txtDescription;
    private JButtonOperator _btHelp;
    public static final int MODE_NO_PROPERTIES = 0;
    public static final int MODE_PROPERTIES_OF_ONE_OBJECT = 1;
    public static final int MODE_PROPERTIES_OF_MULTIPLE_OBJECTS = 2;
    private static final String propertiesText = Bundle.getStringTrimmed((String)"org.openide.actions.Bundle", (String)"Properties");

    public PropertySheetOperator(JComponent jComponent) {
        super(jComponent);
    }

    public PropertySheetOperator() {
        this(PropertySheetOperator.waitPropertySheet(null, 0));
    }

    public PropertySheetOperator(int n) {
        this(n, "");
    }

    public PropertySheetOperator(int n, String string) {
        this(Bundle.getString((String)"org.netbeans.core.Bundle", (String)"CTL_FMT_GlobalProperties", (Object[])new Object[]{new Integer(n), string}));
    }

    public PropertySheetOperator(String string) {
        this(PropertySheetOperator.waitPropertySheet(string, 0));
    }

    public PropertySheetOperator(ContainerOperator containerOperator, String string) {
        super((JComponent)containerOperator.waitSubComponent((ComponentChooser)new PropertySheetSubchooser(string, containerOperator.getComparator())));
        this.copyEnvironment((Operator)containerOperator);
    }

    public PropertySheetOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public PropertySheetOperator(ContainerOperator containerOperator, int n) {
        super((JComponent)containerOperator.waitSubComponent((ComponentChooser)new PropertySheetSubchooser(), n));
        this.copyEnvironment((Operator)containerOperator);
    }

    public static PropertySheetOperator invoke() {
        new PropertiesAction().perform();
        return new PropertySheetOperator();
    }

    public JTableOperator tblSheet() {
        if (this._tblSheet == null) {
            this._tblSheet = new JTableOperator((ContainerOperator)this);
        }
        return this._tblSheet;
    }

    public JLabelOperator lblDescriptionHeader() {
        if (this._lblDescriptionHeader == null) {
            this._lblDescriptionHeader = new JLabelOperator((ContainerOperator)this);
        }
        return this._lblDescriptionHeader;
    }

    public JTextAreaOperator txtDescription() {
        if (this._txtDescription == null) {
            this._txtDescription = new JTextAreaOperator((ContainerOperator)this);
        }
        return this._txtDescription;
    }

    public JButtonOperator btHelp() {
        if (this._btHelp == null) {
            this._btHelp = new JButtonOperator((ContainerOperator)this);
        }
        return this._btHelp;
    }

    public JTabbedPaneOperator tbpPropertySheetTabbedPane() {
        throw new JemmyException("Don't use this! JTabbedPane no more used in property sheet.");
    }

    public PropertySheetTabOperator getPropertySheetTabOperator(String string) {
        return new PropertySheetTabOperator((ContainerOperator)this, string);
    }

    public PropertySheetToolbarOperator getToolbar() {
        throw new JemmyException("Don't use this! Tool bar no more used in property sheet.");
    }

    public String getDescriptionHeader() {
        return this.lblDescriptionHeader().getText();
    }

    public String getDescription() {
        return this.txtDescription().getText();
    }

    public void sortByName() {
        new SortByNameAction().perform((ComponentOperator)this);
    }

    public void sortByCategory() {
        new SortByCategoryAction().perform((ComponentOperator)this);
    }

    public void showDescriptionArea() {
        new ShowDescriptionAreaAction().perform((ComponentOperator)this);
    }

    public void help() {
        new HelpAction().performPopup((ComponentOperator)this);
    }

    public void verify() {
        this.tblSheet();
    }

    public void close() {
        boolean bl;
        if (this.getSource() instanceof TopComponent && (bl = this.runMapping(new Operator.MapBooleanAction("canClose"){

            public boolean map() {
                return ((TopComponent)PropertySheetOperator.this.getSource()).canClose(null, true);
            }
        }))) {
            super.close();
            return;
        }
        if (this.getWindow() != Util.getMainWindow().getSource()) {
            new WindowOperator(this.getWindow()).close();
        }
    }

    private static JComponent findPropertySheet(String string, int n) {
        JComponent jComponent = PropertySheetOperator.findTopComponent(null, string, n, new PropertySheetSubchooser());
        if (jComponent != null) {
            return jComponent;
        }
        return null;
    }

    private static JComponent waitPropertySheet(final String string, final int n) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return PropertySheetOperator.findPropertySheet(string, n);
                }

                public String getDescription() {
                    return "Wait PropertySheet with name=" + string + " index=" + n + " loaded";
                }
            });
            Timeouts timeouts = JemmyProperties.getCurrentTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("ComponentOperator.WaitComponentTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (JComponent)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    private static final class PropertySheetSubchooser
    implements ComponentChooser {
        private String sheetName;
        private Operator.StringComparator comparator;

        public PropertySheetSubchooser() {
        }

        public PropertySheetSubchooser(String string, Operator.StringComparator stringComparator) {
            this.sheetName = string;
            this.comparator = stringComparator;
        }

        public boolean checkComponent(Component component) {
            if (component instanceof PropertySheet) {
                if (this.sheetName == null) {
                    return true;
                }
                if (component instanceof TopComponent) {
                    String string = ((TopComponent)component).getName();
                    if (string == null) {
                        string = component.getName();
                    }
                    return this.comparator.equals(string, this.sheetName);
                }
            }
            return false;
        }

        public String getDescription() {
            return "org.openide.explorer.propertysheet.PropertySheet";
        }
    }
}

