/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.project;

import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.modules.visualweb.gravy.PageTopComponentOperator;
import org.netbeans.modules.visualweb.gravy.RaveWindowOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.designer.DesignerPaneOperator;
import org.netbeans.modules.visualweb.gravy.model.components.WebComponent;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableSource;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableTarget;
import org.netbeans.modules.visualweb.gravy.model.project.JSPFile;
import org.netbeans.modules.visualweb.gravy.model.project.JavaFile;
import org.netbeans.modules.visualweb.gravy.model.project.Project;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectEntry;
import org.netbeans.modules.visualweb.gravy.model.project.RootEntry;
import org.netbeans.modules.visualweb.gravy.model.project.SourceFolder;
import org.netbeans.modules.visualweb.gravy.model.project.WebPageFolder;
import org.netbeans.modules.visualweb.gravy.model.project.components.Component;
import org.netbeans.modules.visualweb.gravy.model.project.components.NonVisualComponent;
import org.netbeans.modules.visualweb.gravy.model.project.components.VisualComponent;
import org.netbeans.modules.visualweb.gravy.model.project.components.VisualEventHandlingComponent;
import org.netbeans.modules.visualweb.gravy.properties.SheetTableOperator;
import org.netbeans.modules.visualweb.gravy.toolbox.PaletteContainerOperator;

public class WebPage
extends JSPFile
implements LinkableSource,
LinkableTarget {
    private static final String propID = "id";
    PageTopComponentOperator page = null;
    private JavaFile jf;
    private String sep = File.separator;

    WebPage(TreePath treePath, String string, ProjectEntry projectEntry) {
        super(treePath, string, projectEntry);
        SourceFolder sourceFolder = ((WebPageFolder)projectEntry).getSourceFolder();
        JavaFile javaFile = sourceFolder.addJavaFile(string);
        javaFile.webpage = this;
        this.jf = javaFile;
        this.webpage = this;
    }

    public JavaFile getJavaFile() {
        return this.jf;
    }

    public Component add(WebComponent webComponent) {
        return this.add(webComponent, new Point(0, 0));
    }

    public Component add(WebComponent webComponent, Point point) {
        return this.add(webComponent, point, null);
    }

    public Component add(WebComponent webComponent, Point point, String string) {
        Object object;
        this.open();
        DesignerPaneOperator designerPaneOperator = this.page.getDesigner();
        TestUtils.wait(1000);
        PaletteContainerOperator paletteContainerOperator = null;
        try {
            paletteContainerOperator = new PaletteContainerOperator(webComponent.getComponentSet().getID());
        }
        catch (Exception exception) {
            throw new JemmyException("Palette category with name " + webComponent.getComponentSet().getID() + " can't be found!", (Throwable)exception);
        }
        TestUtils.wait(2000);
        try {
            paletteContainerOperator.addComponent(webComponent.getID(), designerPaneOperator, point);
        }
        catch (Exception exception) {
            throw new JemmyException("Component " + webComponent.getID() + " can't be added!", (Throwable)exception);
        }
        TestUtils.wait(2000);
        try {
            object = new SheetTableOperator();
            if (string == null) {
                string = object.getValue(propID);
            } else {
                object.setTextValue(propID, string);
            }
        }
        catch (Exception exception) {
            throw new JemmyException("Name for component " + webComponent.getID() + " can't be set!", (Throwable)exception);
        }
        if (webComponent.isVisual()) {
            object = webComponent.isEventHadling() ? new VisualEventHandlingComponent(webComponent, string) : new VisualComponent(webComponent, string);
            ((VisualComponent)object).setCoordinates(point);
        } else {
            object = new NonVisualComponent(webComponent, string);
        }
        ((Component)object).Page = this;
        this.childList.add(object);
        return object;
    }

    public Component[] getComponents() {
        return this.childList.toArray(new Component[this.childList.size()]);
    }

    public Component getComponent(int n) {
        return (Component)this.childList.get(n);
    }

    public Component getComponent(Component component, int n) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.childList.size(); ++i) {
            if (!((Component)this.childList.get(i)).getType().equals(component.getType())) continue;
            arrayList.add(this.childList.get(i));
        }
        return (Component)arrayList.get(n);
    }

    public Component getComponent(String string) {
        return null;
    }

    public String getLinkableSourceName() {
        String string = this.getTreePath().toString();
        if (string.indexOf("|", string.indexOf("|") + 1) == -1) {
            return this.getName() + ".jsp";
        }
        string = string.substring(string.indexOf("|", string.indexOf("|") + 1) + 1, string.length() - 1).replace('|', '/');
        return string + "/" + this.getName() + ".jsp";
    }

    public String getLinkableTargetName() {
        String string = this.getTreePath().toString();
        if (string.indexOf("|", string.indexOf("|") + 1) == -1) {
            return this.getName() + ".jsp";
        }
        string = string.substring(string.indexOf("|", string.indexOf("|") + 1) + 1, string.length() - 1).replace('|', '/');
        return string + "/" + this.getName() + ".jsp";
    }

    private Project getProject() {
        ProjectEntry projectEntry = this;
        while (!((projectEntry = projectEntry.getParent()) instanceof RootEntry)) {
        }
        return ((RootEntry)projectEntry).getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        block10: {
            long l = 0L;
            String string = this.getTreePath().toString();
            int n = string.indexOf(RootEntry.webPagesName) + RootEntry.webPagesName.length() + 1;
            String string2 = n != string.length() ? (string.substring(n, string.length() - 1) + "|" + this.name + ".jsp").replace('|', File.separatorChar) : this.name + ".jsp";
            String string3 = this.getProject().getLocation() + this.getProject().getName() + this.sep + "web" + this.sep;
            string2 = string3 + string2;
            try {
                l = RaveWindowOperator.getDefaultRave().getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout");
                RaveWindowOperator.getDefaultRave().getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", 5000L);
                if (this.page == null) {
                    int n2 = 0;
                    while (!((String)(this.page = new PageTopComponentOperator(this.getName(), n2++)).getDump().get("Tooltip text")).equals(string2)) {
                    }
                    break block10;
                }
                try {
                    this.page.makeComponentVisible();
                }
                catch (Exception exception) {
                    throw new TimeoutExpiredException("");
                }
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                int n3 = 0;
                super.open();
                while (!((String)(this.page = new PageTopComponentOperator(this.getName(), n3++)).getDump().get("Tooltip text")).equals(string2)) {
                }
            }
            finally {
                RaveWindowOperator.getDefaultRave().getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", l);
            }
        }
        this.page.getDesigner();
    }

    public void close() {
        this.open();
        TestUtils.wait(500);
        this.page.close();
    }
}

