/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.project;

import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkManager;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectDescriptor;
import org.netbeans.modules.visualweb.gravy.model.project.RootEntry;

public abstract class Project {
    private static final String bundle = "org.netbeans.modules.visualweb.gravy.model.project.Bundle";
    private static final String popupClose = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "NBProjectsBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "CloseProjectPopupItem"));
    private static final String popupRun = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "WebProjectsBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "RunProjectPopupItem"));
    private static final String STR_NO_VIEW = "<No View Available>";
    private static final String STR_MAIN = " [Main]";
    private ProjectDescriptor prjDescriptor;
    protected RootEntry root;
    private LinkManager linkMng;

    public Project(ProjectDescriptor projectDescriptor) {
        this.setDescriptor(projectDescriptor);
        this.root = new RootEntry(this);
    }

    public RootEntry getRoot() {
        return this.root;
    }

    public LinkManager getLinkManager() {
        if (this.linkMng == null) {
            this.linkMng = new LinkManager(this);
            return this.linkMng;
        }
        return this.linkMng;
    }

    public void rename(String string) {
        String string2 = this.prjDescriptor.getProperty("projectName");
        if (!string2.equals(string)) {
            this.setName(string);
        }
    }

    public void close() {
        try {
            new ProjectNavigatorOperator();
            ProjectNavigatorOperator.pressPopupItemOnNode(this.getName(), popupClose);
        }
        catch (Exception exception) {
            throw new JemmyException("Project can't be closed!", (Throwable)exception);
        }
    }

    public void run() {
        try {
            new ProjectNavigatorOperator();
            ProjectNavigatorOperator.pressPopupItemOnNode(this.getName(), popupRun);
            TestUtils.wait(2000);
            String[] stringArray = new String[]{this.getName() + STR_MAIN, STR_NO_VIEW, ""};
            this.waitLabelString(1, stringArray);
        }
        catch (Exception exception) {
            throw new JemmyException("Project can't be run!", (Throwable)exception);
        }
        TestUtils.wait(3000);
    }

    private void waitLabelString(int n, String string) {
        String[] stringArray = new String[]{string};
        this.waitLabelString(n, stringArray);
    }

    private void waitLabelString(int n, String[] stringArray) {
        JLabelOperator jLabelOperator = new JLabelOperator((ContainerOperator)Util.getMainWindow(), n);
        boolean bl = false;
        block0: do {
            jLabelOperator = new JLabelOperator((ContainerOperator)Util.getMainWindow(), n);
            TestUtils.wait(1000);
            String string = jLabelOperator.getText();
            for (int i = 0; i < stringArray.length; ++i) {
                if (string == null || !string.equals(stringArray[i])) continue;
                bl = true;
                continue block0;
            }
        } while (!bl);
    }

    private void waitLabelStringDisappear(int n, String string) {
        JLabelOperator jLabelOperator = new JLabelOperator((ContainerOperator)Util.getMainWindow(), n);
        while (jLabelOperator.getText() == null || !jLabelOperator.getText().equals(string)) {
            jLabelOperator = new JLabelOperator((ContainerOperator)Util.getMainWindow(), n);
            TestUtils.wait(1000);
        }
        while (jLabelOperator.getText() != null && jLabelOperator.getText().equals(string)) {
            jLabelOperator = new JLabelOperator((ContainerOperator)Util.getMainWindow(), n);
            TestUtils.wait(1000);
        }
    }

    public void saveAll() {
    }

    public ProjectDescriptor getDescriptor() {
        return this.prjDescriptor;
    }

    private void setDescriptor(ProjectDescriptor projectDescriptor) {
        this.prjDescriptor = projectDescriptor;
    }

    public String getName() {
        return this.prjDescriptor.getProperty("projectName");
    }

    private void setName(String string) {
        String string2 = this.prjDescriptor.getProperty("projectLocation");
        this.prjDescriptor = new ProjectDescriptor(string, string2);
    }

    public String getLocation() {
        return this.prjDescriptor.getProperty("projectLocation");
    }

    private void setLocation(String string) {
        String string2 = this.prjDescriptor.getProperty("projectName");
        this.prjDescriptor = new ProjectDescriptor(string2, string);
    }

    public abstract Project saveAs(String var1);

    public abstract Project saveAs(String var1, String var2);
}

