/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.AWTEvent;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.EventDispatcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.DefaultVisualizer;
import org.netbeans.jemmy.util.NameComponentChooser;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.visualweb.gravy.MainWindowOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.openide.actions.SaveAllAction;

public class Util {
    public static final String WINDOWS_OS_FAMILY_NAME = "Windows";
    public static final String LINUX_OS_FAMILY_NAME = "Linux";
    public static final String SUN_OS_FAMILY_NAME = "SunOS";
    public static final String MAC_OS_FAMILY_NAME = "Mac";
    static MainWindowOperator mainWindow;
    static JMenuBarOperator mainMenu;

    public static double getDelayScale() {
        String string = System.getProperty("Env-RaveTestsDelayScale", "1");
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 1.0;
        }
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindowsOS() {
        String string = Util.getOperatingSystemName();
        return string.toUpperCase().indexOf(WINDOWS_OS_FAMILY_NAME.toUpperCase()) > -1;
    }

    public static boolean isSunOS() {
        String string = Util.getOperatingSystemName();
        return string.toUpperCase().indexOf(SUN_OS_FAMILY_NAME.toUpperCase()) > -1;
    }

    public static boolean isMacOS() {
        String string = Util.getOperatingSystemName();
        return string.toUpperCase().indexOf(MAC_OS_FAMILY_NAME.toUpperCase()) > -1;
    }

    public static MainWindowOperator getMainWindow() {
        if (mainWindow == null) {
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)new DefaultVisualizer());
            mainWindow = new MainWindowOperator();
        }
        return mainWindow;
    }

    public static JMenuBarOperator getMainMenu() {
        if (mainMenu == null) {
            mainMenu = new JMenuBarOperator((ContainerOperator)Util.getMainWindow());
        }
        return mainMenu;
    }

    public static JTabbedPaneOperator getMainTab() {
        return new JTabbedPaneOperator(new ContainerOperator((ContainerOperator)Util.getMainWindow(), (ComponentChooser)new NameComponentChooser("mainTab")));
    }

    public static void selectTab(String string) {
        new TopComponentOperator(string);
    }

    public static String generateTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        return "" + calendar.get(1) + calendar.get(2) + calendar.get(5) + calendar.get(11) + calendar.get(12) + calendar.get(13);
    }

    public static void closeWindow() {
        new Action(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/Window").substring(1) + "|" + Bundle.getStringTrimmed((String)"org.netbeans.core.windows.actions.Bundle", (String)"LBL_CloseWindowAction"), null).performMenu();
    }

    public static void saveAll() {
        JMenuItemOperator jMenuItemOperator = Util.getMainMenu().showMenuItem(new String[]{"File", "Save All"});
        if (jMenuItemOperator.isEnabled()) {
            Util.getMainMenu().pushMenu(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + "|" + Bundle.getStringTrimmed((String)"com.sun.rave.gravy.project.actions.Bundle", (String)"LBL_SaveAllAction"));
        }
    }

    public static void saveAllAPICall() {
        ((SaveAllAction)SaveAllAction.findObject(SaveAllAction.class, (boolean)true)).performAction();
    }

    public static long getExecutionTime() {
        String string = System.getProperty("xtest.ide.execution.time");
        if (string != null) {
            System.out.println("Property = " + string);
            int[] nArray = new int[6];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            for (int i = 0; i < 6; ++i) {
                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
            long l = calendar.getTimeInMillis();
            System.out.print("Execution time: " + calendar.toString());
            System.out.println(" = " + l);
            return l;
        }
        throw new RuntimeException("xtest.ide.execution.time property is empty");
    }

    public static long getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis();
        System.out.print("Current time: " + calendar.toString());
        System.out.println(" = " + l);
        return l;
    }

    public static void savePerformanceData(NbTestCase nbTestCase, String string, long l, long l2) {
        System.out.println("Time diff is " + (l2 - l));
        System.out.println("Saving it into " + nbTestCase.getName() + ".perfdata");
        nbTestCase.getLog(nbTestCase.getName() + ".perfdata").print(nbTestCase.getName() + "." + string + " = ");
        nbTestCase.getLog(nbTestCase.getName() + ".perfdata").println(l2 - l);
    }

    public static void savePerformanceData(NbTestCase nbTestCase, String string, long l) {
        Util.savePerformanceData(nbTestCase, string, l, Util.getCurrentTime());
    }

    public static void wait(int n) {
        n = new Double((double)n * Util.getDelayScale()).intValue();
        System.out.println("Delay scale() = " + Util.getDelayScale());
        System.out.println("Sleep to " + n / 1000 + " seconds");
        EventDispatcher.waitQueueEmpty();
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventDispatcher.waitQueueEmpty();
    }

    public static void waitKeyboardEvent() {
        Util.waitKeyboardEvent(1200000L);
    }

    public static void waitKeyboardEvent(long l) {
        String string = System.getProperty("interactive.test.mode");
        if (string == null || !string.equalsIgnoreCase("Yes")) {
            return;
        }
        Waiter waiter = Util.getKeyboardEventWaiter();
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", l);
        try {
            waiter.waitAction(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Waiter getKeyboardEventWaiter() {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                AWTEvent aWTEvent = null;
                try {
                    aWTEvent = EventTool.getLastEvent();
                }
                catch (Exception exception) {
                    TestUtils.outMsg("+++ Exception was thrown = " + exception.getMessage());
                    exception.printStackTrace();
                    return exception.getMessage();
                }
                Util.wait(1000);
                new QueueTool().waitEmpty();
                if (aWTEvent.getID() == 402) {
                    TestUtils.outMsg("+++ Key was pressed");
                    return "Key was pressed";
                }
                return null;
            }

            public String getDescription() {
                return "Waiting for key press...";
            }
        });
        return waiter;
    }
}

