/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ComponentOperator;

public class Flasher
implements Timeoutable {
    public static final Color DEFAULT_COLOR = new Color(255, 0, 0);
    protected static final int len = 30;
    protected Color color = DEFAULT_COLOR;
    protected static long WAIT_TIME = 1000L;
    protected boolean separateThread = false;
    protected Timeouts timeouts;

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public Flasher() {
        this(false);
    }

    public Flasher(boolean bl) {
        this.separateThread = bl;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void flash(ComponentOperator componentOperator, Point point) {
        this.flash(componentOperator.getSource(), point);
    }

    public void flash(ComponentOperator componentOperator, int n, int n2) {
        this.flash(componentOperator.getSource(), n, n2);
    }

    public void flash(Component component, int n, int n2) {
        this.flash(component, new Point(n, n2));
    }

    public void flash(final Component component, final Point point) {
        if (this.separateThread) {
            new Thread(new Runnable(){

                public void run() {
                    Flasher.this.doFlash(component, point);
                }
            }).start();
        } else {
            this.doFlash(component, point);
        }
    }

    protected void doFlash(Component component, Point point) {
        JLayeredPane jLayeredPane = null;
        if (component instanceof JDialog) {
            jLayeredPane = ((JDialog)component).getLayeredPane();
        } else if (component instanceof JFrame) {
            jLayeredPane = ((JFrame)component).getLayeredPane();
        } else {
            JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, component);
            if (jDialog != null) {
                jLayeredPane = jDialog.getLayeredPane();
            } else {
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, component);
                if (jFrame != null) {
                    jLayeredPane = jFrame.getLayeredPane();
                } else {
                    throw new JemmyException("Containing dialog or frame not found");
                }
            }
        }
        Point point2 = new Point(point.x + component.getLocationOnScreen().x - jLayeredPane.getLocationOnScreen().x, point.y + component.getLocationOnScreen().y - jLayeredPane.getLocationOnScreen().y);
        FlashPane flashPane = new FlashPane(point2, jLayeredPane.getSize());
        jLayeredPane.add((Component)flashPane, JLayeredPane.DRAG_LAYER);
        jLayeredPane.repaint();
        try {
            Thread.currentThread();
            Thread.sleep(this.timeouts.getTimeout("Flasher.FlashTimeout"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        jLayeredPane.remove(flashPane);
        jLayeredPane.repaint();
    }

    static {
        Timeouts.initDefault((String)"Flasher.FlashTimeout", (long)WAIT_TIME);
    }

    protected class FlashPane
    extends JPanel {
        private Point p;

        public FlashPane(Point point, Dimension dimension) {
            this.p = point;
            this.setSize(dimension);
            this.setOpaque(false);
        }

        public synchronized void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Flasher.this.color);
            graphics.drawLine(this.p.x - 30, this.p.y, this.p.x + 30, this.p.y);
            graphics.drawLine(this.p.x, this.p.y - 30, this.p.x, this.p.y + 30);
        }
    }
}

