/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import com.sun.rave.designtime.DesignBean;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.TestUtils;

public class DocumentOutlineOperator
extends JComponentOperator {
    private JTreeOperator structureTree;

    public DocumentOutlineOperator(ContainerOperator containerOperator) {
        super(containerOperator, (ComponentChooser)new DocumentOutlineChooser());
    }

    public void verify() {
        this.getStructTreeOperator();
    }

    public TreePath findPath(String string) {
        this.verify();
        return this.structureTree.findPath(string);
    }

    public TreePath findPath(String string, int[] nArray, Operator.StringComparator stringComparator) {
        this.verify();
        String[] stringArray = new Operator.DefaultPathParser("|").parse(string);
        if (nArray == null) {
            nArray = new int[stringArray.length];
        }
        System.out.println("+++ DocumentOutlineOperator.findPath(...): nodeNames = " + Arrays.asList(stringArray));
        System.out.print("+++ DocumentOutlineOperator.findPath(...): nodeIndexes = [");
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print(nArray[i] + (i < nArray.length - 1 ? ", " : ""));
        }
        System.out.println("]");
        TreePath treePath = this.structureTree.findPath(stringArray, nArray, stringComparator);
        return treePath;
    }

    public void clickOnPath(String string) {
        this.structureTree.clickOnPath(this.findPath(string));
    }

    public void expandPath(String string) {
        this.structureTree.expandPath(this.findPath(string));
    }

    public void selectPath(String string) {
        this.structureTree.selectPath(this.findPath(string));
    }

    public void clickForPopup(int n) {
        this.verify();
        this.structureTree.clickForPopup(n);
    }

    public JTreeOperator getStructTreeOperator() {
        if (this.structureTree == null) {
            this.structureTree = new JTreeOperator((ContainerOperator)this);
        }
        return this.structureTree;
    }

    public void pressButton(String string) {
        new JButtonOperator((ContainerOperator)this, string).pushNoBlock();
    }

    private DesignBean findChild(DesignBean designBean, String string) {
        if (designBean.getInstanceName().equals(string)) {
            return designBean;
        }
        for (int i = 0; i < designBean.getChildBeanCount(); ++i) {
            DesignBean designBean2 = this.findChild(designBean.getChildBean(i), string);
            if (designBean2 == null) continue;
            return designBean2;
        }
        return null;
    }

    public boolean selectComponent(String string) {
        DesignBean[] designBeanArray = null;
        Object object = this.structureTree.getChildren(this.structureTree.getRoot())[0];
        for (int i = 0; i < this.structureTree.getChildCount(object); ++i) {
            DesignBean designBean = (DesignBean)this.structureTree.getChildren(object)[i];
            DesignBean designBean2 = this.findChild(designBean, string);
            if (designBean2 == null) continue;
            designBeanArray = new DesignBean[]{designBean2};
            break;
        }
        if (designBeanArray != null) {
            TestUtils.wait(500);
            return true;
        }
        return false;
    }

    public void openPage(String string) {
        new JButtonOperator((ContainerOperator)this, string).clickForPopup();
        new JPopupMenuOperator().pushMenu(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.outline.Bundle", "Open"));
    }

    public void openPageSource(String string) {
        new JButtonOperator((ContainerOperator)this, string).clickForPopup();
        new JPopupMenuOperator().pushMenu(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.outline.Bundle", "ViewBF", new String[]{string}));
    }

    public static class DocumentOutlineChooser
    implements ComponentChooser {
        public boolean checkComponent(Component component) {
            return component.getClass().getName().equalsIgnoreCase("org.netbeans.modules.visualweb.outline.OutlinePanel");
        }

        public String getDescription() {
            return "Document Outline Operator";
        }
    }
}

