/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.lexer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexUtilities {
    private static final Set<TokenId> END_PAIRS = new HashSet<TokenId>();
    private static final Set<TokenId> INDENT_WORDS = new HashSet<TokenId>();

    private LexUtilities() {
    }

    public static OffsetRange getLexerOffsets(CompilationInfo compilationInfo, OffsetRange offsetRange) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-groovy", 0);
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            int n = offsetRange.getStart();
            int n2 = translatedSource.getLexicalOffset(n);
            if (n2 == n) {
                return offsetRange;
            }
            if (n2 == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(n2, n2 + offsetRange.getLength());
        }
        return offsetRange;
    }

    public static TokenSequence<? extends GroovyTokenId> getGroovyTokenSequence(BaseDocument baseDocument, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        return LexUtilities.getGroovyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
    }

    private static TokenSequence<? extends GroovyTokenId> findRhtmlDelimited(TokenSequence tokenSequence, int n) {
        if (tokenSequence.language().mimeType().equals("text/x-gsp")) {
            TokenSequence tokenSequence2;
            tokenSequence.move(n);
            if (tokenSequence.moveNext() && tokenSequence.token() != null && "groovy-delimiter".equals(tokenSequence.token().id().primaryCategory()) && tokenSequence.moveNext() && tokenSequence.token() != null && "groovy".equals(tokenSequence.token().id().primaryCategory()) && (tokenSequence2 = tokenSequence.embedded()) != null) {
                return tokenSequence2;
            }
        }
        return null;
    }

    public static TokenSequence<? extends GroovyTokenId> getGroovyTokenSequence(TokenHierarchy<Document> tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(GroovyTokenId.language());
        if (tokenSequence == null) {
            TokenSequence<? extends GroovyTokenId> tokenSequence2;
            List list = tokenHierarchy.embeddedTokenSequences(n, true);
            for (TokenSequence tokenSequence3 : list) {
                if (tokenSequence3.language() == GroovyTokenId.language()) {
                    tokenSequence = tokenSequence3;
                    break;
                }
                tokenSequence2 = LexUtilities.findRhtmlDelimited(tokenSequence3, n);
                if (tokenSequence2 == null) continue;
                return tokenSequence2;
            }
            if (tokenSequence == null) {
                list = tokenHierarchy.embeddedTokenSequences(n, false);
                for (TokenSequence tokenSequence3 : list) {
                    if (tokenSequence3.language() == GroovyTokenId.language()) {
                        tokenSequence = tokenSequence3;
                        break;
                    }
                    tokenSequence2 = LexUtilities.findRhtmlDelimited(tokenSequence3, n);
                    if (tokenSequence2 == null) continue;
                    return tokenSequence2;
                }
            }
        }
        return tokenSequence;
    }

    public static TokenSequence<? extends GroovyTokenId> getPositionedSequence(BaseDocument baseDocument, int n) {
        return LexUtilities.getPositionedSequence(baseDocument, n, true);
    }

    public static TokenSequence<? extends GroovyTokenId> getPositionedSequence(BaseDocument baseDocument, int n, boolean bl) {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            try {
                tokenSequence.move(n);
            }
            catch (AssertionError assertionError) {
                DataObject dataObject = (DataObject)baseDocument.getProperty((Object)"stream");
                if (dataObject != null) {
                    Exceptions.attachMessage((Throwable)((Object)assertionError), (String)FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()));
                }
                throw assertionError;
            }
            if (!bl && !tokenSequence.moveNext()) {
                return null;
            }
            if (bl && !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            return tokenSequence;
        }
        return null;
    }

    public static Token<? extends GroovyTokenId> getToken(BaseDocument baseDocument, int n) {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            try {
                tokenSequence.move(n);
            }
            catch (AssertionError assertionError) {
                DataObject dataObject = (DataObject)baseDocument.getProperty((Object)"stream");
                if (dataObject != null) {
                    Exceptions.attachMessage((Throwable)((Object)assertionError), (String)FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()));
                }
                throw assertionError;
            }
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            Token token = tokenSequence.token();
            return token;
        }
        return null;
    }

    public static char getTokenChar(BaseDocument baseDocument, int n) {
        String string;
        Token<? extends GroovyTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token != null && (string = ((Object)token.text()).toString()).length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public static OffsetRange findHeredocEnd(TokenSequence<? extends GroovyTokenId> tokenSequence, Token<? extends GroovyTokenId> token) {
        String string = ((Object)token.text()).toString();
        assert (string.startsWith("<<"));
        if ((string = string.substring(2)).startsWith("-")) {
            string = string.substring(1);
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(0, string.length() - 2);
        }
        String string2 = string + "\n";
        while (tokenSequence.moveNext()) {
            String string3;
            Token token2 = tokenSequence.token();
            TokenId tokenId = token2.id();
            if (tokenId != GroovyTokenId.STRING_END && tokenId != GroovyTokenId.QUOTED_STRING_END || !string.equals(string3 = ((Object)token2.text()).toString()) && !string2.equals(string3)) continue;
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token2.length());
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findHeredocBegin(TokenSequence<? extends GroovyTokenId> tokenSequence, Token<? extends GroovyTokenId> token) {
        String string = ((Object)token.text()).toString();
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = "\"" + string + "\"";
        String string3 = "'" + string + "'";
        while (tokenSequence.movePrevious()) {
            Token token2 = tokenSequence.token();
            TokenId tokenId = token2.id();
            if (tokenId != GroovyTokenId.STRING_BEGIN && tokenId != GroovyTokenId.QUOTED_STRING_BEGIN) continue;
            String string4 = ((Object)token2.text()).toString();
            String string5 = null;
            if (string4.startsWith("<<-")) {
                string5 = string4.substring(3);
            } else if (string4.startsWith("<<")) {
                string5 = string4.substring(2);
            }
            if (string5 == null || !string.equals(string5) && !string2.equals(string5) && !string3.equals(string5)) continue;
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token2.length());
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findFwd(BaseDocument baseDocument, TokenSequence<? extends GroovyTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            if (n == 0) {
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument baseDocument, TokenSequence<? extends GroovyTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                if (n == 0) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBegin(BaseDocument baseDocument, TokenSequence<? extends GroovyTokenId> tokenSequence) {
        int n = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (LexUtilities.isBeginToken(tokenId, baseDocument, tokenSequence)) {
                if (n == 0) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                --n;
                continue;
            }
            if (tokenId != GroovyTokenId.RBRACE) continue;
            ++n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findEnd(BaseDocument baseDocument, TokenSequence<? extends GroovyTokenId> tokenSequence) {
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (LexUtilities.isBeginToken(tokenId, baseDocument, tokenSequence)) {
                --n;
                continue;
            }
            if (tokenId != GroovyTokenId.RBRACE) continue;
            if (n == 0) {
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            ++n;
        }
        return OffsetRange.NONE;
    }

    public static boolean isEndmatchingDo(BaseDocument baseDocument, int n) {
        try {
            TokenId tokenId;
            Token<? extends GroovyTokenId> token;
            int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            if (n2 != -1 && (token = LexUtilities.getToken(baseDocument, n2)) != null && ((tokenId = token.id()) == GroovyTokenId.LITERAL_while || tokenId == GroovyTokenId.LITERAL_for)) {
                return false;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return true;
    }

    public static boolean isBeginToken(TokenId tokenId, BaseDocument baseDocument, int n) {
        return END_PAIRS.contains(tokenId);
    }

    public static boolean isBeginToken(TokenId tokenId, BaseDocument baseDocument, TokenSequence<? extends GroovyTokenId> tokenSequence) {
        return END_PAIRS.contains(tokenId);
    }

    public static boolean isIndentToken(TokenId tokenId) {
        return INDENT_WORDS.contains(tokenId);
    }

    public static int getBeginEndLineBalance(BaseDocument baseDocument, int n, boolean bl) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = bl ? n : Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n2);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n4 = 0;
            do {
                Token token;
                TokenId tokenId;
                if (LexUtilities.isBeginToken(tokenId = (token = tokenSequence.token()).id(), baseDocument, tokenSequence)) {
                    ++n4;
                    continue;
                }
                if (tokenId != GroovyTokenId.RBRACE) continue;
                --n4;
            } while (tokenSequence.moveNext() && tokenSequence.offset() <= n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getLineBalance(BaseDocument baseDocument, int n, TokenId tokenId, TokenId tokenId2) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n2);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n4 = 0;
            do {
                Token token;
                TokenId tokenId3;
                if ((tokenId3 = (token = tokenSequence.token()).id()) == tokenId) {
                    ++n4;
                    continue;
                }
                if (tokenId3 != tokenId2) continue;
                --n4;
            } while (tokenSequence.moveNext() && tokenSequence.offset() <= n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getTokenBalance(BaseDocument baseDocument, TokenId tokenId, TokenId tokenId2, int n) throws BadLocationException {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, 0);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.moveIndex(0);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        int n2 = 0;
        do {
            Token token;
            if ((token = tokenSequence.token()).id() == tokenId) {
                ++n2;
                continue;
            }
            if (token.id() != tokenId2) continue;
            --n2;
        } while (tokenSequence.moveNext());
        return n2;
    }

    public static int getLineIndent(BaseDocument baseDocument, int n) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.isRowWhite((BaseDocument)baseDocument, (int)n2) ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
            int n4 = Utilities.getVisualColumn((BaseDocument)baseDocument, (int)n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static void indent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
    }

    public static String getIndentString(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        LexUtilities.indent(stringBuilder, n);
        return stringBuilder.toString();
    }

    public static boolean isCommentOnlyLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1) {
            return false;
        }
        if (n2 == baseDocument.getLength()) {
            return false;
        }
        return false;
    }

    public static void adjustLineIndentation(BaseDocument baseDocument, int n, int n2) {
        try {
            int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n2 > 0) {
                baseDocument.remove(n3, n2);
            } else if (n2 < 0) {
                baseDocument.insertString(n2, LexUtilities.getIndentString(n2), null);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public static int setLineIndentation(BaseDocument baseDocument, int n, int n2) {
        int n3 = LexUtilities.getLineIndent(baseDocument, n);
        try {
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n4 == -1) {
                return n3;
            }
            int n5 = n3 - n2;
            if (n5 > 0) {
                String string = baseDocument.getText(n4, n5);
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isWhitespace(string.charAt(i))) continue;
                    throw new RuntimeException("Illegal indentation adjustment: Deleting non-whitespace chars: " + string);
                }
                baseDocument.remove(n4, n5);
            } else if (n5 < 0) {
                n5 = -n5;
                baseDocument.insertString(n4, LexUtilities.getIndentString(n5), null);
            }
            return n2;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return n3;
        }
    }

    public static String getStringAt(int n, TokenHierarchy<Document> tokenHierarchy) {
        Token token;
        TokenSequence tokenSequence = LexUtilities.getGroovyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return null;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            TokenId tokenId = token.id();
            if (tokenId == GroovyTokenId.EMBEDDED_GROOVY) {
                tokenSequence = tokenSequence.embedded();
                assert (tokenSequence != null);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return null;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            String string = null;
            int n2 = 0;
            while (tokenId == GroovyTokenId.ERROR || tokenId == GroovyTokenId.STRING_LITERAL || tokenId == GroovyTokenId.QUOTED_STRING_LITERAL || tokenId == GroovyTokenId.EMBEDDED_GROOVY) {
                string = ((Object)token.text()).toString();
                ++n2;
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == GroovyTokenId.STRING_BEGIN || tokenId == GroovyTokenId.QUOTED_STRING_BEGIN) {
                if (n2 == 1) {
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (tokenSequence.moveNext() && ((tokenId = (token = tokenSequence.token()).id()) == GroovyTokenId.ERROR || tokenId == GroovyTokenId.STRING_LITERAL || tokenId == GroovyTokenId.QUOTED_STRING_LITERAL || tokenId == GroovyTokenId.EMBEDDED_GROOVY)) {
                    stringBuilder.append(token.text());
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public static int getSingleQuotedStringOffset(int n, TokenHierarchy<Document> tokenHierarchy) {
        return LexUtilities.getLiteralStringOffset(n, tokenHierarchy, GroovyTokenId.STRING_BEGIN);
    }

    public static int getDoubleQuotedStringOffset(int n, TokenHierarchy<Document> tokenHierarchy) {
        return LexUtilities.getLiteralStringOffset(n, tokenHierarchy, GroovyTokenId.QUOTED_STRING_BEGIN);
    }

    public static int getRegexpOffset(int n, TokenHierarchy<Document> tokenHierarchy) {
        return LexUtilities.getLiteralStringOffset(n, tokenHierarchy, GroovyTokenId.REGEXP_BEGIN);
    }

    private static int getLiteralStringOffset(int n, TokenHierarchy<Document> tokenHierarchy, GroovyTokenId groovyTokenId) {
        Token token;
        TokenSequence tokenSequence = LexUtilities.getGroovyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            TokenId tokenId = token.id();
            if (tokenId == GroovyTokenId.EMBEDDED_GROOVY) {
                tokenSequence = tokenSequence.embedded();
                assert (tokenSequence != null);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return -1;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            while (tokenId == GroovyTokenId.ERROR || tokenId == GroovyTokenId.STRING_LITERAL || tokenId == GroovyTokenId.QUOTED_STRING_LITERAL || tokenId == GroovyTokenId.REGEXP_LITERAL || tokenId == GroovyTokenId.EMBEDDED_GROOVY) {
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == groovyTokenId) {
                if (!tokenSequence.moveNext()) {
                    return -1;
                }
                return tokenSequence.offset();
            }
        }
        return -1;
    }

    public static boolean isInsideQuotedString(BaseDocument baseDocument, int n) {
        Token token;
        TokenId tokenId;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && ((tokenId = (token = tokenSequence.token()).id()) == GroovyTokenId.QUOTED_STRING_LITERAL || tokenId == GroovyTokenId.QUOTED_STRING_END)) {
            return true;
        }
        return tokenSequence.movePrevious() && ((tokenId = (token = tokenSequence.token()).id()) == GroovyTokenId.QUOTED_STRING_LITERAL || tokenId == GroovyTokenId.QUOTED_STRING_BEGIN);
    }

    public static boolean isInsideRegexp(BaseDocument baseDocument, int n) {
        Token token;
        TokenId tokenId;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && ((tokenId = (token = tokenSequence.token()).id()) == GroovyTokenId.REGEXP_LITERAL || tokenId == GroovyTokenId.REGEXP_END)) {
            return true;
        }
        return tokenSequence.movePrevious() && ((tokenId = (token = tokenSequence.token()).id()) == GroovyTokenId.REGEXP_LITERAL || tokenId == GroovyTokenId.REGEXP_BEGIN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OffsetRange getCommentBlock(BaseDocument baseDocument, int n) {
        int n2;
        int n3;
        int n4;
        block8: {
            try {
                Token<? extends GroovyTokenId> token = LexUtilities.getToken(baseDocument, n);
                if (token != null && token.id() == GroovyTokenId.LINE_COMMENT) {
                    n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    if (!LexUtilities.isCommentOnlyLine(baseDocument, n)) {
                        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                        int n5 = token.offset(tokenHierarchy);
                        return new OffsetRange(n5, n5 + token.length());
                    }
                    break block8;
                }
                if (token == null) return OffsetRange.NONE;
                if (token.id() != GroovyTokenId.DOCUMENTATION) return OffsetRange.NONE;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n6 = token.offset(tokenHierarchy);
                int n7 = n6 + token.length();
                return new OffsetRange(n6, n7);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return OffsetRange.NONE;
        }
        while (n4 > 0) {
            n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n4 - 1));
            if (n2 < 0 || !LexUtilities.isCommentOnlyLine(baseDocument, n2)) {
                n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4);
                break;
            }
            n4 = n2;
        }
        n2 = baseDocument.getLength();
        while (true) {
            int n8;
            if ((n8 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n3 + 1))) >= n2 || !LexUtilities.isCommentOnlyLine(baseDocument, n8)) {
                n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3) + 1;
                if (n4 >= n3) return OffsetRange.NONE;
                return new OffsetRange(n4, n3);
            }
            n3 = n8;
        }
    }

    public static int findSpaceBegin(BaseDocument baseDocument, int n) {
        int n2;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return n;
        }
        boolean bl = false;
        try {
            int n3;
            n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)Math.min(n, baseDocument.getLength()));
            int n4 = n2 - 1;
            if (n2 > 0 && (n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)(n2 - 1))) != -1 && (n3 = (int)baseDocument.getText(n4, 1).charAt(0)) == 44) {
                bl = true;
            }
            if (!bl) {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n <= n3 || n3 == -1) {
                    return n;
                }
            } else {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n4 >= 0 && (n <= n3 || n3 == -1)) {
                    return n4 + 1;
                }
                n2 = 0;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return n;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            if (n > tokenSequence.offset()) {
                return Math.max(tokenSequence.token().id() == GroovyTokenId.WHITESPACE ? tokenSequence.offset() : n, n2);
            }
            while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                if (token.id() == GroovyTokenId.WHITESPACE) continue;
                return Math.max(tokenSequence.offset() + token.length(), n2);
            }
        }
        return n;
    }

    static {
        END_PAIRS.add(GroovyTokenId.LBRACE);
        INDENT_WORDS.addAll(END_PAIRS);
        INDENT_WORDS.add(GroovyTokenId.COLON);
    }
}

