/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.hints;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.Formatter;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyRuleContext;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovySelectionRule;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditList;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintFix;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentOutRule
extends GroovySelectionRule {
    public static final Logger LOG = Logger.getLogger(CommentOutRule.class.getName());
    String bulbDesc = NbBundle.getMessage(CommentOutRule.class, (String)"CommentOutRuleDescription");

    @Override
    public void run(GroovyRuleContext groovyRuleContext, List<Hint> list) {
        CompilationInfo compilationInfo = groovyRuleContext.compilationInfo;
        int n = groovyRuleContext.selectionStart;
        int n2 = groovyRuleContext.selectionEnd;
        assert (n < n2);
        BaseDocument baseDocument = groovyRuleContext.doc;
        if (n2 > baseDocument.getLength()) {
            return;
        }
        if (n2 - n > 1000) {
            return;
        }
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        if (moduleNode == null) {
            return;
        }
        OffsetRange offsetRange = new OffsetRange(n, n2);
        list.add(this.getDescriptor(OPERATION.COMMENT_OUT, "CommentOutRuleHintDescription", groovyRuleContext, baseDocument, offsetRange));
        list.add(this.getDescriptor(OPERATION.ADD_IF, "AddIfAroundBlockHintDescription", groovyRuleContext, baseDocument, offsetRange));
    }

    Hint getDescriptor(OPERATION oPERATION, String string, GroovyRuleContext groovyRuleContext, BaseDocument baseDocument, OffsetRange offsetRange) {
        int n = 292;
        String string2 = NbBundle.getMessage(CommentOutRule.class, (String)string);
        SimpleFix simpleFix = new SimpleFix(oPERATION, string2, baseDocument, groovyRuleContext);
        ArrayList<SimpleFix> arrayList = new ArrayList<SimpleFix>(1);
        arrayList.add(simpleFix);
        Hint hint = new Hint((Rule)this, simpleFix.getDescription(), groovyRuleContext.compilationInfo.getFileObject(), offsetRange, arrayList, n);
        return hint;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return this.bulbDesc;
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class SimpleFix
    implements HintFix {
        final BaseDocument baseDoc;
        final String desc;
        final GroovyRuleContext context;
        final OPERATION operation;

        public SimpleFix(OPERATION oPERATION, String string, BaseDocument baseDocument, GroovyRuleContext groovyRuleContext) {
            this.desc = string;
            this.baseDoc = baseDocument;
            this.context = groovyRuleContext;
            this.operation = oPERATION;
        }

        public String getDescription() {
            return this.desc;
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.baseDoc);
            int n = this.context.selectionStart;
            int n2 = this.context.selectionEnd;
            JTextComponent jTextComponent = Utilities.getFocusedComponent();
            switch (this.operation) {
                case COMMENT_OUT: {
                    editList.replace(n2, 0, "*/", false, 0);
                    editList.replace(n, 0, "/*", false, 1);
                    editList.apply();
                    jTextComponent.setCaretPosition(n);
                    break;
                }
                case ADD_IF: {
                    String string = "if (true) {\n";
                    String string2 = "\n}";
                    editList.replace(n2, 0, string2, false, 0);
                    int n3 = Utilities.getRowStart((BaseDocument)this.baseDoc, (int)n);
                    editList.replace(n3, 0, string, false, 1);
                    editList.setFormatter((org.netbeans.modules.gsf.api.Formatter)new Formatter(), true);
                    editList.apply();
                    jTextComponent.setCaretPosition(n + 4);
                    jTextComponent.moveCaretPosition(n + 8);
                }
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPERATION {
        COMMENT_OUT,
        ADD_IF;

    }
}

